/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Logindlg.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#include "appconst.h"
#include "logindlg.h"
#include "resource.h"


LoginDialog::LoginDialog(View* parent, const char* title, Args& args)
		:ModalDialog(parent, title, 
			args.set(XmNtemplateName, MAKEINTRESOURCE(IDD_LOGIN)) 
			    .set(XmNcentering, TRUE) )

{
	addCallback(XmNactivateCallback, IDOK, this,
		(Callback)&LoginDialog::ok, NULL);
}


void LoginDialog::ok(Action& action)
{
	getItemText(IDC_HOST, hostName, sizeof(hostName));
	getItemText(IDC_USER, userName, sizeof(userName));
	getItemText(IDC_PASSWORD, password, sizeof(password));
	if(strlen(hostName) >0 && 
		strlen(userName)>0 && 
		strlen(password) >0) {
			end(TRUE);
			View* parent = getParent();
			parent -> post(WM_STARTSESSION, 0, 0);
	}
	else {
		MessageBeep(0);
	}
}

