/*********************************************************************

	solftp.h
				(C) Copyright 1997	TOSHIYUKI ARAI
				ALL RIGHTS RESERVED 
 ********************************************************************/

#ifndef _SOL_APPLICATIONVIEW
#include <sol\ApplicationView.h>
#endif

#ifndef _SOL_SCROLLEDRICHTEXT
#include <sol\scrolledRichText.h>
#endif
#ifndef _SOL_STATIC
#include <sol\Static.h>
#endif
#ifndef _SOL_FONT
#include <sol\Font.h>
#endif
#ifndef _SOL_RADIOBUTTON
#include <sol\RadioButton.h>
#endif

#ifndef _SOL_SOCKETSTREAM
#include <sol\SocketStream.h>
#endif

#ifndef _SOL_POPUPMENU
#include <sol\PopupMenu.h>
#endif

#ifndef _SOL_IMAGELIST
#include <sol\ImageList.h>
#endif

#ifndef _SOL_DIRTREEVIEW
#include "DirTreeV.h"
#endif

#ifndef _SOL_FILELISTVIEW
#include "FileLSV.h"
#endif

#ifndef _SOL_LOGINDIALOG
#include "LoginDlg.h"
#endif
						
#ifndef _SOL_SOLFTP
#define _SOL_SOLFTP

class SolFtp :public ApplicationView {
	// nextcommand
	enum {
		PORT,
		CWD,
		STOR,
		RETR,
		LIST,
	};

	enum {	
		LOGIN_REPLY_WAITING,	// Wating a reply after sending user-name password.
		CWD_REPLY_WAITING,		// Wating a reply after sending CWD command.
		PORT_REPLY_WAITING,		// Wating a reply after sending PORT command.
		STOR_REPLY_WAITING,		// Wating a reply after sending STOR command.
		RETR_REPLY_WAITING,		// Wating a reply after sending RETR command.
		LIST_REPLY_WAITING,		// Wating a reply after sending LIST command.
		READ_WAITING,			// 
		WRITE_WAITING,			//
		};

	BOOL		connected;
	int			state;
	int			putting;
	int			getting;
	int			dragging;
	
	int			iconId1;
	int			iconId2;
	int			fileImageId;
	int			nextCommand;

	HTREEITEM	 hcurrentRemoteItem;
	
	int			 localLastChangedItem;
	int			 remoteLastChangedItem;
	char		replyBuffer[1024];
	char		dataBuffer[1024];
	char		readBuffer[1024];

	Font*		  font;
	SocketStream* controlChannel;
	SocketStream* dataChannel;
	SocketStream* listenSocket;
	RadioButton*  binary;
	RadioButton*  ascii;

	LoginDialog* loginDlg;
	ImageList*   dirImageList;
	ImageList*   fileImageList;
	ImageList*	 imgList;
	ScrolledRichText* text;
	Static*      localLabel;
	Static*		 remoteLabel;

	DirTreeView* localTree;
	DirTreeView* remoteTree;
	FileListView* localFile;
	FileListView* remoteFile;
	PopupMenu*	dirPopupMenu;
	void	handleDirPopupMenu(Action& action);

	void	login(Action& action);
	long	listUpLocalFile(Event& event);
	void	listupRemoteFiles();
	void	listupRemoteFiles2();

	long	start(Event& event);
	void	localFileDrag(Action& action);
	void	remoteFileDrag(Action& action);

	void	disConnect(Action& action);
	long	size(Event& event);
	long    lButtonUp(Event& event);
	long    mouseMove(Event& event);
	long	select(Event& event);

	void	localNodeClicked(Action& action);
	void	remoteNodeClicked(Action& action);

	void	localTreeExpanding(Action& action);
	void	interpretCommand(char* command);

	int		sendCommand(char* command);
	int		readReply();
	void	putLocalFiles(char* fileName);
	void	getRemoteFiles(char* filename);

	BOOL	acceptDataConnection();
	SocketStream* createListenSocket();	
	BOOL	requestDataConnection(SocketStream* listenSocket);	

	BOOL	readData(char* fileName);
	BOOL	writeData(char* fileName);
public:
	SolFtp(Application& applet, const char* name, Args& args);
	~SolFtp();
};

#endif
