/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Mail.cpp
 *
 *****************************************************************************/



#include <sol\Stdio.h>
#include <sol\Date.h>

#include "Mail.h"


Mail::Mail(const char* subject1, const char* sender1,
					StringList& tos, StringList& ccs,
					StringList& bccs, const char* body1)
{
	subject = subject1;
	sender  = sender1;

	receiver.add(tos);
	receiver.add(ccs);
	receiver.add(bccs);

	header.clear();

	header.append("Date: ");
	Date date(False);
	header.append(date.getDate());
	header.append("\r\n");

	header.append("From: "); 
	header.append(sender1);
	header.append("\r\n");

	ListEntry* ptr = null;

	ListEntry* root = null;

	if (tos.getLength() > 0) {
		header.append("To: ");
		ptr = tos.getEntry();
		root = ptr;
		while (ptr) {
			String* s = (String*) ptr -> getObject();
			if (s != null && s ->getLength() > 1) {
				if (ptr != root) {
					header.append(",");		
				}
				header.append((char*)(*s));
			}
			ptr = ptr -> getNext();
		}
		header.append("\r\n");
	}

	if (ccs.getLength() > 0) {
		header.append("Cc: ");
		ptr = ccs.getEntry();
		root = ptr;
		while (ptr) {
			String* s = (String*) ptr -> getObject();
			if (s != null && s -> getLength() > 1) {
				if (ptr != root) {
					header.append(",");		
				}
				header.append((char*)(*s));
			}
			ptr = ptr -> getNext();
		}
		header.append("\r\n");
	}

	header.append("Subject: ");
	header.append(subject);
	header.append("\r\n");
	header.append("X-Mailer: SolMailer 1.0\r\n");
	header.append("Content-Type: text/plain\r\n");
	//; charset=iso-2022-jp\r\n");

	Printf("HEADER= [%s]\r\n", (char*)header.getBuffer());
	body.append(body1);
}
