/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	SolTrace.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.04.23


#include <sol\ApplicationView.h>
#include <sol\DesktopWindow.h>
#include <sol\FileDialog.h>
#include <sol\Font.h>
#include <sol\ScrolledRichText.h>
#include <sol\Mutex.h>
#include "resource.h"


class SolTracer :public ApplicationView {
	ScrolledRichText	text;
	FileDialog   		filedlg;
	Font				font;

	void	clear(Action& action) { text.clear();}
	void	dropped(Action& action);
	void	open(Action& action);
	void	save(Action& action);

	long	copyData(Event& event);
	long	close(Event& event);

 public:
	SolTracer(Application& applet, const char* name, Args& args);
};


SolTracer::SolTracer(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args	ar;
	ar.set(XmNexStyle, (ulong)WS_EX_ACCEPTFILES);
	text.create(this, "", ar);
	text.setEventMask(ENM_DROPFILES);
	text.addCallback(XmNdropFilesCallback, this,
		(Callback)&SolTracer::dropped, NULL);
	text.exLimitText(500*1000);	// 500K bytes
	add(text);

	ar.reset();
	ar.set(XmNfaceName, "FixedSys");
	font.create(ar);
	text.setFont(font);

	addCallback(XmNmenuCallback, ID_NEW, this,
		(Callback)&SolTracer::clear, NULL);
	addCallback(XmNmenuCallback, ID_OPENTEXT, this,
			(Callback)&SolTracer::open, NULL);

	addCallback(XmNmenuCallback, ID_SAVEASTEXT, this,
			(Callback)&SolTracer::save, NULL);
	addCallback(XmNmenuCallback, ID_EXIT, this,
			(Callback)&SolTracer::exit, NULL);

	addEventHandler(WM_COPYDATA, this,
			(Handler)&SolTracer::copyData, NULL);

	addEventHandler(WM_CLOSE, this,
		(Handler)&SolTracer::close, NULL);

	ar.reset();
	filedlg.create(this, NULL, ar);

	DesktopWindow desktopw;
	desktopw.setProp("SOL_TRACER", (HANDLE)getWindow());

	restorePlacement();
}



long SolTracer::close(Event& event)
{
	DesktopWindow desktopw;
	desktopw.removeProp("SOL_TRACER");
	savePlacement();
	return defaultProc(event);
}


void SolTracer::open(Action& action)
{
	filedlg.setCaption("Open");
	if (filedlg.open()) {
		char* filename  = filedlg.getFileName();
		text.streamIn(filename, SF_TEXT);
	}
}


void SolTracer::save(Action& action)
{
	filedlg.setCaption("Save");
	if (filedlg.save()) {
		char* filename  = filedlg.getFileName();
		text.streamOut(filename, SF_TEXT);
	}
}


void SolTracer::dropped(Action& action)
{
	Event& event = action.getEvent();
	ENDROPFILES* endrop = (ENDROPFILES*)event.getLParam();
	HDROP hdrop = (HDROP)endrop->hDrop;
	char filename[_MAX_PATH];
	DragQueryFile(hdrop, 0, filename, sizeof(filename));
	text.streamIn(filename, SF_TEXT|SFF_SELECTION);
}



long	SolTracer::copyData(Event& event)
{
	int	rc = 0;
	COPYDATASTRUCT* cp = (COPYDATASTRUCT*)event.getLParam();
	if (cp) {
		if (cp->lpData) {
			text.append((const char*)cp->lpData);
			text.send(WM_VSCROLL,SB_BOTTOM,0);
			text.send(WM_VSCROLL,SB_PAGEUP,0);
		}
	}
	return 1;
}




// Tracer Main
void	Main(int argc, char** argv)
{
	static char* appClass = "SolTracer";
	Application applet(appClass, argc, argv);
		
	HWND hwnd = FindWindow(appClass, appClass);
	if(hwnd == NULL) {
		Mutex mutex(NULL, TRUE, appClass);
		if(mutex.wait() == WAIT_OBJECT_0) {
		
			Args args;
			args.set(XmNclassName, appClass);
			SolTracer tracer(applet, appClass, args);
			tracer.realize();
			applet.run();
		}
	}
	else {
		SetForegroundWindow(hwnd);
	}
}

