/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	StopWatch.cpp
 *
 *****************************************************************************/


#include <sol\Application.h>
#include <sol\Thread.h>
#include <sol\Stdio.h>


class StopWatch :public Thread {
    int     seconds;
  public:
    StopWatch(int interval) {
        seconds = interval;
    }

    void run() {
	int n = 0;
	while (n < seconds) {
  		sleep(1000); 
		// Do something here.
		Printf("StopWatch %d\r\n", n++);
        }
    }
};


void Main(int argc, char** argv)
{
    const char* appClass = "StopWatch";
    Application applet(appClass, argc, argv);

    StopWatch stopWatch(10);  // Create an instance of StopWatch
    stopWatch.start();        // Start the thread.
    stopWatch.wait();         // Wait the termination. 

    MessageBox(NULL, "Thread terminated", "StopWatch", MB_OK);
}
