/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	String.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000/11/11

#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\Stdio.h>

#include "resource.h"


class StringHandler :public ApplicationView {
	ScrolledText sctext;
	void	clear(Action& action) { sctext.setText(""); }
	long	close(Event& event);

  public:
	StringHandler(Application& applet, const char* name, Args& args);
};


StringHandler::StringHandler(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args ar;


	ar.reset();
	sctext.create(this, "", ar);
	// Add sctext to the default layout manager.
	add(&sctext);

	sctext.limitText(32000); 
	sctext.addCallback(XmNmaxTextCallback, this, (Callback)&StringHandler::clear, null);
		
	addCallback(XmNmenuCallback, ID_CLEAR, this, 
		(Callback)&StringHandler::clear, null);
	addCallback(XmNmenuCallback, ID_EXIT, this, 
		(Callback)&StringHandler::exit, null);

	String a("http");
	a = a + "://";
	a = a + "www.antillia.com:";
	a = a + 80;
	a = a + "/index.html";

	sctext.append("\r\n1 Concatination\r\n");
	sctext.append(a+"\r\n");

	String b("10.0/3.0");
	b = b + "=";
	b = b + float(10.0/3.0);
	sctext.append("\r\n2 Concatination\r\n");
	sctext.append(b+"\r\n");
	
	String string("Hello World");
	if (string.equalsIgnoreCase("heLLo wORLD")) {
		sctext.append("\r\n3 equalsIgnoreCase \r\n");
		sctext.append(string + " is matched heLLO wORLD" + "\r\n");

	}
	sctext.append("\r\n4 Trimming\r\n");
	String url("	http://www.antillia.com/antillia/index.html		");
	sctext.append(url);
	sctext.append("\r\n");
	url.trim();
	sctext.append(" trimmed ");
	sctext.append(url);
	sctext.append("\r\n");

	if (url.startsWith("http")) {
		sctext.append("\r\n5 startsWith\r\n");
		sctext.append(url);
		sctext.append(" starts with http\r\n");
	}

	if (url.endsWith("index.html") ) {
		sctext.append("\r\n6 endsWith\r\n");

		sctext.append(url);
		sctext.append(" ends with index.html\r\n");
		sctext.append("\r\n");
	}

	const char* result = null;
	if ((result = url.findLast("antillia"))) {
		sctext.append("\r\n7 findLast\r\n");

		sctext.append(url);
		sctext.append(" findLast antillia \r\n");
		sctext.append(result);
		sctext.append("\r\n");
	}

}




// StringHandler Main
void	Main(int argc, char** argv)
{
	const char* appClass = "StringHandler";
	Application applet(appClass, argc, argv);
		
	Args args;
	args.set(XmNclassName, appClass);
	StringHandler stringHandler(applet, appClass, args);
	stringHandler.realize();
	applet.run();

}
