/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Tab.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\paintdc.h>
#include <sol\tab.h>
#include <sol\stdio.h>
#include <sol\DrawingArea.h>


class Canvas : public DrawingArea {
	int shape;
	void expose(Action& action);
public:
	Canvas():DrawingArea() { }
	Canvas(View* parent, const char* name, Args& args);
	virtual Boolean create(View* parent, const char* name, Args& args);

	void setShapeType(int type);
};


void Canvas::expose(Action& action)
{
	int	i;
	DC* dc = (DC*)action.getValue();
	switch(shape) {
	case 0:
		for(i = 0; i<30; i++) {
			dc->select(GetStockObject(NULL_BRUSH));
			dc->rectangle(10, 10, 10+10*i, 10+10*i);
		}
		break;
	case 1:
		for(i = 0; i<30; i++) {
			dc->select(GetStockObject(NULL_BRUSH));
			dc->ellipse(10, 10, 10+10*i, 10+10*i);
		}
		break;
	case 2:
		for(i = 0; i<30; i++) {
			dc->moveTo(10, 10);
			dc->lineTo(300, 10+10*i);
		}
		for(i = 0; i<30; i++) {
			dc->moveTo(10, 10);
			dc->lineTo(10+10*i, 300);
		}

		break;

	default:
		break;
	}
}


Canvas::Canvas(View* parent, const char* name, Args& args)
	:DrawingArea(parent, name, args) 
{
	shape = 0;
	addCallback(XmNexposeCallback, this,
		(Callback)&Canvas::expose, NULL);
}


Boolean Canvas::create(View* parent, const char* name, Args& args)
{
	Boolean rc = DrawingArea::create(parent, name, args); 

	shape = 0;
	addCallback(XmNexposeCallback, this,
		(Callback)&Canvas::expose, NULL);
	return rc;
}

void Canvas::setShapeType(int type)
{
	shape = type;
	//invalidate(NULL);
	update(NULL);
}


class AppView :public ApplicationView {
	static char* tabLabels[];
	Tab		tab;
	Canvas	canvas;

	long	size(Event& event);
	void	select(Action& action);
  public:
	AppView(Application& applet, const char* label, Args& args);
};


char* AppView::tabLabels[] = {
	"Rectangle","Circle","Line",
};


long AppView::size(Event& event) 
{
	LPARAM l = event.getLParam();
	tab.reshape(10, 10, LOWORD(l)-20, HIWORD(l)-20);
	RECT r;
	tab.getClientRect(&r);
	canvas.reshape(10, 50, r.right -20, r.bottom -60);
	return 0;
}

void AppView::select(Action& action)
{
	int indx = tab.getCurFocus();
	canvas.setShapeType(indx);
}

AppView::AppView(Application& applet, const char* label, Args& args)
	:ApplicationView(applet, label, 
		args.set(XmNbackground, (ulong)(COLOR_BTNFACE+1)))
{
	Args ar;
	ar.reset();
	tab.create(this, "", ar);
	tab.setItemSize(50, 20);

	ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	canvas.create(&tab, "", ar);

	for(int i = 0; i<XtNumber(tabLabels); i++) {
   		tab.addItem(tabLabels[i]);
	}

	tab.setCurFocus(0);
	tab.addCallback(XmNselChangeCallback, this,
		(Callback)&AppView::select, NULL);
	canvas.setShapeType(0);
}


// 
void	Main(int argc, char** argv)
{
	const char* name = "HelloView";
	Application applet(name, argc, argv);

	Args args;
	AppView appview(applet, name, args);
	appview.realize();

	applet.run();
}

