/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	TypeTrainer.h
 *
 *****************************************************************************/



#include <sol\ApplicationView.h>
#include <sol\Pushbutton.h>
#include <sol\Label.h>

#include <sol\Static.h>
#include <sol\ListBox.h>
#include <sol\Font.h>

#include "TextSheet.h"
#include "KeyButton.h"

#ifndef _SOL_TYPETRAINER
#define _SOL_TYPETRAINER

class TypeTrainer :public ApplicationView {
	static int Off;
	static int On;
	static int Pause;
	static int Run;

	static int LowSpeed;	//	1300
	static int MiddleSpeed;	// 	1000
	static int HighSpeed;	//	 700

	int		max;
	int		count;
	int		score;
	int		timerId;
	int		sizeArray[1];
	Font	font;

	ListBox    scoreList;
	KeyButton keySet[100];
	HWND	prevKey;
	HWND	pressedKey;
	int		mode;
	char*	machine;
	char*	user;
	int		machineCounter;
	int		userCounter;
	int		timer;
	int		interval;

	Static    speedLabel;
	Static    scoreLabel;
  	TextSheet sourceText;
	TextSheet userText;
	int		finger;
	StatusBar* statusbar;

	void 	clear(Action& param);
	void 	quit(Action& param);
	void 	setSpeed(Action& param);
	void 	createKeyBoard(int x, int y);
	void 	scoreToListBox();
	int  	generateRandomKey();
	void 	displayScore();
	void 	manageCharInput(WORD charCode);
	void	invertKey(HWND hwnd);

	HWND	getPrevKey();
 
	long	timeout(Event& event);
	long	charInput(Event& event);
	void 	setFinger(Action& param);
	char*	getActiveKeySet();
	void	initialize();
	long	size(Event& event);
	
 public:
	TypeTrainer(Application& applet, const char* caption, Args& args); 
	~TypeTrainer();
};

#endif
