/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Explorer.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.05.30

#include <sol\ApplicationView.h>
#include <sol\TreeView.h>


class WinTree :public ApplicationView {
	TreeView  treev;
	
	void	update(Action& action) {
			build();		
	}

	void	build() {
		treev.deleteAllItems();

		HTREEITEM root = treev.addItem(NULL, TVI_ROOT, "Desktop");
		HWND desktop = ::GetDesktopWindow();

		find(root, desktop);		
		treev.sortChildren(root, TRUE);
		treev.expand(root, TVE_EXPAND);
	}

	void	find (HTREEITEM parent, HWND hwnd) {
		HTREEITEM item = (HTREEITEM)TVI_FIRST;

		if (hwnd == NULL) {
			return;
		}
		char name[MAX_PATH/2];
		char string[MAX_PATH*2];
		char title[MAX_PATH];
		HWND next = ::GetWindow(hwnd, GW_CHILD);

		while (next) {

			::GetClassName(next, name, sizeof(name));
			::GetWindowText(next, title, sizeof(title));

			sprintf(string, "[%08X] \"%s\" %s", next, title, name);
			item = treev.addItem(parent, item, string);
			find(item, next);
			next = GetWindow(next, GW_HWNDNEXT);
		}
	}
	
  public:
	// Constructor
	  WinTree(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, 
			args.set(XmNbackground, (ulong)(COLOR_BTNFACE+1))	)
	{
		addCallback(XmNmenuCallback, 1000, this,
				(Callback)&WinTree::update, NULL);
		addCallback(XmNmenuCallback, 1001, this,
				(Callback)&WinTree::exit, NULL);

		Args ar;

		ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
		ar.set(XmNstyle, TVS_HASBUTTONS|TVS_HASLINES|TVS_LINESATROOT);
		treev.create(this, "", ar);
		
		add(treev);		

		build();
	}
};


void	Main(int argc, char** argv)
{
	const char* appClass = "WinTree";
	Application applet(appClass, argc, argv);

	Args args;
	WinTree winTree(applet, appClass, args);
	winTree.realize();

	applet.run();
}

