/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Stdio.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.05.03 Removed Trace function and added print and println.

#include <stdio.h>
#include <windows.h>
#include <stdarg.h>
#include <richedit.h>

#include <sol\CriticalSection.h>

static CriticalSection cs;

static CriticalSection ex;

void Printf(char* format,...)
{
	cs.enter();

	static char buffer[1024];

	va_list pos;
	va_start(pos, format);
	vsprintf(buffer, format, pos);
	va_end(pos);

	HWND root = ::GetDesktopWindow();
	HWND hwnd = (HWND)::GetProp(root, "SCROLLED_TEXT");

	if(hwnd && ::IsWindow(hwnd) && ::IsWindowVisible(hwnd) ) {
		unsigned int len = (unsigned int)::SendMessage(hwnd, WM_GETTEXTLENGTH, 0, 0L);
		unsigned int max = (int)::SendMessage(hwnd, EM_GETLIMITTEXT, 0,0);

		if((len + strlen(buffer))>= max) {
			int visibleLine =(int)::SendMessage(hwnd, 
									EM_GETFIRSTVISIBLELINE, 0, 0);
			unsigned int charPos =(unsigned int)::SendMessage(hwnd, 
						EM_LINEINDEX, visibleLine,0);
			::SendMessage(hwnd, EM_SETSEL, 0, charPos);

			::SendMessage(hwnd, WM_CLEAR, 0, 0);
			len = (int)::SendMessage(hwnd, WM_GETTEXTLENGTH, 0, 0L);
		}

		::SendMessage(hwnd, EM_SETSEL, len, len);
		::SendMessage(hwnd, EM_REPLACESEL, 0, (LPARAM)buffer);
		::SendMessage(hwnd, WM_SETREDRAW, 1, 0L);
	}

	cs.leave();
}

/*

*/


// <added date="2000.05.03" author="to-arai">
// This print and println function writes a string into a window of SolTracer program.

void print(char* format,...)
{
	ex.enter();

	static char buffer[1024];

	va_list pos;
	va_start(pos, format);
	vsprintf(buffer, format, pos);
	va_end(pos);

	HWND root = ::GetDesktopWindow();
	HWND hwnd = (HWND)::GetProp(root, "SOL_TRACER");

	if(hwnd && ::IsWindow(hwnd) && ::IsWindowVisible(hwnd) ) {
		COPYDATASTRUCT cp;
		memset(&cp, 0, sizeof(cp));
		cp.cbData = strlen(buffer); 
		cp.lpData = buffer;
		::SendMessage(hwnd, WM_COPYDATA, 0, (LPARAM)&cp);
	}

	ex.leave();
}

void println(char* format,...)
{
	ex.enter();

	static char buffer[1024];

	va_list pos;
	va_start(pos, format);
	vsprintf(buffer, format, pos);
	va_end(pos);
	strcat(buffer, "\r\n");

	HWND root = ::GetDesktopWindow();
	HWND hwnd = (HWND)::GetProp(root, "SOL_TRACER");

	if(hwnd && ::IsWindow(hwnd) && ::IsWindowVisible(hwnd) ) {
		COPYDATASTRUCT cp;
		memset(&cp, 0, sizeof(cp));
		cp.cbData = strlen(buffer); 
		cp.lpData = buffer;
		::SendMessage(hwnd, WM_COPYDATA, 0, (LPARAM)&cp);
	}

	ex.leave();
}
//</added>
