/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	StringBuffer.h
 *
 *****************************************************************************/

// SOL++2000
// 2000/11/11

#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif
#ifndef _SOL_STRING
#include <sol\String.h>
#endif

#ifndef _SOL_STRINGBUFFER
#define _SOL_STRINGBUFFER

class StringBuffer :public Object{
	char*	buffer;
	int		size;
	int		increment;
	int		position;
  public:
	StringBuffer(int s =256, int inc = 8);
	~StringBuffer();
	void clear();
	Boolean append(char ch);
	// 1999.07.25
	Boolean append(const char* string);

	//<added date="2000/11/10">
	Boolean append(String& string);
	Boolean append(int num);
	Boolean append(float num);
	String*	newString();
	//</added>

	// 1999.08.07
	const char*	find(const char* string);

	const char* getBuffer() { return buffer; }
	String*		getString() { return new String(buffer); }
	int			getSize()   { return size; }
	int			getContentSize() { return position; }

};

#endif

