/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	SystemColor.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\SystemColor.h>

ColorItem SystemColor::colors[] = {
	{"COLOR_ACTIVEBORDER", 		COLOR_ACTIVEBORDER},
	{"COLOR_ACTIVECAPTION",		COLOR_ACTIVECAPTION},
	{"COLOR_APPWORKSPACE",		COLOR_APPWORKSPACE},

	{"COLOR_BACKGROUND",		COLOR_BACKGROUND},
	{"COLOR_BTNFACE",			COLOR_BTNFACE},
	{"COLOR_BTNSHADOW",			COLOR_BTNSHADOW},
	{"COLOR_BTNTEXT",			COLOR_BTNTEXT},
	{"COLOR_CAPTIONTEXT",		COLOR_CAPTIONTEXT},
	{"COLOR_GRAYTEXT",			COLOR_GRAYTEXT},

	{"COLOR_HIGHLIGHT",			COLOR_HIGHLIGHT},
	{"COLOR_HIGHLIGHTTEXT",		COLOR_HIGHLIGHTTEXT},
	{"COLOR_INACTIVEBORDER",	COLOR_INACTIVEBORDER},
	{"COLOR_INACTIVECAPTION",	COLOR_INACTIVECAPTION},
	{"COLOR_MENU",				COLOR_MENU},
	{"COLOR_MENUTEXT",			COLOR_MENUTEXT},
	{"COLOR_SCROLLBAR",			COLOR_SCROLLBAR},
	{"COLOR_WINDOW",			COLOR_WINDOW},
	{"COLOR_WINDOWFRAME",		COLOR_WINDOWFRAME},
	{"COLOR_WINDOWTEXT",		COLOR_WINDOWTEXT},
	};


SystemColor::SystemColor()
	:HashTable(113)
{
	for(int i = 0; i<XtNumber(colors); i++) {
		add(colors[i].name, (Object*)&colors[i]);
	}
}


BOOL SystemColor::get(const char* name, long* value)
{
	ColorItem* colorItem  = (ColorItem*) lookup(name);
	if(colorItem) {
		int indx = (int)colorItem ->value;
		*value   = ::GetSysColor(indx);
		return TRUE;
	}
	else return FALSE;
}

