/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Text.h
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.03 Added getStringList method.
// 2000.02.18

#ifndef _SOL_PRIMITIVE
#include <sol\Primitive.h>
#endif

#ifndef _SOL_STRINGLIST
#include <sol\StringList.h>
#endif

#ifndef _SOL_TEXT
#define _SOL_TEXT

class Text :public Primitive {
	static Arg styles[];
  public:

	Text(): Primitive() { }
	Text(View* parent, HWND hwnd)
		:Primitive(parent, hwnd) { }

	Text(View* parent, const char* name, Args& args);

	virtual Boolean create(View* parent, const char* name, Args& args);

	virtual void 	add(const char* string);
	virtual void	append(const char* string);
	// 1999.08.19
	virtual void	printf(const char* format,...);

	int		canUndo() {
			return (int)send(EM_CANUNDO, 0, 0L);
	}
	void 	clear() {
			setText("");
	}
	void 	copy() {
			send(WM_COPY, 0, 0L);
	}
	void 	cut() {
			send(WM_CUT, 0, 0L);
	}
	void	emptyUndoBuffer() {
			send(EM_EMPTYUNDOBUFFER, 0, 0L);
	}

	void	enableWriting() {
			send(EM_SETREADONLY, FALSE, 0L);
	}

	int		fmtLines(int fmt) {
			return (int)send(EM_FMTLINES, fmt, 0L);
	}

	Arg* 	getCallbackTable(int* num);

	int		GetFirstVisibleLine() {
			return (int)send(EM_GETFIRSTVISIBLELINE, 0, 0L);
	}

	HANDLE	getHandle() {
			return (HANDLE)send(EM_GETHANDLE, 0, 0L);
	}

	int 	getLine(int n, char* string, int num);	

	int  	getLineCount() {
			return (int)send(EM_GETLINECOUNT, 0, 0L);
	}

	// 1999.09.03
	int		getStringList(StringList& list);

	int		getModify() {
			return (int)send(EM_GETMODIFY, 0, 0L);
	}
	char	getPasswordChar() {
			return (char)send(EM_GETPASSWORDCHAR, 0, 0L);
	}
	void	getRect(RECT* rect) {
			send(EM_GETRECT, 0, (LPARAM)rect);
	}

	void 	getSel(int* start, int* end);

	int		getTextLength() {
			return (int)send(WM_GETTEXTLENGTH, 0, 0L);
	}
	EDITWORDBREAKPROC  getWordBreakProc() {
			return (EDITWORDBREAKPROC)send(EM_GETWORDBREAKPROC, 0, 0L);
	}
	void	getValues(Args& args);

	BOOL	load(char* filename);

	void 	limitText(int len) {
			send(EM_LIMITTEXT, len, 0L);
	}
	int  	lineFromChar(int pos) {
			return (int)send(EM_LINEFROMCHAR, pos, 0L);
	}
	int  	lineIndex(int line) {
			return (int)send(EM_LINEINDEX, line, 0L);
	}
	int		lineLength(int indx) {
			return (int)send(EM_LINELENGTH, indx, 0L);
	}
	void	lineScroll(int vert, int horiz) {
			send(EM_LINESCROLL, horiz, vert);
	}
	void 	paste() {
			send(WM_PASTE, 0, 0L);
	}
	void 	replaceSel(const char* string) {
			send(EM_REPLACESEL, 0, (LPARAM)string);
	}
	BOOL	save(char* filename);

	void	setHandle(WORD handle) {
			send(EM_SETHANDLE, handle, 0L);
	}
	void	setModify(int flag) {
			send(EM_SETMODIFY, flag, 0L);
	}
	void	setPasswordChar(int ch) {
			send(EM_SETPASSWORDCHAR, ch, 0L);
	}
	void	setReadOnly() {
			send(EM_SETREADONLY, TRUE, 0L);
	}			   

	void	setRect(LPRECT rect) {
			send(EM_SETRECT, 0, (LPARAM)rect);
	}
	void	setRectNP(LPRECT rect) {
			send(EM_SETRECTNP, 0, (LPARAM)rect);
	}
	void	setSel(int start, int end) {
			send(EM_SETSEL, start, end);
	}
	int		setTabStops(int num, int pos[]) {
			return (int)send(EM_SETTABSTOPS, num, (LPARAM)pos);
	}
	void	setValues(Args& args);

	int		setWordBreakProc(FARPROC proc) {
			return (int)send(EM_SETWORDBREAKPROC, 0, (LPARAM)proc);
	}
	int		undo() {
			return (int)send(EM_UNDO, 0, 0L);
	}
	void 	scroll(int action) {
	 		send(EM_SCROLL, (WPARAM)action, 0L);
	}	
	void 	scrollCaret() {
	 		send(EM_SCROLLCARET, 0, 0L);
	}

	DWORD	getMargins() {
			return (DWORD)send(EM_GETMARGINS, 0, 0);
	}
	void	setLimitText(int length) {
			send(EM_SETLIMITTEXT, length, 0L);
	}
	int		getLimitText() {
			return send(EM_GETLIMITTEXT, 0, 0L);
	}
	int		getThumb() {
			return send(EM_GETTHUMB, 0, 0);
	}
	DWORD	posFromChar(int charIndex) {
			return send(EM_POSFROMCHAR, (WPARAM)charIndex, 0);
	}
	void	setMargins(int flag, WORD left, WORD right) {
			send(EM_SETMARGINS, (WPARAM)flag, MAKELONG(left, right));
	}
};

#endif

