/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ToolBar.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_PRIMITIVE
#include <sol\Primitive.h>
#endif

#ifndef _SOL_TOOLBAR
#define _SOL_TOOLBAR


class ToolBar :public Primitive {
	static TBBUTTON buttons[];
  public:
	ToolBar():Primitive() { }
  	ToolBar(View* parent, const char* name, Args& args);

  	virtual Boolean create(View* parent, const char* name, Args& args);

	BOOL	addBitmap(int num, TBADDBITMAP* bitmaps) {
			return (BOOL)send(TB_ADDBITMAP, num, (LPARAM)bitmaps);
	}
 
	BOOL	addButtons(int num, TBBUTTON* buttons) {
			return (BOOL)send(TB_ADDBUTTONS, num, (LPARAM)buttons);
	}
	int		addString(const char* strings) {
			return (int)send(TB_ADDSTRING, 0, (LPARAM)strings);
	}
	void	autoSize() {
			send(TB_AUTOSIZE, 0, 0);
	}
	int		buttonCount() {
			return (int)send(TB_BUTTONCOUNT, 0, 0L);
	}
	void	buttonStructSize() {
			send(TB_BUTTONSTRUCTSIZE, sizeof(TBBUTTON), 0L);
	}
	void	changeBitmap(int id, int idBitmap ) {
	 		send(TB_CHECKBUTTON, id, idBitmap);
	}
	void	checkButton(int id) {
	 		send(TB_CHECKBUTTON, id, TRUE);
	}

	int		commandToIndex(int cmd) {
			return (int)send(TB_COMMANDTOINDEX, cmd, 0L);
	}
	void 	customize() {
			send(TB_CUSTOMIZE, 0, 0);
	}

	BOOL 	deleteButton(int id) {
			return (BOOL)send(TB_DELETEBUTTON, id, 0L);
	}
	BOOL 	disableButton(int id) {
	 		return (BOOL)send(TB_ENABLEBUTTON, id, FALSE);
	}
	BOOL 	enableButton(int id) {
	 		return (BOOL)send(TB_ENABLEBUTTON, id, TRUE);
	}

	BOOL 	getButton(int id, TBBUTTON* lpb) {
			return (BOOL)send(TB_GETBUTTON, id, (LPARAM)lpb);
	}
	int 	getButtonText(int id, char* text) {
			return (int)send(TB_GETBUTTONTEXT, id, (LPARAM)text);
	}
	int  	getBitmap(int id) {
			return (int)send(TB_GETBITMAP, id, 0);
	}
	Arg* 	getCallbackTable(int* num);

	int	 	getBitmapFlags() {
			return (int)send(TB_GETBITMAPFLAGS, 0, 0);
	}
	int		getHeight();

	BOOL 	getItemRect(int id, RECT* rect) {
			return (BOOL)send(TB_GETITEMRECT, id, (LPARAM)rect);
	}
	int		getRows() {
			return (int)send(TB_GETROWS, 0, 0);
	}
	BOOL	getState(int id) {
			return (BOOL)send(TB_GETSTATE, id, 0L);
	}

	HWND	getTooltips() {
			return (HWND)send(TB_GETTOOLTIPS, 0, 0);
	}
	void 	hideButton(int id) {
	 		send(TB_HIDEBUTTON, id, TRUE);
	}

	BOOL 	indeterminate(int id, BOOL flag) {
			return (BOOL)send(TB_INDETERMINATE, id, flag); 
	}
	BOOL 	insertButton(int id, TBBUTTON* tbbutton) {
			return (BOOL)send(TB_INSERTBUTTON, id, (LPARAM)tbbutton);
 	}

	BOOL 	isButtonEnabled(int id) {
			return (BOOL)send(TB_ISBUTTONENABLED, id, 0L);
	}
	BOOL 	isButtonChecked(int id) {
			return (BOOL)send(TB_ISBUTTONCHECKED, id, 0L);
	}
	BOOL 	isButtonPressed(int id) {
			return (BOOL)send(TB_ISBUTTONPRESSED, id, 0L);
	}
	BOOL 	isButtonHidden(int id) {
			return (BOOL)send(TB_ISBUTTONHIDDEN, id, 0L);
	}
	BOOL 	isButtonIndeterminate(int id) {
			return (BOOL)send(TB_ISBUTTONINDETERMINATE, id, 0L);
	}
	void 	pressButton(int id) {
	 		send(TB_PRESSBUTTON, id, TRUE);
	}

	BOOL 	setBitmapSize(int dx, int dy) {
			return (BOOL)send(TB_SETBITMAPSIZE, 0, MAKELONG(dx, dy));
	}
	BOOL 	setButtonSize(int dx, int dy) {
			return (BOOL)send(TB_SETBUTTONSIZE, 0, MAKELONG(dx, dy));
	}
	BOOL 	setCmdId(int indx, int cmdId) {
   			return (BOOL)send(TB_SETCMDID, indx, cmdId);
	}
	void 	setParent(HWND parent) {
			send(TB_SETPARENT, (WPARAM)parent, 0);
	}
	void 	setRows(int rows, int flag, RECT* rc) {
			send(TB_SETROWS, MAKELONG(rows, flag), (LPARAM)rc);
	}

	void 	setState(int id) {
			send(TB_SETSTATE, id, 0);
	}
	void 	setTooltips(HWND tooltip) {
			send(TB_SETTOOLTIPS, (WPARAM)tooltip, 0);	
	}
	void	setValues(Args& args);

	void 	showButton(int id) {
	 		send(TB_HIDEBUTTON, id, FALSE);
	}

	void 	ynCheckButton(int id) {
	 		send(TB_CHECKBUTTON, id, FALSE);
	}
	void 	unpressButton(int id) {
	 		send(TB_PRESSBUTTON, id, FALSE);
	}
};

#endif
