/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ToolHelp.h
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Object.h>
#include <sol\LinkedList.h>
#include <tlhelp32.h>

#ifndef _SOL_TOOLHELP
#define _SOL_TOOLHELP

typedef	HANDLE (WINAPI *SNAPSHOT)(DWORD, DWORD);
typedef	BOOL   (WINAPI *SNAPSHOT_THREAD)(HANDLE, LPTHREADENTRY32);
typedef	BOOL   (WINAPI *SNAPSHOT_PROCESS)(HANDLE, LPPROCESSENTRY32);
typedef	BOOL   (WINAPI *SNAPSHOT_MODULE)(HANDLE, LPMODULEENTRY32);
typedef	BOOL   (WINAPI *SNAPSHOT_HEAPLIST)(HANDLE, LPHEAPLIST32);
typedef	BOOL   (WINAPI *SNAPSHOT_HEAP)(LPHEAPENTRY32, DWORD, DWORD);
typedef	BOOL   (WINAPI *SNAPSHOT_HEAPNEXT)(LPHEAPENTRY32);

class ToolHelp :public Object {

  private:
	HMODULE		     hKernel;
	SNAPSHOT		 _createToolHelp;
	SNAPSHOT_THREAD  _firstThread;
	SNAPSHOT_THREAD	 _nextThread;
	SNAPSHOT_PROCESS _firstProcess;
	SNAPSHOT_PROCESS _nextProcess;
	SNAPSHOT_MODULE  _firstModule;
	SNAPSHOT_MODULE  _nextModule;
	SNAPSHOT_HEAP    _firstHeap;
	SNAPSHOT_HEAPNEXT _nextHeap;

	SNAPSHOT_HEAPLIST _firstHeapList;
	SNAPSHOT_HEAPLIST _nextHeapList;

	BOOL	isWindowsNT();
	void	initialize();
	BOOL	getHeapSize(DWORD processID, DWORD* size);

	BOOL	getModuleEntry(DWORD dwProcessId, 
					DWORD dwModuleId, LPMODULEENTRY32 lpme32);

	HANDLE WINAPI createToolHelp(DWORD dwFlags, DWORD dwth32ProcessID) {
		return (*_createToolHelp)(dwFlags, dwth32ProcessID);
	}
	BOOL WINAPI firstThread(HANDLE hSnapshot, LPTHREADENTRY32 lpte32) {
		return (*_firstThread)(hSnapshot, lpte32);
	}

	BOOL WINAPI nextThread(HANDLE hSnapshot, LPTHREADENTRY32 lpte32) {
		return (*_nextThread)(hSnapshot, lpte32);
	}

	BOOL WINAPI firstProcess(HANDLE hSnapshot, LPPROCESSENTRY32 lppe32) {
		return (*_firstProcess)(hSnapshot, lppe32);
	}

	BOOL WINAPI nextProcess(HANDLE hSnapshot, LPPROCESSENTRY32 lppe32) {
		return (*_nextProcess)(hSnapshot, lppe32);
	}

	BOOL WINAPI firstModule(HANDLE hSnapshot, LPMODULEENTRY32 lpme32) {
		return (*_firstModule)(hSnapshot, lpme32);
	}

	BOOL WINAPI nextModule(HANDLE hSnapshot, LPMODULEENTRY32 lpme32) {
		return (*_nextModule)(hSnapshot, lpme32);
	}

	BOOL WINAPI firstHeap(LPHEAPENTRY32 lpme32, DWORD procID, DWORD heapID) {
		return (*_firstHeap)(lpme32, procID, heapID);
	}
	BOOL WINAPI nextHeap(LPHEAPENTRY32 lpme32) {
		return (*_nextHeap)(lpme32);
	}

	BOOL WINAPI firstHeapList(HANDLE hSnapshot, LPHEAPLIST32 lpme32) {
		return (*_firstHeapList)(hSnapshot, lpme32);
	}
	BOOL WINAPI nextHeapList(HANDLE hSnapshot, LPHEAPLIST32 lpme32) {
		return (*_nextHeapList)(hSnapshot, lpme32);
	}

public:
	ToolHelp();
	~ToolHelp();

	void getProcessList(LinkedList& list);
};

#endif
