/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ToolTips.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\ToolTips.h>


ToolTips::ToolTips(View* parent, const char* label, Args& args)
	:PopupView(parent, label,
			args.set(XmNpredefined, TRUE)
			    .set(XmNclassName, (ulong)TOOLTIPS_CLASS))
{
}


Boolean ToolTips::create(View* parent, const char* label, Args& args)
{
	return PopupView::create(parent, label,
			args.set(XmNpredefined, TRUE)
			    .set(XmNclassName, (ulong)TOOLTIPS_CLASS));
}

Arg* ToolTips::getCallbackTable(int* num)
{
	static Arg table[] = {
	{XmNneedTextCallback, 	TTN_NEEDTEXT},
	{XmNpopupCallback,		TTN_POP},
	{XmNshowCallback,		TTN_SHOW},
 	};

	*num = XtNumber(table);
	return table;
}


void ToolTips::addTool(View* parent, View* target, char* text, UINT flags) 
{
	if(parent && target) {
		TOOLINFO ps;
		memset(&ps, 0, sizeof(ps));
		ps.cbSize = sizeof(ps);
		ps.hwnd   = parent -> getWindow();	
		ps.uFlags =	flags;	
		ps.lpszText = text;
		ps.uId      = (UINT)target->getWindow();
		send(TTM_ADDTOOL, 0, (LPARAM)&ps);
	}
}

