/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	TreeView.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_PRIMITIVE
#include <sol\Primitive.h>
#endif
#ifndef _SOL_IMAGELIST
#include <sol\ImageList.h>
#endif
#ifndef _SOL_TREEITEM
#include <sol\TreeItem.h>
#endif

#ifndef _SOL_TREEVIEW
#define _SOL_TREEVIEW

class TreeView :public Primitive {
  public:
	TreeView():Primitive()  { }
  	TreeView(View* parent, const char* name, Args& args);
	
	virtual Boolean create(View* parent, const char* name, Args& args);

 	Arg* 	getCallbackTable(int* num);
	HTREEITEM addItem(HTREEITEM parent, HTREEITEM after, TreeItem* treeItem);

	HTREEITEM addItem(HTREEITEM parent, HTREEITEM after, char* text);

	HTREEITEM addItem(HTREEITEM parent, HTREEITEM after, char* text, 
						int imageId, int selImageId);

	HTREEITEM insertItem(TV_INSERTSTRUCT* lpis) {
    		return (HTREEITEM)send(TVM_INSERTITEM, 0, (LPARAM)lpis);
	}


	BOOL	deleteItem(HTREEITEM hitem) {
    		return (BOOL)send(TVM_DELETEITEM, 0, (LPARAM)hitem);
	}

	BOOL 	deleteAllItems() {
    		return (BOOL)send(TVM_DELETEITEM, 0, (LPARAM)TVI_ROOT);
	}

	BOOL 	expand(HTREEITEM hitem, int code) {
    		return (BOOL)send(TVM_EXPAND, (WPARAM)code, (LPARAM)hitem);
	}

	void 	getItemRect(HTREEITEM hitem, RECT* prc, BOOL flag) {
    		send(TVM_GETITEMRECT, (WPARAM)flag, (LPARAM)prc);
	}

	int		getCount() {
    		return (UINT)send(TVM_GETCOUNT, 0, 0);
	}

	int 	getIndent() {
    		return (UINT)send(TVM_GETINDENT, 0, 0);
	}

	BOOL 	setIndent(int indent) {
    		return (BOOL)send(TVM_SETINDENT, (WPARAM)indent, 0);
	}

	HIMAGELIST getImageList(int iImage) {
			return (HIMAGELIST)send(TVM_GETIMAGELIST, iImage, 0);
	}

	HIMAGELIST setImageList(HIMAGELIST himl, int iImage) {
    		return (HIMAGELIST)send(TVM_SETIMAGELIST, iImage, (LPARAM)himl);
	}

	HIMAGELIST setImageList(ImageList* iml, int iImage) {
    		return (HIMAGELIST)send(TVM_SETIMAGELIST, iImage, (LPARAM)iml->getImageList());
	}

	HTREEITEM getNextItem(HTREEITEM hitem, int code) {
    		return (HTREEITEM)send(TVM_GETNEXTITEM, (WPARAM)code, (LPARAM)hitem);
	}
	HTREEITEM getChild(HTREEITEM hitem) {
			return  getNextItem(hitem, TVGN_CHILD);
	}

	HTREEITEM getNextSibling(HTREEITEM hitem) { 
			return  getNextItem(hitem, TVGN_NEXT);
	}

	HTREEITEM getPrevSibling(HTREEITEM hitem)  {
			return getNextItem(hitem, TVGN_PREVIOUS);
	}

	HTREEITEM getParent(HTREEITEM hitem) {
			return  getNextItem(hitem, TVGN_PARENT);
	}

	HTREEITEM getFirstVisible() {
			return	getNextItem(NULL,  TVGN_FIRSTVISIBLE);
	}
	HTREEITEM getNextVisible(HTREEITEM hitem) {	
			return getNextItem(hitem, TVGN_NEXTVISIBLE);
	}

	HTREEITEM getPrevVisible(HTREEITEM hitem) {
			return getNextItem(hitem, TVGN_PREVIOUSVISIBLE);
	}
	HTREEITEM getSelection() {
			return	getNextItem(NULL,  TVGN_CARET);
	}
	HTREEITEM getDropHilight() {
			return getNextItem(NULL,  TVGN_DROPHILITE);
	}
	HTREEITEM getRoot() {
			return getNextItem(NULL,  TVGN_ROOT);
	}

	HTREEITEM select(HTREEITEM hitem, int code) {
    		return (HTREEITEM)send(TVM_SELECTITEM, (WPARAM)code, (LPARAM)hitem);
	}

	HTREEITEM selectItem(HTREEITEM hitem) {
			return  select(hitem, TVGN_CARET);
	}

	HTREEITEM selectDropTarget(HTREEITEM hitem) {
			return  select(hitem, TVGN_DROPHILITE);
	}

	HTREEITEM selectSetFirstVisible(HTREEITEM hitem) {
			return select(hitem, TVGN_FIRSTVISIBLE);
	}

	BOOL 	getItem(TV_ITEM* pitem) {
    		return (BOOL)send(TVM_GETITEM, 0, (LPARAM)(TV_ITEM FAR*)(pitem));
	}

	BOOL 	setItem(TV_ITEM* pitem) {
    		return (BOOL)send(TVM_SETITEM, 0, (LPARAM)(const TV_ITEM FAR*)(pitem));
	}

	HWND 	editLabel(HTREEITEM hitem) {
    		return (HWND)send(TVM_EDITLABEL, 0, (LPARAM)hitem);
	}

	HWND	getEditControl() {
    		return (HWND)send(TVM_GETEDITCONTROL, 0, 0);
	}

	int 	getVisibleCount() {
    		return (UINT)send(TVM_GETVISIBLECOUNT, 0, 0);
	}

	HTREEITEM hitTest(TV_HITTESTINFO* lpht) {
    		return (HTREEITEM)send(TVM_HITTEST, 0, (LPARAM)lpht);
	}

	HIMAGELIST createDragImage(HTREEITEM hitem) {
    		return (HIMAGELIST)send(TVM_CREATEDRAGIMAGE, 0, (LPARAM)hitem);
	}

	BOOL 	sortChildren(HTREEITEM hitem, int recurse) {
    		return (BOOL)send(TVM_SORTCHILDREN, (WPARAM)recurse, (LPARAM)hitem);
	}

	BOOL 	ensureVisible(HTREEITEM hitem) {
    		return (BOOL)send(TVM_ENSUREVISIBLE, 0, (LPARAM)(HTREEITEM)(hitem));
	}

	BOOL 	sortChildrenCB(TV_SORTCB* psort, int recurse) {
    		return (BOOL)send(TVM_SORTCHILDRENCB, (WPARAM)recurse, (LPARAM)psort);
	}

	BOOL 	endEditLabelNow(int fCancel) {
    		return (BOOL)send(TVM_ENDEDITLABELNOW, (WPARAM)fCancel, 0);
	}

	BOOL 	getISearchString(char* lpsz) {
			return (BOOL)send(TVM_GETISEARCHSTRING, 0, (LPARAM)(LPTSTR)lpsz);
	}

	void  	expandChildren(HTREEITEM hItem, int flag);

	void  	sortAllChildren(HTREEITEM hItem);
};

#endif
