/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	View.h
 *
 *****************************************************************************/

// SOL++2000

// 1999.08.14
// 2000.02.18
// 2001.03.11 to-arai: Added a create method.

#ifndef _SOL_WINDOW
#include <sol\Window.h>
#endif
#ifndef _SOL_ARGS
#include <sol\Args.h>
#endif
#ifndef _SOL_CALLBACKLIST
#include <sol\CallbackList.h>
#endif
#ifndef _SOL_HANDLERLIST
#include <sol\HandlerList.h>
#endif
#ifndef _SOL_DIMENSION
#include <sol\Dimension.h>
#endif

#ifndef _SOL_LINKEDLIST
#include <sol\LinkedList.h>
#endif

#ifndef _SOL_LAYOUTABLE
#include <sol\Layoutable.h>
#endif

#ifndef _SOL_VIEW
#define _SOL_VIEW
class Font;

class View :public Window, public Layoutable {
	View*			parent;
	Font*			font;	
	CallbackList	callbackList;
	HandlerList		handlerList;
	Boolean			editable;
	Boolean			destructable;
	Dimension		preferredSize;
  protected:
 	virtual long   destroy(Event& event);
 	virtual long   defaultProc(Event& event);
	View(View* parview);
  public:
	View();
	View(View* parview, const char* name, Args& args);
	~View();
	virtual void  addCallback(const char* name, Object* object,
						Callback proc, void* data);
	void	addCallback(const char* name, const Key key, Object* object,
						Callback proc, void* data);
	void	addEventHandler(UINT message, Object* object,
						Handler proc, void* data);
	void	callCallback(const char* name, const Key key,
						void* value, Event& event);
	// 2000.02.10
	virtual Boolean create(View* parview, const char* name, Args& args);

	// 2001.03.11
	virtual Boolean create(View* parview);

	virtual void  disable();
	virtual long  dispatch(Event& event);

	virtual void  enable();
	void		get(const char* name, ulong* val);
	ulong	get(const char* name);
	virtual Arg*  getCallbackTable(int* num);

	virtual const char* getCallbackName(Event& event);

	void	getGeometry(int& x, int& y, 
					int& width, int& height);
	void	getNormalPlacement(RECT* r);

	View*	getParent() { return parent; }
	void	getLocation(int& x, int& y);
	void	getSize(int& w, int& h);
	int		getViewId() { return getId(); }
	virtual void	layout(int x, int y, int w, int h);

	Boolean	isEditable() { return editable; }
	void	map() { show(SW_NORMAL); }

	void	getStyle(Args& args, Arg* arg, int num);

	virtual void  	getValues(Args& args);

	static	LRESULT CALLBACK procedure(HWND hwnd, 
			  UINT message, WPARAM wParam, LPARAM lParam);

	void	removeEventHandler();
	void	set(const char* name, ulong val);

	void	setDestructable(Boolean val) { destructable = val;}

	void	setEditable(Boolean val) { editable = val; }
	void	setLocation(int x, int y);
	void	setSize(int w, int h);
	void	setParent(View* parent1) { parent = parent1; }

	void	setVisible(Boolean flag);

	virtual void  setValues(Args& args);
	virtual void  setViewId(int vid);

	void	unmap() { show(SW_HIDE); }

	void	refresh(RECT* r = NULL); 
	void	refresh(int x, int y, int width, int height);
	void	updateStyle(Args& args, Arg* arg, int num);

	void	setFont(Font* font);
	void	setFont(Font& font);

	Font*	getFont() { return font; }
	void	setFont(HFONT hfont) {
			send(WM_SETFONT, (WPARAM)hfont, MAKELPARAM(TRUE,0));
	}
	void	setSysCursor(const char* name);

	virtual void getPreferredSize(Dimension& d);

	virtual void setPreferredSize(Dimension& d);
};

#endif

