/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ColorDialog.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\ColorDialog.h>
#include <sol\Brush.h>
#include <sol\PaintDC.h>

#include "resource.h"


class MainView :public ApplicationView {
    COLORREF        color;
    ColorDialog    colordlg;

    //Eventhandler for WM_PAINT.
    long    paint(Event& event) 
    {        
        PaintDC pdc(this);
        Brush brush(color);
        HGDIOBJ prev = pdc.select(&brush);
        pdc.ellipse(0, 0, 100, 50);
        pdc.select(prev);
        return 0L;
    }

    //Callback to popup the colordlg.
    void    setColor(Action& action)
    {
        //Popup the colordlg.
        colordlg.popup(action);
        
        //Get a selected color from the colordlg. 
        color = colordlg.getRGBResult();

        //Cause WM_PAINT by invalidating this window.
        update(NULL);   
    }

  public:
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args)
    {
        color = RGB(0, 0, 255);
        Args ar;
        colordlg.create(this, "", ar);

        addCallback(XmNmenuCallback, ID_COLOR, this, (Callback)&MainView::setColor, null);
        addEventHandler(WM_PAINT, this, (Handler)&MainView::paint, null);
    }
};


// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
