/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ExtendedComboBox.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\ExtendedComboBox.h>

class MainView :public ApplicationView {
    ExtendedComboBox   comboBox;

    // Callback to handle WM_COMMAND/CBN_SELCHANGE event.
    void   selected(Action& action) {
        int indx = comboBox.getCurSel();
        // Do something.
    }

  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;
        // Create a window of ToolBar.
        ar.set(XmNstyle, (ulong)CBS_DROPDOWNLIST);
        ar.set(XmNheight, 100);
        comboBox.create(this, "", ar);
		
		add(comboBox);

        // Register selected callback of this class to the comboBox.     
        comboBox.addCallback(XmNselChangeCallback, this, (Callback)selected, null);

        COMBOBOXEXITEM item;
        memset(&item, 0, sizeof(item));
        item.mask= CBEIF_TEXT|CBEIF_INDENT;

        static char* items[] = {"One", "Two", "Three"};
        // Add items to the comboBox.    
        for(int i = 0; i < XtNumber(items); i++) {
            item.pszText = items[i];
            item.cchTextMax = strlen(items[i]);
            item.iItem      = i;
            item.iIndent    = i;
            comboBox.insertItem(&item);
        }
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "ExtendedComboBox";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
