/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FileDialog.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\FileDialog.h>

#include "resource.h"

class MainView :public ApplicationView {
    ScrolledText   sctext;
    FileDialog     filedlg;
    // Menu callback to popup the filedlg.
    void    open(Action& action) 
    {   
        // Call popup method to show the modal filedlg.
        filedlg.popup(action);

        if (action.getResult()) {
            // If any file selected, load it into ScrolledText.
            sctext.load(filedlg.getFileName());
        }
    }

  public:
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;
        sctext.create(this, "", ar);
        add(sctext);

        ar.reset();
        // Specify FileDialog::OPEN mode for an accessMode.
        ar.set(XmNaccessMode, FileDialog::OPEN);
        filedlg.create(this, NULL, ar);

        addCallback(XmNmenuCallback, ID_OPEN, this, (Callback)&MainView::open, NULL);
        addCallback(XmNmenuCallback, ID_EXIT, this, (Callback)&MainView::exit, NULL);
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
