/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FontDialog.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\FontDialog.h>
#include <sol\Font.h>

#include "resource.h"

class MainView :public ApplicationView {
    ScrolledText  text;
    FontDialog    fontDialog;
    Font*         font;

    //Menu callback to popup the fontDialog and set a font to the text.
    void setFont(Action& action) {
        fontDialog.popup(action);
        if (action.getResult()) {
            delete font;
            font = fontDialog.getFont();
            text.setFont(font);
        }
    }

  public:
    //Constructor
    MainView(Application& applet, const char* name, Args& args) 
        :ApplicationView(applet, name, args)
    {
        font = null;
        Args ar;
        ar.set(XmNnoHideSel, True);
        text.create(this, "", ar);
        add(text);

        ar.reset();
        fontDialog.create(this, NULL, ar);

        //Register setFont callback to popup the fontDialog.
        addCallback(XmNmenuCallback, ID_SETFONT, this, (Callback)&MainView::setFont, null);

    }

    ~MainView() {
        delete font;
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
