/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ListView.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\ListView.h>
#include "resource.h"

class MainView :public ApplicationView {
    ListView listview;

    // Callback to handle WM_NOTIFY/NM_DBLCLK event.
    void doubleClicked(Action& action) {
        // Do something.
    }

    // Callback to handle WM_NOTIFY/LVN_ITEMCHANGED event.
    void itemChanged(Action& action) {
        Event& event = action.getEvent();
        NM_LISTVIEW* nm = (NM_LISTVIEW*)event.getLParam();
        // Get an index of the changed item.
        int changedItem = nm->iItem;
    }

  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;   
        // Create a window of ListView.
        ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
        ar.set(XmNstyle, (ulong)LVS_REPORT);
		
        listview.create(this, "", ar);

        static char* column[] = {"No", "OS",       "Year"};
        listview.setColumn(column, 3);

        static char* lines1[] = {"1", "Windows95", "1995"};
        static char* lines2[] = {"2", "Windows98", "1998"};
        static char* lines3[] = {"3", "Windows2000", "2000"};

        listview.insertLine(0, lines1, 3);
        listview.insertLine(1, lines2, 3);
        listview.insertLine(2, lines3, 3);

        add(listview);

        // Add doubleClick and itemChanged callbacks of this class 
        // to the listview.
        listview.addCallback(XmNdoubleClickCallback, this,
                        (Callback)&MainView::doubleClicked, null);
        listview.addCallback(XmNitemChangedCallback, this,
                        (Callback)&MainView::itemChanged, null);
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
