/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PrintDialog.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\PrintDialog.h>

#include "resource.h"

class MainView :public ApplicationView {
    PrintDialog    printDialog;

    //Menu callback to popup the printDialog and print a text.
    void    print(Action& action)
    {
        printDialog.popup(action);
        if (action.getResult()) {
            HDC hdc = printDialog.getDC();
            DOCINFO docInfo;
            memset(&docInfo, 0, sizeof(DOCINFO));
            docInfo.cbSize = sizeof(DOCINFO);
            docInfo.lpszDocName = "Text";

            StartDoc(hdc, &docInfo); 
            StartPage(hdc);
    
            char* text = "Hello world";
            TextOut(hdc, 200, 200, text, strlen(text));
            EndPage(hdc);
            EndDoc(hdc);
        }
    }

  public:
    //Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args)
    {
        Args ar;
        printDialog.create(this,"", ar);

        //Register print callback to popup the printDialog.
        addCallback(XmNmenuCallback, ID_PRINT, this,
            (Callback)&MainView::print, null);
    }
};

 


// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
