/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	RichText.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\Font.h>
#include <sol\ClientDC.h>
#include <sol\RichText.h>

class MainView :public ApplicationView {
    int        textHeight;
    Font       font;
    RichText   richText;

     // Override size method of Composite class to layout the richText.
    long        size(Event& event) {
        int w, h;
        event.getSize(w, h);
        richText.reshape(0, 0, w, textHeight+4);         
        return 0L;
    }

  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;   
        ar.set(XmNheight, (-12));
        //Create an instance of Font.
        font.create(ar);

        ClientDC dc(this);
        HFONT prevFont = (HFONT)dc.select(&font);
        textHeight = dc.getTextHeight();
        dc.select(prevFont);
        ar.reset();

        // Create a window of RichText.
        richText.create(this, "",   ar);
        // Set the font to the richText.
        richText.setFont(font);

        // Set a string to the richText.
        richText.setText("Input your name here.");
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "RichText";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
