/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	TreeView.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\TreeView.h>

class MainView :public ApplicationView {
    TreeView treeview;

    // Callback to handle WM_NOTIFY/TVN_BEGINLABELEDIT event.
    void beginLabelEdit(Action& action) {
        Event& event = action.getEvent();
        TV_DISPINFO* dispInfo = (TV_DISPINFO*)event.getLParam();
        TV_ITEM item = dispInfo-> item;
        // Do something.

        action.setResult(0); // Return 0 to enable a label-edit.    
    }

    // Callback to handle WM_NOTIFY/TVN_ENDLABELEDIT event.
    void endLabelEdit(Action& action) {
        Event& event = action.getEvent();
        TV_DISPINFO* dispInfo = (TV_DISPINFO*)event.getLParam();
        TV_ITEM item = dispInfo-> item;
        if(item.pszText) {
            // Set a mask TFIF_TEXT to set the text.
            item.mask = TVIF_TEXT;
            treeview.setItem(&item);
        }   
    }

  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;   
        // Create an instance of TreeView.
        ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
        ar.set(XmNstyle, (ulong)TVS_HASLINES|TVS_HASBUTTONS|TVS_LINESATROOT|TVS_EDITLABELS);
        treeview.create(this, "", ar);

        add(treeview);

		HTREEITEM root = treeview.addItem(NULL, TVI_ROOT, "Object");
		HTREEITEM window = treeview.addItem(root,TVI_FIRST, "Window");
		treeview.addItem(window,TVI_FIRST, "View");

        // Add beginLabelEdit and endLabelEdit callbacks of this class to the treeview.
        treeview.addCallback(XmNbeginLabelEditCallback, this,
                        (Callback)&MainView::beginLabelEdit, null);
        treeview.addCallback(XmNendLabelEditCallback, this,
                        (Callback)&MainView::endLabelEdit, null);
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "TreeView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
