unit ecma_dynacall;

interface

uses
  Windows,Sysutils,Classes,ecma_type,dynamiccall,hashtable;

type
  //dynacall
  TJDynaCall = class(TJObject)
  private
    FModules: TIntegerHashtable;
    procedure HashtableOnFreeItem(Sender: TObject; P: PHashItem);
  protected
    function DoRegister(Param: TJValueList): TJValue;
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    destructor Destroy; override;
  end;


implementation

{ TJDynaCall }

constructor TJDynaCall.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
begin
  inherited;
  FModules := TIntegerHashtable.Create(13,True);
  FModules.OnFreeItem := HashtableOnFreeItem;

  RegistName('DynaCall');
  RegistMethod('register',DoRegister);
end;

destructor TJDynaCall.Destroy;
begin
  FModules.Clear;
  FreeAndNil(FModules);
  inherited;
end;

function TJDynaCall.DoRegister(Param: TJValueList): TJValue;
//֐o^
var
  f: TJFunction;
  s1,s2,s3,lib,func: String;
  i: Integer;
  v: TJValue;
  module: HModule;
begin
  Result := BuildNull;
  s1 := '';
  s2 := '';
  s3 := '';
  lib := '';
  func := '';

  for i := 0 to Param.Count - 1 do
  begin
    v := Param[i];
    case i of
      0: lib := AsString(@v);
      1: func := AsString(@v);
      2: s1 := LowerCase(AsString(@v));
      3: s2 := LowerCase(AsString(@v));
      4: s3 := LowerCase(AsString(@v));
    end;
  end;

  //֐ȂΓo^
  if (func <> '') and (lib <> '') then
  begin
    f.FuncType := ftDynaCall;
    f.DynaDeclare := ParseDynaDeclare([s1,s2,s3]);

    //DLL`FbN
    if FModules.HasKey(lib) then
    begin
      //݂
      module := FModules[lib];
      //֐ǂݍ
      f.DynaDeclare.ProcAddr := SearchProcAddress(module,func);
      //sO
      if not Assigned(f.DynaDeclare.ProcAddr) then
        raise EJThrow.Create(E_DLL,func);
    end
    else begin
      //DLLǂݍ
      module := LoadLibrary(PChar(lib));
      //sƗO
      if module = 0 then
        raise EJThrow.Create(E_DLL,lib);

      f.DynaDeclare.ProcAddr := SearchProcAddress(module,func);
      //sDLLėO
      if not Assigned(f.DynaDeclare.ProcAddr) then
      begin
        FreeLibrary(module);
        raise EJThrow.Create(E_DLL,func);
      end
      else //DLLnbVɓ
        FModules[lib] := module
    end;    


    Members[func] := FFuncFactory.BuildFunction(f);
  end
  else //O
    raise EJThrow.Create(E_DLL,'register error: ' + lib + ' ' + func);
end;

procedure TJDynaCall.HashtableOnFreeItem(Sender: TObject; P: PHashItem);
//DLL
begin
  if P^.ValueType = hvInteger then
     FreeLibrary(P^.vInteger);
end;

end.
