unit ecma_object;

//{gObject
//2001/04/14 ~
//by Wolfy

interface

uses
  windows,classes,sysutils,dialogs,forms,syncobjs,gsocketmisc,
  ecma_expr,hashtable,ecma_promptfrm,ecma_type,Math,
  ecma_textareafrm,regexpr,jconvert,ecma_misc,crclib,unicodelib;

type
  TOnPrineEvent = procedure(S: String) of object;

  TJArrayObject = class;
  //O[o
  TJGlobalObject = class(TJObject)
  private
    FOnPrint: TStringEvent;
    FArgs: TJArrayObject;

    function DoPrintln(Param: TJValueList): TJValue;
    function DoPrint(Param: TJValueList): TJValue;
    function DoEscape(Param: TJValueList): TJValue;
    function DoEval(Param: TJValueList): TJValue;
    function DoIsFinite(Param: TJValueList): TJValue;
    function DoIsNaN(Param: TJValueList): TJValue;
    function DoParseFloat(Param: TJValueList): TJValue;
    function DoParseInt(Param: TJValueList): TJValue;
    function DoUnescape(Param: TJValueList): TJValue;
    function DoAlert(Param: TJValueList): TJValue;
    function DoConfirm(Param: TJValueList): TJValue;
    function DoPrompt(Param: TJValueList): TJValue;
    function DoTextArea(Param: TJValueList): TJValue;
    function DoExit(Param: TJValueList): TJValue;
    function DoMsgBox(Param: TJValueList): TJValue;

    procedure EngineOnStdout(Sender: TObject; S: String);
    function GetApplicationHandle: THandle;
    function GetMainFormHandle: THandle;
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    destructor Destroy; override;
    procedure Print(S: String); overload;
    procedure Print(V: TJValue); overload;

    property OnPrint: TStringEvent read FOnPrint write FOnPrint;
  published
    property args: TJArrayObject read FArgs;
    property arguments: TJArrayObject read FArgs;
    property applicationHandle: THandle read GetApplicationHandle;
    property mainFormHandle: THandle read GetMainFormHandle;
  end;
  //z
  TJArrayObject = class(TJObject)
  private
    FFunction: TJFunction;
    FItems: TJValueList;

    function GetLength: Integer;
    procedure SetLength(const Value: Integer);

    function ItemsSort1(Item1, Item2: Pointer): Integer;
    function ItemsSort2(Item1, Item2: Pointer): Integer;
    //o^\bh
    function DoAppend(Param: TJValueList): TJValue;
    function DoClear(Param: TJValueList): TJValue;
    function DoDelete(Param: TJValueList): TJValue;
    function DoSort(Param: TJValueList): TJValue;
    function DoConCat(Param: TJValueList): TJValue;
    function DoJoin(Param: TJValueList): TJValue;
    function DoPop(Param: TJValueList): TJValue;
    function DoPush(Param: TJValueList): TJValue;
    function DoReverse(Param: TJValueList): TJValue;
    function DoShift(Param: TJValueList): TJValue;
    function DoSlice(Param: TJValueList): TJValue;
    function DoSplice(Param: TJValueList): TJValue;
    function DoUnShift(Param: TJValueList): TJValue;
  protected

    function GetPropertyList: String; override;
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    destructor Destroy; override;
    function GetValue(S: String; ArrayStyle: Boolean): TJValue; override;
    procedure SetValue(S: String; Value: TJValue; ArrayStyle: Boolean); override;
    function ToString(Value: PJValue = nil): String; override;

    procedure Clear;
    function Add(Value: TJValue): Integer;
    procedure Insert(Index: Integer; Value: TJValue);
    procedure Delete(Index: Integer);

    property Items: TJValueList read FItems;

  published
    property length: Integer read GetLength write SetLength;
  end;

  TJRegExpObject = class;

  TJStringObject = class(TJObject)
  private
    FText: String;
    function GetLength: Integer;
    function DoCharAt(Param: TJValueList): TJValue;
    function DoCharCodeAt(Param: TJValueList): TJValue;
    function DoConCat(Param: TJValueList): TJValue;
    function DoAnchor(Param: TJValueList): TJValue;
    function DoBig(Param: TJValueList): TJValue;
    function DoBlink(Param: TJValueList): TJValue;
    function DoBold(Param: TJValueList): TJValue;
    function DoFixed(Param: TJValueList): TJValue;
    function DoFontColor(Param: TJValueList): TJValue;
    function DoFontSize(Param: TJValueList): TJValue;
    function DoFromCharCode(Param: TJValueList): TJValue;
    function DoIndexOf(Param: TJValueList): TJValue;
    function DoItalics(Param: TJValueList): TJValue;
    function DoLastIndexOf(Param: TJValueList): TJValue;
    function DoLink(Param: TJValueList): TJValue;
    function DoMatch(Param: TJValueList): TJValue;
    function DoReplace(Param: TJValueList): TJValue;
    function DoSearch(Param: TJValueList): TJValue;
    function DoSlice(Param: TJValueList): TJValue;
    function DoSmall(Param: TJValueList): TJValue;
    function DoSplit(Param: TJValueList): TJValue;
    function DoStrike(Param: TJValueList): TJValue;
    function DoSub(Param: TJValueList): TJValue;
    function DoSubStr(Param: TJValueList): TJValue;
    function DoSubString(Param: TJValueList): TJValue;
    function DoSup(Param: TJValueList): TJValue;
    function DoToLowerCase(Param: TJValueList): TJValue;
    function DoToUpperCase(Param: TJValueList): TJValue;
    function DoToSJIS(Param: TJValueList): TJValue;
    function DoToJIS(Param: TJValueList): TJValue;
    function DoToEUC(Param: TJValueList): TJValue;
    function DoToWide(Param: TJValueList): TJValue;
    function DoToUtf8(Param: TJValueList): TJValue;
    function DoFromJISToSJIS(Param: TJValueList): TJValue;
    function DoFromJISToEUC(Param: TJValueList): TJValue;
    function DoFromEUCToSJIS(Param: TJValueList): TJValue;
    function DoFromEUCToJIS(Param: TJValueList): TJValue;
    function DoFromSJISToEUC(Param: TJValueList): TJValue;
    function DoFromSJISToJIS(Param: TJValueList): TJValue;
    function DoFromUtf8ToSJIS(Param: TJValueList): TJValue;
    function DoOrd(Param: TJValueList): TJValue;
    procedure SetLength(const Value: Integer);
  protected

  public
    constructor Create(AFactory: TJObjectFactory; Init: TJValueList = nil); override;
    destructor Destroy; override;
    function GetValue(S: String; ArrayStyle: Boolean): TJValue; override;
    procedure SetValue(S: String; Value: TJValue; ArrayStyle: Boolean); override;
    function ToString(Value: PJValue = nil): String; override;
    function ToInteger: Integer; override;
    function ToDouble: Double; override;
    function ToBool: Boolean; override;
    function ToChar: Char; override;

  published
    property length: Integer read GetLength write SetLength;
    property text: String read FText write FText;
  end;
  //
  TJNumberObject = class(TJObject)
  private      

    procedure RegistProps;
  protected
  public
    FValue: TJValue;

    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    function ToString(Value: PJValue = nil): String; override;
    function ToInteger: Integer; override;
    function ToDouble: Double; override;
    function ToBool: Boolean; override;
    function ToChar: Char; override;

  published

  end;
  //^U
  TJBooleanObject = class(TJObject)
  private
    FBool: Boolean;
  protected

  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    function ToString(Value: PJValue = nil): String; override;
    function ToInteger: Integer; override;
    function ToDouble: Double; override;
    function ToBool: Boolean; override;
    function ToChar: Char; override;

  published

  end;

  TMatchParenEvent = procedure(Sender: TObject; Index: Integer; var Value: TJValue) of object;
  //K\IuWFNg
  TJRegExpObject = class(TJObject)
  private
    FGlobal: Boolean;
    FRegExp: TRegExpr;
    FOnMatchParen: TMatchParenEvent;
    FOnMatchStart: TNotifyEvent;
    FOnMatchEnd: TNotifyEvent;

    function DoExec(Param: TJValueList): TJValue;
    function DoTest(Param: TJValueList): TJValue;
    function DoSplit(Param: TJValueList): TJValue;
    function DoReplace(Param: TJValueList): TJValue;

    function GetIgnoreCase: Boolean;
    procedure SetIgnoreCase(const Value: Boolean);
    function GetSource: String;
    procedure SetSource(const Value: String);
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    destructor Destroy; override;
    procedure ClearMatch;
    //event
    property OnMatchStart: TNotifyEvent read FOnMatchStart write FOnMatchStart;
    property OnMatchParen: TMatchParenEvent read FOnMatchParen write FOnMatchParen;
    property OnMatchEnd: TNotifyEvent read FOnMatchEnd write FOnMatchEnd;

  published
    property ignoreCase: Boolean read GetIgnoreCase write SetIgnoreCase;
    property global: Boolean read FGlobal write FGlobal;
    property source: String read GetSource write SetSource;
  end;
  //wIuWFNg
  TJMathObject = class(TJObject)
  private
    function DoExp(Param: TJValueList): TJValue;
    function DoLog(Param: TJValueList): TJValue;
    function DoSqrt(Param: TJValueList): TJValue;
    function DoAbs(Param: TJValueList): TJValue;
    function DoCeil(Param: TJValueList): TJValue;
    function DoFloor(Param: TJValueList): TJValue;
    function DoRound(Param: TJValueList): TJValue;
    function DoSin(Param: TJValueList): TJValue;
    function DoCos(Param: TJValueList): TJValue;
    function DoTan(Param: TJValueList): TJValue;
    function DoAsin(Param: TJValueList): TJValue;
    function DoAcos(Param: TJValueList): TJValue;
    function DoAtan(Param: TJValueList): TJValue;
    function DoAtan2(Param: TJValueList): TJValue;
    function DoMax(Param: TJValueList): TJValue;
    function DoMin(Param: TJValueList): TJValue;
    function DoPow(Param: TJValueList): TJValue;
    function DoRandom(Param: TJValueList): TJValue;
    function GetE: Double;
    function GetLN10: Double;
    function GetLN2: Double;
    function GetLOG10E: Double;
    function GetLOG2E: Double;
    function GetPI: Double;
    function GetSQRT1_2: Double;
    function GetSQRT2: Double;
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
  published
    property E: Double read GetE;
    property LN2: Double read GetLN2;
    property LN10: Double read GetLN10;
    property LOG2E: Double read GetLOG2E;
    property LOG10E: Double read GetLOG10E;
    property SQRT1_2: Double read GetSQRT1_2;
    property SQRT2: Double read GetSQRT2;
    property PI: Double read GetPI; 
  end;


    //t
  TJDateObject = class(TJObject)
  private
    function GetUTC: TDateTime;
    procedure SetUTC(const Value: TDateTime);
    function GetLocal: TDateTime;
    procedure SetLocal(const Value: TDateTime);
  private
    FDate: TDateTime;

    function DoGetFullYear(Param: TJValueList): TJValue;
    function DoGetYear(Param: TJValueList): TJValue;
    function DoGetMonth(Param: TJValueList): TJValue;
    function DoGetDate(Param: TJValueList): TJValue;
    function DoGetDay(Param: TJValueList): TJValue;
    function DoGetHours(Param: TJValueList): TJValue;
    function DoGetMinutes(Param: TJValueList): TJValue;
    function DoGetSeconds(Param: TJValueList): TJValue;
    function DoGetMilliSeconds(Param: TJValueList): TJValue;
    function DoSetFullYear(Param: TJValueList): TJValue;
    function DoSetYear(Param: TJValueList): TJValue;
    function DoSetMonth(Param: TJValueList): TJValue;
    function DoSetDate(Param: TJValueList): TJValue;
    function DoSetHours(Param: TJValueList): TJValue;
    function DoSetMinutes(Param: TJValueList): TJValue;
    function DoSetSeconds(Param: TJValueList): TJValue;
    function DoSetMilliSeconds(Param: TJValueList): TJValue;

    function DoGetUTCFullYear(Param: TJValueList): TJValue;
    function DoGetUTCYear(Param: TJValueList): TJValue;
    function DoGetUTCMonth(Param: TJValueList): TJValue;
    function DoGetUTCDate(Param: TJValueList): TJValue;
    function DoGetUTCDay(Param: TJValueList): TJValue;
    function DoGetUTCHours(Param: TJValueList): TJValue;
    function DoGetUTCMinutes(Param: TJValueList): TJValue;
    function DoGetUTCSeconds(Param: TJValueList): TJValue;
    function DoGetUTCMilliSeconds(Param: TJValueList): TJValue;
    function DoSetUTCFullYear(Param: TJValueList): TJValue;
    function DoSetUTCYear(Param: TJValueList): TJValue;
    function DoSetUTCMonth(Param: TJValueList): TJValue;
    function DoSetUTCDate(Param: TJValueList): TJValue;
    function DoSetUTCHours(Param: TJValueList): TJValue;
    function DoSetUTCMinutes(Param: TJValueList): TJValue;
    function DoSetUTCSeconds(Param: TJValueList): TJValue;
    function DoSetUTCMilliSeconds(Param: TJValueList): TJValue;

    function DoGetTime(Param: TJValueList): TJValue;
    function DoSetTime(Param: TJValueList): TJValue;
    function DoGetTimezoneOffset(Param: TJValueList): TJValue;
    function DoToLocaleString(Param: TJValueList): TJValue;
    function DoToGMTString(Param: TJValueList): TJValue;
    function DoToUTCString(Param: TJValueList): TJValue;
    function DoUTC(Param: TJValueList): TJValue;
    function DoParse(Param: TJValueList): TJValue;  
    
  protected
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    function ToString(Value: PJValue = nil): String; override;

    property LocalTime: TDateTime read GetLocal write SetLocal;
    property UTC: TDateTime read GetUTC write SetUTC;
  end;


implementation

uses
  dmonkey,ecma_engine;


{ TJGlobalObject }

constructor TJGlobalObject.Create(AFactory: TJObjectFactory; Param: TJValueList);
begin
  inherited Create(AFActory,nil);
  RegistName('Global');
  FArgs := TJArrayObject.Create(AFactory,nil);
  FArgs.IncRefCount;

  RegistMethod('escape',DoEscape);
  RegistMethod('unescape',DoUnescape);
  RegistMethod('eval',DoEval);
  RegistMethod('isFinite',DoIsFinite);
  RegistMethod('isNaN',DoIsNaN);
  RegistMethod('parseFloat',DoParseFloat);
  RegistMethod('parseInt',DoParseInt);
  RegistMethod('print',DoPrint);
  RegistMethod('println',DoPrintln);
  RegistMethod('write',DoPrint);
  RegistMethod('writeln',DoPrintln);
  RegistMethod('alert',DoAlert);
  RegistMethod('prompt',DoPrompt);
  RegistMethod('confirm',DoConfirm);
  RegistMethod('textArea',DoTextArea);
  RegistMethod('exit',DoExit);
  RegistMethod('msgBox',DoMsgBox);
end;

destructor TJGlobalObject.Destroy;
begin
  FArgs.DecRefCount;
  inherited Destroy;
end;

procedure TJGlobalObject.EngineOnStdout(Sender: TObject; S: String);
//evelŎgp
begin
  if Assigned(FOnPrint) then
    FOnPrint(Self,S);
end;

function TJGlobalObject.DoEscape(Param: TJValueList): TJValue;
//urlGR[h
var
  s: String;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    s := URLEncode(AsString(@v),'',True);
    Result := BuildString(s);
  end;
end;

function TJGlobalObject.DoEval(Param: TJValueList): TJValue;
//s
var
  dm: TDMonkey;
  s: String;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    s := AsString(@v);
    dm := TDMonkey.Create(nil);
    try
      dm.OnStdout := EngineOnStdout;
      if dm.Compile(s) then
      begin
        Result := BuildInteger(dm.Run([]));
      end;
    finally
      dm.Free;
    end;
  end;
end;

function TJGlobalObject.DoIsFinite(Param: TJValueList): TJValue;
//
begin
  Result := BuildBool(False);
end;

function TJGlobalObject.DoIsNaN(Param: TJValueList): TJValue;
//ł͂ȂH
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildBool(ecma_type.IsNaN(@v));
  end;
end;

function TJGlobalObject.DoParseFloat(Param: TJValueList): TJValue;
//_Ԃ
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    if ecma_type.IsNaN(@v) then
      Result := BuildNaN
    else
      Result := BuildDouble(AsDouble(@v));
  end;
end;

function TJGlobalObject.DoParseInt(Param: TJValueList): TJValue;
//Ԃ
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    if ecma_type.IsNaN(@v) then
      Result := BuildNaN
    else
      Result := BuildInteger(AsInteger(@v));
  end;
end;

function TJGlobalObject.DoPrint(Param: TJValueList): TJValue;
//Wo
var
  i: Integer;
  v: TJValue;
begin
  EmptyValue(Result);
  for i := 0 to Param.Count - 1 do
  begin
    v := Param[i];
    Print(v);
  end;
end;

procedure TJGlobalObject.Print(S: String);
begin
  if Assigned(FOnPrint) then
    FOnPrint(Self,S);
end;

function TJGlobalObject.DoPrintln(Param: TJValueList): TJValue;
//Wo͉s
var
  i: Integer;
  v: TJValue;
begin
  EmptyValue(Result);
  for i := 0 to Param.Count - 1 do
  begin
    v := Param[i];
    Print(AsString(@v) + CRLF);
  end;
end;

function TJGlobalObject.DoUnescape(Param: TJValueList): TJValue;
//urlfR[h
var
  s: String;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    s := URLDecode(AsString(@v),True);
    Result := BuildString(s);
  end;
end;

procedure TJGlobalObject.Print(V: TJValue);
begin
  Print(AsString(@V));
end;

function TJGlobalObject.DoAlert(Param: TJValueList): TJValue;
//_CAO\
var
  s,capt: String;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    s := AsString(@v);
    capt := ChangeFileExt(ExtractFileName(ParamStr(0)),'');
    capt := AnsiUpperCase(Copy(capt,1,1)) + AnsiLowerCase(Copy(capt,2,MaxInt));

    MsgBox(PChar(s),PChar(capt),MB_OK or MB_ICONEXCLAMATION);
  end;
end;

function TJGlobalObject.DoConfirm(Param: TJValueList): TJValue;
//_CAO\
var
  s,capt: String;
  v: TJValue;
  r: Integer;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    s := AsString(@v);
    capt := ChangeFileExt(ExtractFileName(ParamStr(0)),'');
    capt := AnsiUpperCase(Copy(capt,1,1)) + AnsiLowerCase(Copy(capt,2,MaxInt));

    r := MsgBox(PChar(s),PChar(capt),MB_OKCANCEL or MB_ICONQUESTION);
    Result := BuildBool(r <> IDCANCEL);
  end;
end;

function TJGlobalObject.DoPrompt(Param: TJValueList): TJValue;
//vvg\
var
  s1,s2,capt: String;
  v: TJValue;
  frm: TfrmPrompt;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    s1 := AsString(@v);
    s2 := '';
    if Param.Count > 1 then
    begin
      v := Param[1];
      s2 := AsString(@v);
    end;

    capt := ChangeFileExt(ExtractFileName(ParamStr(0)),'');
    capt := AnsiUpperCase(Copy(capt,1,1)) + AnsiLowerCase(Copy(capt,2,MaxInt));

    frm := TfrmPrompt.Create(Application.MainForm);
    try
      frm.Caption := capt;
      frm.lblText.Caption := s1;
      frm.edtPrompt.Text := s2;
      if frm.ShowModal = IDOK then
      begin
        Result := BuildString(frm.edtPrompt.Text);
      end
      else
        Result := BuildNull;
    finally
      frm.Release;
    end;
  end;
end;

function TJGlobalObject.DoTextArea(Param: TJValueList): TJValue;
//\
var
  s1,s2,capt: String;
  v: TJValue;
  frm: TfrmTextArea;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    s1 := AsString(@v);
    s2 := '';
    if Param.Count > 1 then
    begin
      v := Param[1];
      s2 := AsString(@v);
    end;

    capt := ChangeFileExt(ExtractFileName(ParamStr(0)),'');
    capt := AnsiUpperCase(Copy(capt,1,1)) + AnsiLowerCase(Copy(capt,2,MaxInt));

    frm := TfrmTextArea.Create(Application.MainForm);
    try
      frm.Caption := capt;
      frm.lblText.Caption := s1;
      if s2 <> '' then
        frm.mmText.Lines.Add(s2);

      if frm.ShowModal = IDOK then
      begin
        Result := BuildString(frm.mmText.Text);
      end
      else
        Result := BuildNull;
    finally
      frm.Release;
    end;
  end;

end;

function TJGlobalObject.DoExit(Param: TJValueList): TJValue;
//I
var
  v: TJValue;
begin
  //O
  if IsParam1(Param) then
  begin
    v := Param[0];
    raise EJExit.Create(AsInteger(@v));
  end
  else
    raise EJExit.Create(0);
end;

function TJGlobalObject.DoMsgBox(Param: TJValueList): TJValue;
//_CAO\
var
  s,capt: String;
  v: TJValue;
  flag: Integer;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    s := AsString(@v);
    capt := ChangeFileExt(ExtractFileName(ParamStr(0)),'');
    capt := AnsiUpperCase(Copy(capt,1,1)) + AnsiLowerCase(Copy(capt,2,MaxInt));
    //tO
    if IsParam2(Param) then
    begin
      v := Param[1];
      flag := AsInteger(@v);
    end
    else
      flag := MB_OK;

    Result := BuildInteger(MsgBox(PChar(s),PChar(capt),flag));
  end;
end;

function TJGlobalObject.GetApplicationHandle: THandle;
begin
  Result := Application.Handle;
end;

function TJGlobalObject.GetMainFormHandle: THandle;
begin
  if Assigned(Application.MainForm) then
    Result := Application.MainForm.Handle
  else
    Result := 0;
end;

{ TJArrayObject }

function TJArrayObject.DoAppend(Param: TJValueList): TJValue;
var
  i: Integer;
begin
  EmptyValue(Result);
  for i := 0 to Param.Count - 1 do
    Result := BuildInteger(Add(Param[i]));
end;

function TJArrayObject.DoClear(Param: TJValueList): TJValue;
//NA
begin
  EmptyValue(Result);
  Clear;
end;

constructor TJArrayObject.Create(AFactory: TJObjectFactory; Param: TJValueList);
//쐬
var
  i: Integer;
  v: TJValue;
begin
  inherited Create(AFactory,nil);
  FItems := TJValueList.Create;

  RegistName('Array');
  RegistMethod('delete',DoDelete);
  RegistMethod('clear',DoClear);
  RegistMethod('add',DoAppend);
  RegistMethod('sort',DoSort);

  RegistMethod('concat',DoConCat);
  RegistMethod('join',DoJoin);
  RegistMethod('pop',DoPop);
  RegistMethod('push',DoPush);
  RegistMethod('reverse',DoReverse);
  RegistMethod('shift',DoShift);
  RegistMethod('slice',DoSlice);
  RegistMethod('splice',DoSplice);
  RegistMethod('toString',DoToString);
  RegistMethod('unShift',DoUnShift);

  //o^
  if IsParam1(Param) then
  begin
    v := Param[0];
    //H
    if (Param.Count = 1) and IsInteger(@v) then
      length := AsInteger(@v)
    else //vfƂĒǉ
      for i := 0 to Param.Count - 1 do
        Add(Param[i]);
  end;
end;


function TJArrayObject.DoDelete(Param: TJValueList): TJValue;
//폜
var
  i: Integer;
  v: TJValue;
begin
  Result := BuildBool(False);
  if IsParam1(Param) then
  begin
    v := Param[0];
    i := AsInteger(@v);
    try
      //폜
      Delete(i);
      Result := BuildBool(True);
    except
      on EListError do
        raise EJThrow.Create(E_INDEX,'');
    end;
  end;
end;

destructor TJArrayObject.Destroy;
//j
begin
  Clear;
  FreeAndNil(FItems);
  inherited Destroy;
end;

function TJArrayObject.GetLength: Integer;
begin
  Result := FItems.Count;
end;

function TJArrayObject.GetValue(S: String; ArrayStyle: Boolean): TJValue;
begin
  if not ArrayStyle then
    Result := inherited GetValue(S,ArrayStyle)
  else begin
    try
      Result := FItems[StrToInt(S)];
    except
      on EConvertError do
        Result := inherited GetValue(S,ArrayStyle);
      on EListError do
        raise EJThrow.Create(E_INDEX,S);
    end;
  end;
end;

procedure TJArrayObject.SetValue(S: String; Value: TJValue;
  ArrayStyle: Boolean);
var
  i: Integer;
begin
  if ArrayStyle then
  begin
    try
      i := StrToInt(S);
      //z傫
      if (i + 1) > FItems.Count then
        FItems.Count := i + 1;

      FItems[i] := Value
    except
      on EConvertError do
        inherited SetValue(S,Value,ArrayStyle);
      on EListError do
        raise EJThrow.Create(E_INDEX,S);
    end;
  end
  else
    inherited SetValue(S,Value,ArrayStyle);;     
end;

function TJArrayObject.GetPropertyList: String;
var
  i: Integer;
  sl: TStringList;
begin
  sl := TStringList.Create;
  try
    for i := 0 to FItems.Count - 1 do
      sl.Add(IntToStr(i));

    Result := Trim(sl.Text);
  finally
    sl.Free;
  end;
end;

function TJArrayObject.DoSort(Param: TJValueList): TJValue;
//\[g
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    if (Param[0].ValueType = vtFunction) and (FFactory.Engine is TJEngine) then
    begin
      FFunction := Param[0].vFunction^;
      FItems.Sort(ItemsSort2);
    end;                      
  end
  else
    FItems.Sort(ItemsSort1);
end;

function TJArrayObject.ItemsSort1(Item1, Item2: Pointer): Integer;
//ʏ̃\[g
var
  p1,p2: PJValue;
begin
  p1 := Item1;
  p2 := Item2;
  Result := AsInteger(p1) - AsInteger(p2);
end;

function TJArrayObject.ItemsSort2(Item1, Item2: Pointer): Integer;
//֐\[g
var
  p1,p2: PJValue;
  param: TJValueList;
  v: TJValue;
  engine: TJEngine;
begin
  engine := TJEngine(FFactory.Engine);
  p1 := Item1;
  p2 := Item2;
  param := TJValueList.Create;
  //return := TJValueList.Create;
  try
    param.Add(p1^);
    param.Add(p2^);
    v := engine.CallExpr(FFunction,param);
    Result := AsInteger(@v);
  finally
    param.Free;
    //return.Free;
  end;
end;

function TJArrayObject.Add(Value: TJValue): Integer;
begin
  //QƃJEg𑝂₷
  IncRefObject(Value);
  Result := FItems.Add(Value);
end;

procedure TJArrayObject.Clear;
//NA
begin
  //QƃJEg炷
  DecRefMembers;
  FItems.Clear;
end;

function TJArrayObject.DoConCat(Param: TJValueList): TJValue;
//zA
var
  i,j: Integer;
  list,inlist: TJArrayObject;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    list := TJArrayObject.Create(FFactory,nil);
    //
    for i := 0 to FItems.Count - 1 do
      list.Add(FItems[i]);
    //ǉ
    for i := 0 to Param.Count - 1 do
    begin
      v := Param[i];
      //z̏ꍇ͒gRs[
      if IsObject(@v) and (v.vObject is TJArrayObject) then
      begin
        inlist := v.vObject as TJArrayObject;
        for j := 0 to inlist.FItems.Count - 1 do
          list.Add(inlist.Fitems[j]);
      end
      else
        list.Add(v);
    end;
    //Ԓl
    Result := BuildObject(list);
  end;
end;

function TJArrayObject.DoJoin(Param: TJValueList): TJValue;
//AԂ
var
  i: Integer;
  sep,s: String;
  v: TJValue;
begin
  EmptyValue(Result);
  sep := ',';
  s := '';
  
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    sep := AsString(@v);
  end;
  //A
  for i := 0 to FItems.Count - 1 do
  begin
    v := FItems[i];
    if i = 0 then
    begin
      if IsNull(@v) or IsUndefined(@v) then
      else
        s := AsString(@v);
    end
    else begin
      if IsNull(@v) or IsUndefined(@v) then
        s := s + sep
      else
        s := s + sep + AsString(@v);
    end;
  end;

  Result := BuildString(s);
end;

function TJArrayObject.DoPop(Param: TJValueList): TJValue;
//Ō̒lԂ
begin
  EmptyValue(Result);
  if FItems.Count > 0 then
  begin
    Result := FItems[FItems.Count - 1];
    Delete(FItems.Count - 1);
  end;
end;

function TJArrayObject.DoPush(Param: TJValueList): TJValue;
//
var
  i: Integer;
begin
  for i := 0 to Param.Count - 1 do
    Add(Param[i]);

  Result := BuildInteger(FItems.Count);
end;

function TJArrayObject.DoReverse(Param: TJValueList): TJValue;
//]
var
  i,len,cnt,index: Integer;
  v: TJValue;
begin
  Result := BuildObject(Self);
  cnt := FItems.Count;
  len := cnt div 2;
  for i := 0 to len - 1 do
  begin
    v := FItems[i];
    index := cnt - i - 1;
    FItems[i] := FItems[index];
    FItems[index] := v;
  end; 

end;

function TJArrayObject.DoShift(Param: TJValueList): TJValue;
//ŏ̒lԂ
begin
  EmptyValue(Result);
  if FItems.Count > 0 then
  begin
    Result := FItems[0];
    Delete(0);
  end;
end;

function TJArrayObject.DoSlice(Param: TJValueList): TJValue;
//z𔲂o
var
  i,st,en: Integer;
  list: TJArrayObject;
  v: TJValue;
begin
  st := 0;
  en := MaxInt;
  list := TJArrayObject.Create(FFactory,nil);
  Result := BuildObject(list);
  if IsParam1(Param) then
  begin
    v := Param[0];
    st := AsInteger(@v);
    if st < 0 then
      st := FItems.Count + st;
  end;

  if IsParam2(Param) then
  begin
    v := Param[1];
    en := AsInteger(@v);
    if en < 0 then
      en := FItems.Count + en;
  end;

  try
    for i := st to en - 1 do
      list.Add(FItems[i]);
  except
    on EListError do
      ;
  end;
end;

function TJArrayObject.DoSplice(Param: TJValueList): TJValue;
//l}
var
  i,st,cnt,n: Integer;
  list: TJArrayObject;
  v: TJValue;
begin
  st := 0;
  n := 0;
  list := TJArrayObject.Create(FFactory,nil);
  Result := BuildObject(list);
  if IsParam1(Param) then
  begin
    v := Param[0];
    st := AsInteger(@v);
    if st < 0 then
      st := FItems.Count + st;
  end;

  if IsParam2(Param) then
  begin
    v := Param[1];
    n := AsInteger(@v);
  end;
  //폜
  cnt := st + n - 1;
  try
    for i := cnt downto st do
    begin
      list.Insert(0,FItems[i]);
      Delete(i);
    end;
  except
    on EListError do
      ;
  end;
  //ǉ
  if (st < 0) or (st >= FItems.Count) then
    st := FItems.Count;

  try
    for i := Param.Count - 1 downto 2 do
    begin
      v := Param[i];
      Insert(st,v);
    end;
  except
    on EListError do
      ;
  end;
end;

function TJArrayObject.DoUnShift(Param: TJValueList): TJValue;
//ŏ}
var
  i: Integer;
begin
  Result := BuildObject(Self);
  for i := Param.Count - 1 downto 0 do
    Insert(0,Param[i]);
end;

function TJArrayObject.ToString(Value: PJValue): String;
var
  v: TJValue;
begin
  v := DoJoin(nil);
  Result := AsString(@v);
end;

procedure TJArrayObject.SetLength(const Value: Integer);
begin
  FItems.Count := Value;
end;

procedure TJArrayObject.Delete(Index: Integer);
var
  v: TJValue;
begin
  try
    v := FItems[Index];
    //QƃJEg炷
    DecRefObject(v);
    FItems.Delete(Index);
  except
    on EListError do
      raise EJThrow.Create(E_INDEX,'');
  end;
end;

procedure TJArrayObject.Insert(Index: Integer; Value: TJValue);
begin
  //QƃJEg𑝂₷
  IncRefObject(Value);
  FItems.Insert(Index,Value);
end;

{ TJStringObject }

constructor TJStringObject.Create(AFactory: TJObjectFactory;
  Init: TJValueList);
//IuWFNg
var
  v: TJValue;
begin
  inherited Create(AFactory,nil);
  RegistName('String');
  if IsParam1(Init) then
  begin
    v := Init[0];
    FText := AsString(@v);
  end;

  RegistMethod('charAt',DoCharAt);
  RegistMethod('anchor',DoAnchor);
  RegistMethod('big',DoBig);
  RegistMethod('blink',DoBlink);
  RegistMethod('bold',DoBold);
  RegistMethod('charCodeAt',DoCharCodeAt);
  RegistMethod('concat',DoConCat);
  RegistMethod('fixed',DoFixed);
  RegistMethod('fontcolor',DoFontColor);
  RegistMethod('fontsize',DoFontSize);
  RegistMethod('fromCharCode',DoFromCharCode);
  RegistMethod('indexOf',DoIndexOf);
  RegistMethod('italics',DoItalics);
  RegistMethod('lastIndexOf',DoLastIndexOf);
  RegistMethod('link',DoLink);
  RegistMethod('match',DoMatch);
  RegistMethod('replace',DoReplace);
  RegistMethod('search',DoSearch);
  RegistMethod('slice',DoSlice);
  RegistMethod('small',DoSmall);
  RegistMethod('split',DoSplit);
  RegistMethod('strike',DoStrike);
  RegistMethod('sub',DoSub);
  RegistMethod('substr',DoSubStr);
  RegistMethod('substring',DoSubString);
  RegistMethod('sup',DoSup);
  RegistMethod('toLowerCase',DoToLowerCase);
  RegistMethod('toUpperCase',DoToUpperCase);
  RegistMethod('toJIS',DoToJIS);
  RegistMethod('toSJIS',DoToSJIS);
  RegistMethod('toEUC',DoToEUC);
  RegistMethod('toWide',DoToWide);
  RegistMethod('toUTF8',DoToUtf8);
  RegistMethod('toString',DoToString);

  RegistMethod('fromJIStoSJIS',DoFromJISToSJIS);
  RegistMethod('fromJIStoEUC',DoFromJISToEUC);
  RegistMethod('fromEUCtoSJIS',DoFromEUCToSJIS);
  RegistMethod('fromEUCtoJIS',DoFromEUCToJIS);
  RegistMethod('fromSJIStoEUC',DoFromSJISToEUC);
  RegistMethod('fromSJIStoJIS',DoFromSJISToJIS);
  RegistMethod('fromUTF8toSJIS',DoFromUtf8ToSJIS);
end;

destructor TJStringObject.Destroy;
//j
begin
  inherited Destroy;
end;

function TJStringObject.DoAnchor(Param: TJValueList): TJValue;
//AJ[Ԃ
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildString('<A NAME="' + AsString(@v) + '">' + FText + '</A>');
  end;       
end;

function TJStringObject.DoBig(Param: TJValueList): TJValue;
begin
  Result := BuildString('<BIG>' + FText + '</BIG>');
end;

function TJStringObject.DoBlink(Param: TJValueList): TJValue;
begin
  Result := BuildString('<BLINK>' + FText + '</BLINK>');
end;

function TJStringObject.DoBold(Param: TJValueList): TJValue;
begin
  Result := BuildString('<B>' + FText + '</B>');
end;

function TJStringObject.DoCharAt(Param: TJValueList): TJValue;
//Ԃ
var
  v: TJValue;
  s: String;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    s := Copy(FText,AsInteger(@v) + 1,1);
    //if s <> '' then
      Result := BuildString(s)
    //else
    //  Result := BuildNull;
  end;
end;

function TJStringObject.DoCharCodeAt(Param: TJValueList): TJValue;
//R[hԂ
var
  v: TJValue;
  c: Char;
  s: String;
begin
  EmptyValue(Result);
  c := #0;
  if IsParam1(Param) then
  begin
    v := Param[0];
    s := Copy(FText,AsInteger(@v) + 1,1);
    if s <> '' then
      c := s[1];

    if s <> '' then
      Result := BuildInteger(Integer(c))
    else
      Result := BuildNaN;
  end;
end;

function TJStringObject.DoConCat(Param: TJValueList): TJValue;
//
var
  v: TJValue;
  i: Integer;
  s: String;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    s := FText;
    for i := 0 to Param.Count - 1 do
    begin
      v := param[i];
      s := s + AsString(@v);
    end;
    Result := BuildString(s);
  end;
end;

function TJStringObject.DoFixed(Param: TJValueList): TJValue;
begin
  Result := BuildString('<TT>' + FText + '</TT>');
end;

function TJStringObject.DoFontColor(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildString('<FONT COLOR="' + AsString(@v) + '">' + FText + '</FONT>');
  end;
end;

function TJStringObject.DoFontSize(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildString('<FONT SIZE="' + AsString(@v) + '">' + FText + '</FONT>');
  end;
end;

function TJStringObject.DoFromCharCode(Param: TJValueList): TJValue;
//R[h𕶎ɕϊ
var
  v: TJValue;
  i: Integer;
  c: Char;
  s: String;
begin
  EmptyValue(Result);
  s := '';
  if IsParam1(Param) then
  begin
    for i := 0 to Param.Count - 1 do
    begin
      v := Param[i];
      c := Char(AsInteger(@v));
      s := s + c;
    end;
    Result := BuildString(s);
  end;
end;

function TJStringObject.DoFromEUCToJIS(Param: TJValueList): TJValue;
begin
  Result := BuildString(euc2jis83(FText));
end;

function TJStringObject.DoFromEUCToSJIS(Param: TJValueList): TJValue;
begin
  Result := BuildString(euc2sjis(FText));
end;

function TJStringObject.DoFromJISToEUC(Param: TJValueList): TJValue;
begin
  Result := BuildString(jis2euc(FText));
end;

function TJStringObject.DoFromJISToSJIS(Param: TJValueList): TJValue;
begin
  Result := BuildString(jis2sjis(FText));
end;

function TJStringObject.DoFromSJISToEUC(Param: TJValueList): TJValue;
begin
  Result := BuildString(sjis2euc(FText));
end;

function TJStringObject.DoFromSJISToJIS(Param: TJValueList): TJValue;
begin
  Result := BuildString(sjis2jis83(FText));
end;

function TJStringObject.DoFromUtf8ToSJIS(Param: TJValueList): TJValue;
begin
  Result := BuildString(Utf8ToAnsi(FText));
end;

function TJStringObject.DoIndexOf(Param: TJValueList): TJValue;
//
var
  vkey,vfrom: TJValue;
  key,s: String;
  from,res: Integer;
begin
  key := '';
  from := 1;

  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    vkey := Param[0];
    key := AsString(@vkey);
    if Param.Count > 1 then
    begin
      vfrom := Param[1];
      from := AsInteger(@vfrom) + 1;
    end;

    s := Copy(FText,from,MaxInt);
    res := Pos(key,s);
    if res <= 0 then
      res := -1
    else
      res := res + from - 2;

    Result := BuildInteger(res);
  end;
end;

function TJStringObject.DoItalics(Param: TJValueList): TJValue;
begin
  Result := BuildString('<I>' + FText + '</I>');
end;

function TJStringObject.DoLastIndexOf(Param: TJValueList): TJValue;
//t猟
var
  vkey,vfrom: TJValue;
  key,s: String;
  from,res,i: Integer;
begin
  key := '';
  s := FText;
  from := system.Length(s) + 1;

  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    vkey := Param[0];
    key := AsString(@vkey);
    if Param.Count > 1 then
    begin
      vfrom := Param[1];
      i := AsInteger(@vfrom);
      from := system.Length(s) - i + 1;
    end;

    Delete(s,from,1);

    res := LastDelimiter(key,s);
    if res <= 0 then
      res := -1
    else
      res := res - 1;

    Result := BuildInteger(res);
  end;
end;

function TJStringObject.DoLink(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildString('<A HREF="' + AsString(@v) + '">' + FText + '</A>');
  end;
end;

function TJStringObject.DoMatch(Param: TJValueList): TJValue;
//K\}b`O
var
  re: TJRegExpObject;
  v: TJValue;
  list: TJValueList;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    if IsObject(@v) and (v.vObject is TJRegExpObject) then
      re := Param[0].vObject as TJRegExpObject
    else begin//K\objectoȂꍇ͕Ƃ݂Ȃ
      re := TJRegExpObject.Create(FFactory,Param);
    end;

    list := TJValueList.Create;
    //
    list.Add(BuildString(FText));
    try
      Result := re.DoExec(list);
    finally
      list.Free;
    end;
  end;
end;

function TJStringObject.DoOrd(Param: TJValueList): TJValue;
begin
end;

function TJStringObject.DoReplace(Param: TJValueList): TJValue;
//K\u
var
  re: TJRegExpObject;
  v: TJValue;
  list: TJValueList;
  newstr: String;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    if IsObject(@v) and (v.vObject is TJRegExpObject) then
    begin
      re := Param[0].vObject as TJRegExpObject;
      if IsParam2(Param) then
      begin
        v := Param[1];
        //u
        newstr := AsString(@v);
      end;
    end
    else begin//K\objectoȂꍇ͕Ƃ݂Ȃ
      re := TJRegExpObject.Create(FFactory,Param);
      if IsParam3(Param) then
      begin
        v := Param[2];
        newstr := AsString(@v);
      end
      else if IsParam2(Param) then
      begin
        v := Param[1];
        newstr := AsString(@v);
      end;
    end;

    list := TJValueList.Create;
    //
    list.Add(BuildString(FText));
    list.Add(BuildString(newstr));
    try
      Result := re.DoReplace(list);
    finally
      list.Free;
    end;
  end;
end;

function TJStringObject.DoSearch(Param: TJValueList): TJValue;
//K\}b`O
var
  re: TJRegExpObject;
  v: TJValue;
  list: TJValueList;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    if IsObject(@v) and (v.vObject is TJRegExpObject) then
      re := Param[0].vObject as TJRegExpObject
    else begin//K\objectoȂꍇ͕Ƃ݂Ȃ
      re := TJRegExpObject.Create(FFactory,Param);
    end;

    list := TJValueList.Create;
    //
    list.Add(BuildString(FText));
    try
      re.DoExec(list);
    finally
      list.Free;
    end;
    //Ԃlindex
    Result := re.GetValue('index',False);
  end;
end;

function TJStringObject.DoSlice(Param: TJValueList): TJValue;
//𕔕Rs[
var
  vfrom,vto: TJValue;
  i,f,t,len: Integer;
  s: String;
begin
  EmptyValue(Result);
  t := 1;
  s := '';
  len := system.Length(FText);
  if IsParam1(Param) then
  begin
    vfrom := Param[0];
    f := AsInteger(@vfrom);
    if f < 0 then
      f := len + f + 1
    else
      f := f + 1;
    if Param.Count > 1 then
    begin
      vto := Param[1];
      t := AsInteger(@vto);
      if t < 0 then
        t := len + t + 1
      else
        t := t + 1;
    end;

    for i := f to t do
    begin
      if (i > len) or (i < 1) then
        Break;

      s := s + FText[i];
    end;

    Result := BuildString(s);
  end;
end;

function TJStringObject.DoSmall(Param: TJValueList): TJValue;
begin
  Result := BuildString('<SMALL>' + FText + '</SMALL>');
end;

function TJStringObject.DoSplit(Param: TJValueList): TJValue;
//K\
var
  re: TJRegExpObject;
  v: TJValue;
  list: TJValueList;
  limit: Integer;
begin
  EmptyValue(Result);
  limit := MaxInt;
  if IsParam1(Param) then
  begin
    v := Param[0];
    if IsObject(@v) and (v.vObject is TJRegExpObject) then
    begin
      re := Param[0].vObject as TJRegExpObject;
      if IsParam2(Param) then
      begin
        v := Param[1];
        //
        limit := AsInteger(@v);
      end;
    end
    else begin//K\objectoȂꍇ͕Ƃ݂Ȃ
      re := TJRegExpObject.Create(FFactory,Param);
      if IsParam2(Param) then
      begin
        v := Param[1];
        if not ecma_type.IsNaN(@v) then
        begin
          limit := AsInteger(@v);
        end
        else if IsParam3(Param) then
        begin
          //QԖڂlł͂Ȃ̂łRԖ
          v := Param[2];
          limit := AsInteger(@v);
        end;
      end;
    end;

    list := TJValueList.Create;
    //
    list.Add(BuildString(FText));
    //
    list.Add(BuildInteger(limit));
    try
      Result := re.DoSplit(list);
    finally
      list.Free;
    end;
  end;
end;

function TJStringObject.DoStrike(Param: TJValueList): TJValue;
begin
  Result := BuildString('<STRIKE>' + FText + '</STRIKE>');
end;

function TJStringObject.DoSub(Param: TJValueList): TJValue;
begin
  Result := BuildString('<SUB>' + FText + '</SUB>');
end;

function TJStringObject.DoSubStr(Param: TJValueList): TJValue;
//Rs[
var
  vfrom,vlen: TJValue;
  from,len: Integer;
  s: String;
begin
  EmptyValue(Result);
  len := MaxInt;
  if IsParam1(Param) then
  begin
    vfrom := Param[0];
    from := AsInteger(@vfrom);
    if from < 0 then
      from := system.Length(FText) + from;

    if Param.Count > 1 then
    begin
      vlen := Param[1];
      len := AsInteger(@vlen);
    end;

    s := Copy(FText,from + 1,len);
    Result := BuildString(s);
  end;
end;

function TJStringObject.DoSubString(Param: TJValueList): TJValue;
var
  vfrom,vto: TJValue;
  i,f,t,len: Integer;
  s: String;
begin
  EmptyValue(Result);
  
  t := 1;
  s := '';
  len := system.Length(FText);
  if IsParam1(Param) then
  begin
    vfrom := Param[0];
    f := AsInteger(@vfrom);
    if f < 0 then
      f := len + f + 1
    else
      f := f + 1;
    if Param.Count > 1 then
    begin
      vto := Param[1];
      t := AsInteger(@vto);
      if t < 0 then
        t := len + t + 1 - 1
      else
        t := t + 1 - 1;
    end;

    for i := f to t do
    begin
      if (i > len) or (i < 1) then
        Break;

      s := s + FText[i];
    end;

    Result := BuildString(s);
  end;
end;

function TJStringObject.DoSup(Param: TJValueList): TJValue;
begin
  Result := BuildString('<SUP>' + FText + '</SUP>');
end;

function TJStringObject.DoToEUC(Param: TJValueList): TJValue;
//EUCɕϊ
begin
  Result := BuildString(ConvertJCode(FText,EUC_OUT));
end;

function TJStringObject.DoToJIS(Param: TJValueList): TJValue;
//JISɕϊ
begin
  Result := BuildString(ConvertJCode(FText,JIS_OUT));
end;

function TJStringObject.DoToLowerCase(Param: TJValueList): TJValue;
//
begin
  Result := BuildString(AnsiLowerCase(FText));
end;

function TJStringObject.DoToSJIS(Param: TJValueList): TJValue;
//SJISɕϊ
begin
  Result := BuildString(ConvertJCode(FText,SJIS_OUT));
end;

function TJStringObject.DoToUpperCase(Param: TJValueList): TJValue;
//啶
begin
  Result := BuildString(AnsiUpperCase(FText));
end;

function TJStringObject.DoToUtf8(Param: TJValueList): TJValue;
//utf8ɕϊ
begin
  Result := BuildString(AnsiToUtf8(FText));
end;

function TJStringObject.DoToWide(Param: TJValueList): TJValue;
//wideɕϊ
var
  p,w: PWideChar;
  len: Integer;
begin
  len := system.Length(FText) * 2 + 2;
  GetMem(p,len);
  try
    w := StringToWideChar(FText,p,len);
    // ϊĂ?
    Result := BuildString(PChar(w));
  finally
    FreeMem(p);
  end;

end;

function TJStringObject.GetLength: Integer;
//Ԃ
begin
  Result := system.Length(FText);
end;

function TJStringObject.GetValue(S: String; ArrayStyle: Boolean): TJValue;
var
  index,len: Integer;
begin
  //z񎮂̏ꍇ
  if ArrayStyle then
  begin
    try
      index := StrToInt(S);
      len := system.Length(FText);
      if index < 0 then
        index := len + index;

      try
        if (index >= 0) and (index < len) then
          Result := BuildString(FText[index + 1])
        else
          raise EJThrow.Create(E_INDEX,S);
      except
        //on EStringError do
          raise EJThrow.Create(E_INDEX,S);
      end;
    except
      on EConvertError do
        raise EJThrow.Create(E_INDEX,S);
    end;
  end
  else
    Result := inherited GetValue(S,ArrayStyle);
end;

procedure TJStringObject.SetLength(const Value: Integer);
//̒Zbg
begin
  if Value > -1 then
    System.SetLength(FText,Value)
  else
    raise EJThrow.Create(E_STRING,'length error ' + IntToStr(Value));
end;

procedure TJStringObject.SetValue(S: String; Value: TJValue;
  ArrayStyle: Boolean);
begin
  inherited SetValue(S,Value,ArrayStyle);
end;

function TJStringObject.ToBool: Boolean;
var
  v: TJValue;
begin
  v := BuildString(FText);
  Result := AsBool(@v);
end;

function TJStringObject.ToChar: Char;
var
  v: TJValue;
begin
  v := BuildString(FText);
  Result := AsChar(@v);
end;

function TJStringObject.ToDouble: Double;
var
  v: TJValue;
begin
  v := BuildString(FText);
  Result := AsDouble(@v);
end;

function TJStringObject.ToInteger: Integer;
var
  v: TJValue;
begin
  v := BuildString(FText);
  Result := AsInteger(@v);
end;

function TJStringObject.ToString(Value: PJValue): String;
begin
  Result := FText;
end;

{ TJNumberObject }

constructor TJNumberObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
//lIuWFNg쐬
begin
  inherited Create(AFactory,nil);
  RegistName('Number');
  if IsParam1(Param) then
  begin
    FValue := Param[0];
    //Ȃꍇ 0
    if ecma_type.IsNaN(@FValue) then
      FValue := BuildInteger(0);
  end
  else
    FValue := BuildInteger(0);

  RegistProps;
  RegistMethod('toString',DoToString);
end;

procedure TJNumberObject.RegistProps;
//vpeBo^
var
  v: TJValue;
begin
  v.ValueType := vtNaN;
  RegistProperty('NaN',v);
  v.ValueType := vtDouble;
  v.vDouble := 1.7 * 10e307;
  RegistProperty('MAX_VALUE',v);
  v.ValueType := vtDouble;
  v.vDouble := 5.0 * 10e-324;
  RegistProperty('MIN_VALUE',v);

  v.ValueType := vtInfinity;
  RegistProperty('POSITIVE_INFINITY',v);
  v.ValueType := vtInfinity;
  RegistProperty('NEGATIVE_INFINITY',v);
end;

function TJNumberObject.ToBool: Boolean;
begin
  Result := AsBool(@FValue);
end;

function TJNumberObject.ToChar: Char;
begin
  Result := AsChar(@FValue);
end;

function TJNumberObject.ToDouble: Double;
begin
  Result := AsDouble(@FValue);
end;

function TJNumberObject.ToInteger: Integer;
begin
  Result := AsInteger(@FValue);
end;

function TJNumberObject.ToString(Value: PJValue): String;
begin
  if AsInteger(Value) = 16 then
    Result := IntToHex(AsInteger(@FValue),8)
  else if AsInteger(Value) = 2 then
    Result := IntToBitStr(AsInteger(@FValue))
  else
    Result := AsString(@FValue);  
end;

{ TJBooleanObject }

constructor TJBooleanObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
var
  v: TJValue;
begin
  inherited Create(AFactory,nil);
  RegistName('Boolean');
  RegistMethod('toString',DoToString);
  if IsParam1(Param) then
  begin
    v := Param[0];
    FBool := AsBool(@v);
  end;
end;

function TJBooleanObject.ToBool: Boolean;
var
  v: TJValue;
begin
  v := BuildBool(FBool);
  Result := AsBool(@v);
end;

function TJBooleanObject.ToChar: Char;
var
  v: TJValue;
begin
  v := BuildBool(FBool);
  Result := AsChar(@v);
end;

function TJBooleanObject.ToDouble: Double;
var
  v: TJValue;
begin
  v := BuildBool(FBool);
  Result := AsDouble(@v);
end;

function TJBooleanObject.ToInteger: Integer;
var
  v: TJValue;
begin
  v := BuildBool(FBool);
  Result := AsInteger(@v);
end;

function TJBooleanObject.ToString(Value: PJValue): String;
var
  v: TJValue;
begin
  v := BuildBool(FBool);
  Result := AsString(@v);
end;

{ TJRegExpObject }

procedure TJRegExpObject.ClearMatch;
//matchNA
var
  i: Integer;
  v: TJValue;
begin
  EmptyValue(v);
  for i := 1 to 9 do
    RegistProperty('$' + IntToStr(i),v);

  //RegistProperty('input',v);
  RegistProperty('lastMatch',v);
  RegistProperty('lastParen',v);
  RegistProperty('leftContext',v);
  RegistProperty('rightContext',v);
  v := BuildInteger(-1);
  RegistProperty('index',v);
  RegistProperty('lastIndex',v);      
end;

constructor TJRegExpObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
//쐬
var
  v: TJValue;
  s: String;
begin
  inherited Create(AFactory,nil);
  RegistName('RegExp');

  FRegExp := TRegExpr.Create;
  FRegExp.ModifierR := False;

  if IsParam1(Param) then
  begin
    v := Param[0];
    try
      FRegExp.Expression := AsString(@v);
    except

    end;

    if IsParam2(Param) then
    begin
      v := Param[1];
      s := AsString(@v);
      //option ig
      if Length(s) <= 2 then
      begin
        if Pos('i',s) > 0 then
          FRegExp.ModifierI := True
        else
          FRegExp.ModifierI := False;

        if Pos('g',s) > 0 then
          FGlobal := True
        else
          FGlobal := False;
      end;
    end;
  end;

  RegistMethod('exec',DoExec);
  RegistMethod('test',DoTest);
  RegistMethod('replace',DoReplace);
  RegistMethod('split',DoSplit);
  //$1 - $9o^
  ClearMatch;
  EmptyValue(v);
  RegistProperty('input',v);
end;

destructor TJRegExpObject.Destroy;
//j
begin
  FreeAndNil(FRegExp);
  inherited Destroy;
end;

function TJRegExpObject.DoExec(Param: TJValueList): TJValue;
//K\}b`Os
var
  s,left,right: String;
  v: TJValue;
  list: TJArrayObject;
  i: Integer;
begin
  ClearMatch;
  if IsParam1(Param) then
  begin
    //Ԓl̔z
    list := TJArrayObject.Create(FFactory,nil);
    v := Param[0];
    s := AsString(@v);
    //inputvpeB
    list.SetValue('input',v,True);

    try
      ClearMatch;
      if FRegExp.Exec(s) then
      begin          
        //JnCxg
        if Assigned(FOnMatchStart) then
          FOnMatchStart(Self);

        //}b`
        v := BuildString(FRegExp.Match[0]);
        list.Add(v);
        //lastmatch
        RegistProperty('lastMatch',v);
        //index
        if FRegExp.MatchPos[0] > -1 then
          v := BuildInteger(FRegExp.MatchPos[0] - 1)
        else
          v := BuildInteger(-1);
        Registproperty('index',v);
        //lastindex
        if FRegExp.MatchLen[0] > -1 then
          v := BuildInteger(FRegExp.MatchPos[0] - 1 + FRegExp.MatchLen[0])
        else
          v := BuildInteger(-1);
        Registproperty('lastIndex',v);
        //leftcontext
        left := Copy(s,1,FRegExp.MatchPos[0] - 1);
        v := BuildString(left);
        RegistProperty('leftContext',v);
        //right
        right := Copy(s,FRegExp.MatchPos[0] + FRegExp.MatchLen[0],MaxInt);
        v := BuildString(right);
        RegistProperty('rightContext',v);

        //$
        for i := 1 to FRegExp.SubExprMatchCount do
        begin
          v := BuildString(FRegExp.Match[i]);
          //$Zbg
          //lastparen
          RegistProperty('lastParen',v);
          RegistProperty('$' + IntToStr(i),v);

          if Assigned(FOnMatchParen) then
            FOnMatchParen(Self,i,v);
        end;

        //global̏ꍇ͘Aōs
        if FGlobal then
        begin
          while FRegExp.ExecNext do
          begin
            ClearMatch;
            //JnCxg
            if Assigned(FOnMatchStart) then
              FOnMatchStart(Self);

            //}b`
            v := BuildString(FRegExp.Match[0]);
            list.Add(v);
            //lastmatch
            RegistProperty('lastMatch',v);
            //index
            if FRegExp.MatchPos[0] > -1 then
              v := BuildInteger(FRegExp.MatchPos[0] - 1)
            else
              v := BuildInteger(-1);
            Registproperty('index',v);
            //lastindex
            if FRegExp.MatchLen[0] > -1 then
              v := BuildInteger(FRegExp.MatchPos[0] - 1 + FRegExp.MatchLen[0])
            else
              v := BuildInteger(-1);
            Registproperty('lastIndex',v);
            //leftcontext
            left := Copy(s,1,FRegExp.MatchPos[0] - 1);
            v := BuildString(left);
            RegistProperty('leftContext',v);
            //right
            right := Copy(s,FRegExp.MatchPos[0] + FRegExp.MatchLen[0],MaxInt);
            v := BuildString(right);
            RegistProperty('rightContext',v);

            //$
            for i := 1 to FRegExp.SubExprMatchCount do
            begin
              v := BuildString(FRegExp.Match[i]);
              //$Zbg
              //lastparen
              RegistProperty('lastParen',v);
              RegistProperty('$' + IntToStr(i),v);

             if Assigned(FOnMatchParen) then
                FOnMatchParen(Self,i,v);
            end;
          end;

        end;

         //I
        if Assigned(FOnMatchEnd) then
          FOnMatchEnd(Self);

        //ꍇɔzԂ
        Result := BuildObject(list);
      end;
    except
      on ERegExpr do
        raise EJThrow.Create(E_REGEXP,FRegExp.Expression);
    end;
  end;

end;

function TJRegExpObject.DoReplace(Param: TJValueList): TJValue;
//u
var
  v: TJValue;
  input,repstr,res: String;
begin
  EmptyValue(Result);
  repstr := '';
  if IsParam1(Param) then
  begin
    v := Param[0];
    input := AsString(@v);
    if IsParam2(Param) then
    begin
      v := Param[1];
      repstr := AsString(@v);
    end;

    try
      res := FRegExp.Replace(input,repstr);
      Result := BuildString(res);
    except
      on ERegExpr do
        raise EJThrow.Create(E_REGEXP,FRegExp.Expression);
    end;
  end;
end;

function TJRegExpObject.DoSplit(Param: TJValueList): TJValue;
//
var
  v: TJValue;
  s: String;
  sl: TStringList;
  list: TJArrayObject;
  i,limit: Integer;
begin
  EmptyValue(Result);
  list := TJArrayObject.Create(FFactory,nil);
  if IsParam1(Param) then
  begin
    v := Param[0];
    s := AsString(@v);

    if IsParam2(Param) then
    begin
      v := Param[1];
      limit := AsInteger(@v);
    end
    else  //ԕ
      limit := MaxInt;

    sl := TStringList.Create;
    try try
      FRegExp.Split(s,sl);
      for i := 0 to sl.Count - 1 do
      begin
        if i < limit then
          list.Add(BuildString(sl[i]))
        else
          Break;
      end;
    except
      on ERegExpr do
        raise EJThrow.Create(E_REGEXP,FRegExp.Expression);
    end;
    finally
      sl.Free;
    end;    
  end;

  Result := BuildObject(list);

end;

function TJRegExpObject.DoTest(Param: TJValueList): TJValue;
//K\}b`OeXg
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := DoExec(Param);
    if not IsUnDefined(@v) then
      Result := BuildBool(True)
    else
      Result := BuildBool(False);
      //NA
  end;

end;

function TJRegExpObject.GetIgnoreCase: Boolean;
//ignorecase
begin
  Result := FRegExp.ModifierI;
end;

function TJRegExpObject.GetSource: String;
begin
  Result := FRegExp.Expression;
end;

procedure TJRegExpObject.SetIgnoreCase(const Value: Boolean);
begin
  FRegExp.ModifierI := Value;
end;

procedure TJRegExpObject.SetSource(const Value: String);
begin
  FRegExp.Expression := Value;
end;



{ TJMathObject }

constructor TJMathObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
//쐬
begin
  inherited Create(AFactory,nil);
  RegistName('Math');

  RegistMethod('abs',DoAbs);
  RegistMethod('exp',DoExp);
  RegistMethod('log',DoLog);
  RegistMethod('sqrt',DoSqrt);
  RegistMethod('ceil',DoCeil);
  RegistMethod('floor',DoFloor);
  RegistMethod('round',DoRound);
  RegistMethod('sin',DoSin);
  RegistMethod('cos',DoCos);
  RegistMethod('tan',DoTan);
  RegistMethod('asin',DoAsin);
  RegistMethod('acos',DoACos);
  RegistMethod('atan',DoAtan);
  RegistMethod('atan2',DoAtan2);
  RegistMethod('max',DoMax);
  RegistMethod('min',DoMin);
  RegistMethod('pow',DoPow);
  RegistMethod('random',DoRandom);

  Randomize;
end;

function TJMathObject.DoAbs(Param: TJValueList): TJValue;
//Βl
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    if IsDouble(@v) then
      Result := BuildDouble(system.Abs(AsDouble(@v)))
    else
      Result := BuildInteger(system.Abs(AsInteger(@v)));
  end;
end;

function TJMathObject.DoAcos(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildDouble(math.ArcCos(AsDouble(@v)));
  end;
end;

function TJMathObject.DoAsin(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildDouble(math.ArcSin(AsDouble(@v)));
  end;
end;

function TJMathObject.DoAtan(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildDouble(system.ArcTan(AsDouble(@v)));
  end;
end;

function TJMathObject.DoAtan2(Param: TJValueList): TJValue;
var
  v1,v2: TJValue;
begin
  EmptyValue(Result);
  if IsParam2(Param) then
  begin
    v1 := Param[0];
    v2 := Param[1];
    Result := BuildDouble(math.ArcTan2(AsDouble(@v1),AsDouble(@v2)));
  end;
end;

function TJMathObject.DoCeil(Param: TJValueList): TJValue;
//؂グ
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildInteger(math.Ceil(AsDouble(@v)));
  end;
end;

function TJMathObject.DoCos(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildDouble(system.Cos(AsDouble(@v)));
  end;
end;

function TJMathObject.DoExp(Param: TJValueList): TJValue;
//w֐
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildDouble(system.Exp(AsDouble(@v)));
  end;
end;

function TJMathObject.DoFloor(Param: TJValueList): TJValue;
//؂艺
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildInteger(math.Floor(AsDouble(@v)));
  end;
end;

function TJMathObject.DoLog(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildDouble(system.Ln(AsDouble(@v)));
  end;
end;

function TJMathObject.DoMax(Param: TJValueList): TJValue;
//傫
var
  v1,v2: TJValue;
begin
  EmptyValue(Result);
  if IsParam2(Param) then
  begin
    v1 := Param[0];
    v2 := Param[1];
    Result := BuildDouble(math.Max(AsDouble(@v1),AsDouble(@v2)));
  end;
end;

function TJMathObject.DoMin(Param: TJValueList): TJValue;
//
var
  v1,v2: TJValue;
begin
  EmptyValue(Result);
  if IsParam2(Param) then
  begin
    v1 := Param[0];
    v2 := Param[1];
    Result := BuildDouble(math.Min(AsDouble(@v1),AsDouble(@v2)));
  end;
end;

function TJMathObject.DoPow(Param: TJValueList): TJValue;
//ݏ
var
  v1,v2: TJValue;
begin
  EmptyValue(Result);
  if IsParam2(Param) then
  begin
    v1 := Param[0];
    v2 := Param[1];
    Result := BuildDouble(math.Power(AsDouble(@v1),AsDouble(@v2)));
  end;
end;

function TJMathObject.DoRandom(Param: TJValueList): TJValue;
//
var
  v: TJValue;
begin
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildInteger(AsInteger(@v));
  end
  else
    Result := BuildDouble(system.Random);
end;

function TJMathObject.DoRound(Param: TJValueList): TJValue;
//ۂ߂
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildInteger(system.Round(AsDouble(@v)));
  end;
end;

function TJMathObject.DoSin(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildDouble(system.Sin(AsDouble(@v)));
  end;
end;

function TJMathObject.DoSqrt(Param: TJValueList): TJValue;
//
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildDouble(system.Sqrt(AsDouble(@v)));
  end;
end;

function TJMathObject.DoTan(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildDouble(math.Tan(AsDouble(@v)));
  end;
end;

function TJMathObject.GetE: Double;
//Rΐ̒
begin
  Result := system.Exp(1);
end;

function TJMathObject.GetLN10: Double;
begin
  Result := system.Ln(10);
end;

function TJMathObject.GetLN2: Double;
begin
  Result := system.Ln(2);
end;

function TJMathObject.GetLOG10E: Double;
begin
  Result := 1 / system.Ln(10);
end;

function TJMathObject.GetLOG2E: Double;
begin
  Result := 1 / system.Ln(2);
end;

function TJMathObject.GetPI: Double;
begin
  Result := system.Pi;
end;

function TJMathObject.GetSQRT1_2: Double;
begin
  Result := system.Sqrt(0.5);
end;

function TJMathObject.GetSQRT2: Double;
begin
  Result := system.Sqrt(2);
end;

{ TJDateObject }

constructor TJDateObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
//쐬
var
  v: TJValue;
  time: TECMATime;
begin
  inherited Create(AFactory,nil);
  RegistName('Date');

  //\bho^
  RegistMethod('getFullYear',DoGetFullYear);
  RegistMethod('setFullYear',DoSetFullYear);
  RegistMethod('getYear',DoGetYear);
  RegistMethod('setYear',DoSetYear);
  RegistMethod('getMonth',DoGetMonth);
  RegistMethod('setMonth',DoSetMonth);
  RegistMethod('getDate',DoGetDate);
  RegistMethod('setDate',DoSetDate);
  RegistMethod('getDay',DoGetDay);
  RegistMethod('getHours',DoGetHours);
  RegistMethod('setHours',DoSetHours);
  RegistMethod('getMinutes',DoGetMinutes);
  RegistMethod('setMinutes',DoSetMinutes);
  RegistMethod('getSeconds',DoGetSeconds);
  RegistMethod('setSeconds',DoSetSeconds);
  RegistMethod('getMilliseconds',DoGetMilliSeconds);
  RegistMethod('setMilliseconds',DoSetMilliSeconds);

  RegistMethod('getUTCFullYear',DoGetUTCFullYear);
  RegistMethod('setUTCFullYear',DoSetUTCFullYear);
  RegistMethod('getUTCYear',DoGetUTCYear);
  RegistMethod('setUTCYear',DoSetUTCYear);
  RegistMethod('getUTCMonth',DoGetUTCMonth);
  RegistMethod('setUTCMonth',DoSetUTCMonth);
  RegistMethod('getUTCDate',DoGetUTCDate);
  RegistMethod('setUTCDate',DoSetUTCDate);
  RegistMethod('getUTCDay',DoGetUTCDay);
  RegistMethod('getUTCHours',DoGetUTCHours);
  RegistMethod('setUTCHours',DoSetUTCHours);
  RegistMethod('getUTCMinutes',DoGetUTCMinutes);
  RegistMethod('setUTCMinutes',DoSetUTCMinutes);
  RegistMethod('getUTCSeconds',DoGetUTCSeconds);
  RegistMethod('setUTCSeconds',DoSetUTCSeconds);
  RegistMethod('getUTCMilliseconds',DoGetUTCMilliSeconds);
  RegistMethod('setUTCMilliseconds',DoSetUTCMilliSeconds);

  RegistMethod('getTime',DoGetTime);
  RegistMethod('setTime',DoSetTime);
  RegistMethod('getTimezoneOffset',DoGetTimezoneOffSet);
  RegistMethod('toString',DoToString);
  RegistMethod('toLocaleString',DoToLocaleString);
  RegistMethod('toGMTString',DoToGMTString);
  RegistMethod('toUTCString',DoToUTCString);
  RegistMethod('UTC',DoUTC);
  RegistMethod('parse',DoParse);
  RegistMethod('valueOf',DoGetTime);

  //ݎ
  LocalTime := Now;
  //l
  if Assigned(Param) then
  begin
    if Param.Count = 1 then
    begin
      v := Param[0];
      //lȊȌꍇ͉
      if ecma_type.IsNaN(@v) then
        v := DoParse(Param);
      //GMTɕϊ
      time := Trunc(AsDouble(@v));
      UTC := ECMATimeToDateTime(time);
    end
    else if Param.Count > 1 then
    begin
      //͂Ă
      v := DoParse(Param);
      //GMTɕϊ
      time := Trunc(AsDouble(@v));
      UTC := ECMATimeToDateTime(time);
    end;
  end;
end;

function TJDateObject.DoGetDate(Param: TJValueList): TJValue;
var
  y,m,d: Word;
begin
  DecodeDate(LocalTime,y,m,d);
  Result := BuildInteger(d);
end;

function TJDateObject.DoGetDay(Param: TJValueList): TJValue;
begin
  Result := BuildInteger(DayOfWeek(LocalTime - 1));
end;

function TJDateObject.DoGetFullYear(Param: TJValueList): TJValue;
var
  y,m,d: Word;
begin
  DecodeDate(Localtime,y,m,d);
  Result := BuildInteger(y);
end;

function TJDateObject.DoGetHours(Param: TJValueList): TJValue;
var
  ho,mi,se,ms: Word;
begin
  DecodeTime(Localtime,ho,mi,se,ms);
  Result := BuildInteger(ho);
end;

function TJDateObject.DoGetMilliSeconds(Param: TJValueList): TJValue;
var
  ho,mi,se,ms: Word;
begin
  DecodeTime(Localtime,ho,mi,se,ms);
  Result := BuildInteger(ms);
end;

function TJDateObject.DoGetMinutes(Param: TJValueList): TJValue;
var
  ho,mi,se,ms: Word;
begin
  DecodeTime(Localtime,ho,mi,se,ms);
  Result := BuildInteger(mi);
end;

function TJDateObject.DoGetMonth(Param: TJValueList): TJValue;
var
  y,m,d: Word;
begin
  DecodeDate(Localtime,y,m,d);
  Result := BuildInteger(m - 1);
end;

function TJDateObject.DoGetSeconds(Param: TJValueList): TJValue;
var
  ho,mi,se,ms: Word;
begin
  DecodeTime(Localtime,ho,mi,se,ms);
  Result := BuildInteger(se);
end;

function TJDateObject.DoGetTime(Param: TJValueList): TJValue;
begin
  Result := BuildDouble(DateTimeToECMATime(Localtime));
end;

function TJDateObject.DoGetTimezoneOffset(Param: TJValueList): TJValue;
var
  ho,mi,se,ms: Word;
begin
  DecodeTime(GetTimeZone,ho,mi,se,ms);
  Result := BuildInteger(0 - (ho * 60));
end;

function TJDateObject.DoGetUTCDate(Param: TJValueList): TJValue;
var
  y,m,d: Word;
begin
  DecodeDate(UTC,y,m,d);
  Result := BuildInteger(d);
end;

function TJDateObject.DoGetUTCDay(Param: TJValueList): TJValue;
begin
  Result := BuildInteger(DayOfWeek(UTC) - 1);
end;

function TJDateObject.DoGetUTCFullYear(Param: TJValueList): TJValue;
var
  y,m,d: Word;
begin
  DecodeDate(UTC,y,m,d);
  Result := BuildInteger(y);
end;

function TJDateObject.DoGetUTCHours(Param: TJValueList): TJValue;
var
  ho,mi,se,ms: Word;
begin
  DecodeTime(UTC,ho,mi,se,ms);
  Result := BuildInteger(ho);
end;

function TJDateObject.DoGetUTCMilliSeconds(Param: TJValueList): TJValue;
var
  ho,mi,se,ms: Word;
begin
  DecodeTime(UTC,ho,mi,se,ms);
  Result := BuildInteger(ms);
end;

function TJDateObject.DoGetUTCMinutes(Param: TJValueList): TJValue;
var
  ho,mi,se,ms: Word;
begin
  DecodeTime(UTC,ho,mi,se,ms);
  Result := BuildInteger(mi);
end;

function TJDateObject.DoGetUTCMonth(Param: TJValueList): TJValue;
var
  y,m,d: Word;
begin
  DecodeDate(UTC,y,m,d);
  Result := BuildInteger(m - 1);
end;

function TJDateObject.DoGetUTCSeconds(Param: TJValueList): TJValue;
var
  ho,mi,se,ms: Word;
begin
  DecodeTime(UTC,ho,mi,se,ms);
  Result := BuildInteger(se);
end;

function TJDateObject.DoGetUTCYear(Param: TJValueList): TJValue;
var
  y,m,d: Word;
begin
  DecodeDate(UTC,y,m,d);
  if y < 2000 then
    Dec(y,1900);
    
  Result := BuildInteger(y - 1900);
end;

function TJDateObject.DoGetYear(Param: TJValueList): TJValue;
var
  y,m,d: Word;
begin
  DecodeDate(LocalTime,y,m,d);
  if y < 2000 then
    Dec(y,1900);

  Result := BuildInteger(y);
end;

function TJDateObject.DoParse(Param: TJValueList): TJValue;
//t͂ 1970̕bԂ
var
  s: String;
  v: TJValue;
  y,m,d,ho,mi,se,ms: Word;
  date: TDateTime;
begin
  //ݎ
  date := GMTNow;
  Result := BuildDouble(DateTimeToECMATime(date));
  if (not Assigned(Param)) or (Param.Count = 0) then
    Exit;

  if Param.Count = 1 then
  begin
    //P̕
    v := Param[0];
    s := AsString(@v);
    Result := BuildDouble(DateTimeToECMATime(DateParse(s)));
  end
  else begin
    //̐
    DecodeDate(date,y,m,d);
    DecodeTime(date,ho,mi,se,ms);

    try
      v := Param[0];
      y := AsInteger(@v);
      v := Param[1];
      //͂P炷
      m := AsInteger(@v) - 1;
      v := Param[2];
      d := AsInteger(@v);
      v := Param[3];
      ho := AsInteger(@v);
      v := Param[4];
      mi := AsInteger(@v);
      v := Param[5];
      se := AsInteger(@v);
      v := Param[6];
      ms := AsInteger(@v);
    except
      on EListError do
    end;

    try
      date := EncodeDate(y,m,d);
      date := date + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
    end;

    Result := BuildDouble(DateTimeToECMATime(date));
  end;                                                     

end;

function TJDateObject.DoSetDate(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(LocalTime,y,m,d);
    DecodeTime(LocalTime,ho,mi,se,ms);

    v := Param[0];
    d := AsInteger(@v);
    try
      LocalTime := EncodeDate(y,m,d);
      LocalTime := LocalTime + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetFullYear(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(LocalTime,y,m,d);
    DecodeTime(LocalTime,ho,mi,se,ms);
    
    v := Param[0];
    y := AsInteger(@v);
    try
      LocalTime := EncodeDate(y,m,d);
      LocalTime := LocalTime + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetHours(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(LocalTime,y,m,d);
    DecodeTime(LocalTime,ho,mi,se,ms);

    v := Param[0];
    ho := AsInteger(@v);
    try
      LocalTime := EncodeDate(y,m,d);
      LocalTime := LocalTime + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetMilliSeconds(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(LocalTime,y,m,d);
    DecodeTime(LocalTime,ho,mi,se,ms);

    v := Param[0];
    ms := AsInteger(@v);
    try
      LocalTime := EncodeDate(y,m,d);
      LocalTime := LocalTime + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetMinutes(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(LocalTime,y,m,d);
    DecodeTime(LocalTime,ho,mi,se,ms);

    v := Param[0];
    mi := AsInteger(@v);
    try
      LocalTime := EncodeDate(y,m,d);
      LocalTime := LocalTime + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetMonth(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(LocalTime,y,m,d);
    DecodeTime(LocalTime,ho,mi,se,ms);

    v := Param[0];
    m := AsInteger(@v);
    try
      //͂P𑫂
      LocalTime := EncodeDate(y,m + 1,d);
      LocalTime := LocalTime + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetSeconds(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(LocalTime,y,m,d);
    DecodeTime(LocalTime,ho,mi,se,ms);

    v := Param[0];
    se := AsInteger(@v);
    try
      LocalTime := EncodeDate(y,m,d);
      LocalTime := LocalTime + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetTime(Param: TJValueList): TJValue;
var
  v: TJValue;
  time: TECMATime;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    time := AsDouble(@v);
    //UTCœ
    UTC := ECMATimeToDateTime(time);
  end;
end;

function TJDateObject.DoSetUTCDate(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(UTC,y,m,d);
    DecodeTime(UTC,ho,mi,se,ms);

    v := Param[0];
    d := AsInteger(@v);
    try
      UTC := EncodeDate(y,m,d);
      UTC := UTC + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetUTCFullYear(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(UTC,y,m,d);
    DecodeTime(UTC,ho,mi,se,ms);

    v := Param[0];
    y := AsInteger(@v);
    try
      UTC := EncodeDate(y,m,d);
      UTC := UTC + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetUTCHours(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(UTC,y,m,d);
    DecodeTime(UTC,ho,mi,se,ms);

    v := Param[0];
    ho := AsInteger(@v);
    try
      UTC := EncodeDate(y,m,d);
      UTC := UTC + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetUTCMilliSeconds(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(UTC,y,m,d);
    DecodeTime(UTC,ho,mi,se,ms);

    v := Param[0];
    ms := AsInteger(@v);
    try
      UTC := EncodeDate(y,m,d);
      UTC := UTC + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetUTCMinutes(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(UTC,y,m,d);
    DecodeTime(UTC,ho,mi,se,ms);

    v := Param[0];
    mi := AsInteger(@v);
    try
      UTC := EncodeDate(y,m,d);
      UTC := UTC + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetUTCMonth(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(UTC,y,m,d);
    DecodeTime(UTC,ho,mi,se,ms);
    
    v := Param[0];
    m := AsInteger(@v);
    try
      //P𑫂
      UTC := EncodeDate(y,m + 1,d);
      UTC := UTC + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetUTCSeconds(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(UTC,y,m,d);
    DecodeTime(UTC,ho,mi,se,ms);

    v := Param[0];
    se := AsInteger(@v);
    try
      UTC := EncodeDate(y,m,d);
      UTC := UTC + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetUTCYear(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(UTC,y,m,d);
    DecodeTime(UTC,ho,mi,se,ms);

    v := Param[0];
    y := AsInteger(@v);
    try
      UTC := EncodeDate(y,m,d);
      UTC := UTC + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoSetYear(Param: TJValueList): TJValue;
var
  y,m,d,ho,mi,se,ms: Word;
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    DecodeDate(LocalTime,y,m,d);
    DecodeTime(LocalTime,ho,mi,se,ms);

    v := Param[0];
    y := AsInteger(@v);
    try
      LocalTime := EncodeDate(y,m,d);
      LocalTime := LocalTime + EncodeTime(ho,mi,se,ms);
    except
      on EConvertError do
        ;
    end;
  end;
end;

function TJDateObject.DoToGMTString(Param: TJValueList): TJValue;
begin
  Result := BuildString(DateTimeToStr(UTC));
end;

function TJDateObject.DoToLocaleString(Param: TJValueList): TJValue;
begin
  Result := BuildString(ToString);
end;

function TJDateObject.DoToUTCString(Param: TJValueList): TJValue;
begin
  Result := BuildString(DateTimeToStr(UTC));
end;

function TJDateObject.DoUTC(Param: TJValueList): TJValue;
begin
  Result := DoParse(Param);
end;

function TJDateObject.GetLocal: TDateTime;
//Localɕϊ
begin
  Result := GMTToLocalDateTime(FDate);
end;

function TJDateObject.GetUTC: TDateTime;
//GMTԂ
begin
  Result := FDate;
end;

procedure TJDateObject.SetLocal(const Value: TDateTime);
//Localϊ
begin
  FDate := LocalDateTimeToGMT(Value);
end;

procedure TJDateObject.SetUTC(const Value: TDateTime);
//GMTϊ
begin
  FDate := Value;
end;

function TJDateObject.ToString(Value: PJValue): String;
begin
  Result := DateTimeToStr(LocalTime);
end; 


end.
