unit dm_main;

//R\[C
//2001/04/30
//by Wolfy

interface

uses
  dmonkey,ecma_type,classes,sysutils;

type
  TDMMain = class(TObject)
  private
    FDM: TDMonkey;

    procedure DMStdout(Sender: TObject; S: String);
  public
    constructor Create;
    destructor Destroy; override;
    procedure Run;
  end;


implementation

{ TDMMain }

constructor TDMMain.Create;
begin
  inherited Create;
  FDM := TDMonkey.Create(nil);
  FDM.OnStdout := DMStdout;
end;

destructor TDMMain.Destroy;
begin
  FDM.Free;
  inherited;
end;

procedure TDMMain.DMStdout(Sender: TObject; S: String);
begin
  Write(S);
end;

procedure TDMMain.Run;
var
  param: TJValueList;
  i: Integer;
  sl: TStringList;
  filename: String;
begin
  param := TJValueList.Create;
  sl := TStringList.Create;
  try
    if ParamCount < 1 then
    begin
      Writeln('usage: dm SCRIPT_NAME');
      Exit;
    end
    else begin
      filename := ParamStr(1);
      if not FileExists(filename) then
      begin
        Writeln('file not found');
        Exit;
      end
      else begin
        sl.LoadFromFile(filename);
        for i := 1 to ParamCount do
          param.Add(BuildString(ParamStr(i)));

        FDM.Compile(sl.Text);
        FDM.Run(param);
      end;
    end;
  finally
    sl.Free;
    param.Free;
  end;
end;

end.
