unit misc;

{$IFDEF VER130}
{$ELSE}
  {$WARN SYMBOL_PLATFORM OFF}
  {$WARN UNIT_PLATFORM OFF}
{$ENDIF}

interface

uses
  windows,sysutils,classes;

//ftHgtt
function StrToDateTimeDef(const S: string; Default: TDateTime): TDateTime;
function StrToDateDef(const S: string; Default: TDateTime): TDateTime;
function StrToTimeDef(const S: string; Default: TDateTime): TDateTime;

function StrToFloatDef(const S: string; F: Extended): Extended;

function GetFileSize(const FileName: String): Integer;


implementation

function StrToDateTimeDef(const S: string; Default: TDateTime): TDateTime;
begin
  try
    Result := StrToDateTime(S);
  except
    Result := Default;
  end;
end;

function StrToDateDef(const S: string; Default: TDateTime): TDateTime;
begin
  try
    Result := StrToDate(S);
  except
    on EConvertError do
      Result := Default;
  end;
end;

function StrToTimeDef(const S: string; Default: TDateTime): TDateTime;
begin
  try
    Result := StrToTime(S);
  except
    on EConvertError do
      Result := Default;
  end;
end;

function StrToFloatDef(const S: string; F: Extended): Extended;
begin
  try
    Result := StrToFloat(S);
  except
    on EConvertError do
      Result := F;
  end;
end;

function GetFileSize(const FileName: String): Integer;
//t@CTCY擾
var
  SR :TSearchRec;
begin
  //t@CTCY擾
  if FindFirst(FileName,faHidden or faArchive or faSysFile or faReadOnly ,SR) = 0 then
  begin
    Result := SR.Size;
    FindClose(SR);
  end
  else
    Result := 0;  
end;


end.
