unit ecma_engine;

//͖؂̎s
//2001/04/10 ~
//by Wolfy

{$DEFINE REFCOUNT_DEBUG}

interface

uses
  windows,classes,sysutils,ecma_type,hashtable,ecma_object,
{$IFNDEF NO_SOCKET}
  ecma_sockobject,
{$ENDIF}
{$IFNDEF NO_ACTIVEX}
  activex,ComObj,ecma_activex,
{$ENDIF}
{$IFNDEF NO_DYNACALL}
  dynamiccall,
{$ENDIF}
{$IFNDEF NO_WSH}
  ecma_wsh,
{$ENDIF}
{$IFNDEF CONSOLE}
  forms,
{$ENDIF}
  ecma_parser;

type
  TJEngine = class(TJBaseEngine)
  private
    FParent: TJBaseDMonkey;
    FParser: TJParser;
    FRootTable: TJRootSymbolTable;
    FCurrentTable: TJLocalSymbolTable;
    FFactory: TJObjectFactory;

    FIsRan: Boolean;
    FAbort: Boolean;
    FIsRunning: Boolean;
    FLineNo: Integer;
    FAllowEvent: Boolean;
    FFilename: String;
    FRegistVar: TJRegistVarType;
    //event
    FOnNewObject: TNewObjectEvent;
    FOnStdout: TStringEvent;
    FOnStderr: TStringEvent;
    FOnRun: TNotifyEvent;
    FOnDone: TNotifyEvent;
    FOnStep: TStepEvent;
    FOnStdin: TReadStringEvent;
    FOnError: TErrorEvent;
    FOnDoEvents: TStepEvent;

    //global object
    FGlobalObject: TJGlobalObject;
    FRegExpObject: TJRegExpObject;
{$IFNDEF NO_WSH}
    FWScriptObject: TJWScriptObject;
{$ENDIF}
    procedure Println(S: String);
    procedure PrintlnError(S: String);

    function EvalExpr(P: PJExpr; Flags: TJEvalExprFlags = []): TJValue;
    procedure EvalStatement(P: PJStatement; Flags: TJEvalStatementFlags; SwitchValue: PJSwitchValue = nil);

    function MemberExpr(Parent: TJValue; Member: String; Deleting: Boolean = False): TJValue;
    procedure MemberAssign(Parent: TJValue; Member: String; Value: TJValue);
    function CallArrayExpr(Parent: TJValue; Arguments: PJExpr): TJValue;
    procedure CallArrayAssign(Parent: TJValue; Arguments: PJExpr; Value: TJValue);
    function MethodExpr(P: PJExpr): TJValue;
    procedure MethodAssign(P: PJExpr; Value: TJValue);

    function ArgumentsToList(Arg: PJExpr): TJValueList;
    function ArgumentsToValue(Arg: PJExpr): TJValue;
    function ArgumentsCount(Arg: PJExpr): Integer;
    procedure ObjectExpr(Obj: TJObject; Elements: PJExpr);

    procedure MakeInstance(Obj: TJObject; Members: PJStatement);
    procedure RegistGlobalObjects(ASymbolTable: TJLocalSymbolTable);
    procedure ClearGlobalObjects;

    function GetThisFromValue(Value: TJValue): TJObject;

    procedure BeforeRun(Main: Boolean = False);
    procedure AfterRun;

    //object event
    procedure RegExpOnMatchStart(Sender: TObject);
    procedure RegExpOnMatchEnd(Sender: TObject);
    procedure RegExpOnExecInput(Sender: TObject; var Input: String);

    procedure FactoryOnNewObject(Sender: TObject; JObject: TJObject);

    procedure GlobalObjectOnPrint(Sender: TObject; S: String);
    procedure GlobalObjectOnPrintError(Sender: TObject; S: String);
    procedure GlobalObjectOnRead(Sender: TObject; var S: String; var Success: Boolean;
      Count: Integer; Line: Boolean);

    function GetObjectCount: Integer;
    function GetOnDebugout: TStringEvent;
    procedure SetOnDebugout(const Value: TStringEvent);
  public
    constructor Create(AParent: TJBaseDMonkey);
    destructor Destroy; override;
    procedure Clear;
    procedure Abort;

    function Compile(SourceCode: String): Boolean;
    function CompileFile(AFilename: String; UseBinary: Boolean): Boolean;
    function Run(Root: PJStatement; Args: TJValueList): Integer; overload;
    function Run: Integer; overload;
    function CallExpr(Func: IJFunction; Param: TJValueList; This: TJObject = nil): TJValue;
    function CallFunction(Root: PJStatement; Symbol: String;
      Param: TJValueList; var RetValue: TJValue): Boolean; overload;
    function CallFunction(Symbol: String;
      Param: TJValueList; var RetValue: TJValue): Boolean; overload;
    function CallEvent(var Event: TJValue; Param: TJValueList; This: TJObject = nil): TJValue;
    function Eval(SourceCode: String; This: TJObject = nil): TJValue;

    function MakeObject(Name: String; Param: TJValueList): TJObject; override;
    procedure ImportObject(ObjectName: String; ObjectClass: TJObjectClass); override;
    function IsRunning: Boolean;
    function GetVariable(Symbol: String; var RetVal: TJValue): Boolean;
    function DoEvents: Boolean;
    function GetScriptFilename: String; override;
    function FindImportFilename(Filename: String; var FindedFilename: String): Boolean; override;

    property GlobalObject: TJGlobalObject read FGlobalObject;
    property ObjectCount: Integer read GetObjectCount;
    property Factory: TJObjectFactory read FFactory;
    property Parent: TJBaseDMonkey read FParent;
    property LineNo: Integer read FLineNo write FLineNo;
    property AllowEvent: Boolean read FAllowEvent;
    property ScriptFilename: String read GetScriptFilename;
    property Parser: TJParser read FParser;
    property CurrentTable: TJLocalSymbolTable read FCurrentTable;
    property RegistVar: TJRegistVarType read FRegistVar write FRegistVar;
    //event
    property OnNewObject: TNewObjectEvent read FOnNewObject write FOnNewObject;
    property OnStdout: TStringEvent read FOnStdout write FOnStdout;
    property OnStderr: TStringEvent read FOnStderr write FOnStderr;
    property OnRun: TNotifyEvent read FOnRun write FOnRun;
    property OnDone: TNotifyEvent read FOnDone write FOnDone;
    property OnStep: TStepEvent read FOnStep write FOnStep;
    property OnStdin: TReadStringEvent read FOnStdin write FOnStdin;
    property OnError: TErrorEvent read FOnError write FOnError;
    property OnDebugout: TStringEvent read GetOnDebugout write SetOnDebugout;
    property OnDoEvents: TStepEvent read FOnDoEvents write FOnDoEvents;
  end;

implementation


{ TJEngine }

procedure TJEngine.Println(S: String);
//stdout
begin
  GlobalObjectOnPrint(Self,S + CRLF);
end;

constructor TJEngine.Create(AParent: TJBaseDMonkey);
//쐬
begin
  inherited Create;
  FParent := AParent;
  FParser := TJParser.Create;
  FFactory := TJObjectFactory.Create(Self);
  FFactory.OnNewObject := FactoryOnNewObject;
  FRootTable := TJRootSymbolTable.Create(nil);
  FCurrentTable := FRootTable;

  //g݃IuWFNgo^
  ImportObject('Object',TJObject);
  ImportObject('Global',TJGlobalObject);
  ImportObject('Array',TJArrayObject);
  ImportObject('String',TJStringObject);
  ImportObject('Number',TJNumberObject);
  ImportObject('Boolean',TJBooleanObject);
  ImportObject('RegExp',TJRegExpObject);
  ImportObject('Math',TJMathObject);
  ImportObject('Date',TJDateObject);

  //ftHgIuWFNg
  FGlobalObject := TJGlobalObject.Create(Self,nil,False);
  FGlobalObject.OnPrint := GlobalObjectOnPrint;
  FGlobalObject.OnRead := GlobalObjectOnRead;
  FRegExpObject := TJRegExpObject.Create(Self,nil,False);
{$IFNDEF NO_WSH}
  FWScriptObject := TJWScriptObject.Create(Self,nil,False);
  FWScriptObject.OnStdOut := GlobalObjectOnPrint;
  FWScriptObject.OnStdErr := GlobalObjectOnPrintError;
  FWScriptObject.OnStdIn := GlobalObjectOnRead;
{$ENDIF}
  //QƃJEg
  FGlobalObject.IncRef;
  FRegExpObject.IncRef;
{$IFNDEF NO_WSH}
  FWScriptObject.IncRef;
{$ENDIF}
end;

destructor TJEngine.Destroy;
//j
begin
  Clear;
  //QƃJEg
  FreeAndNil(FGlobalObject);
  FreeAndNil(FRegExpObject);
{$IFNDEF NO_WSH}
  FreeAndNil(FWScriptObject);
{$ENDIF}

  FreeAndNil(FRootTable);
  FreeAndNil(FFactory);
  FreeAndNil(FParser);
  inherited;
end;

function TJEngine.Run(Root: PJStatement; Args: TJValueList): Integer;
//s
begin
  Result := 0;
  //s̏ꍇI
  if IsRunning then
    Exit;
  //rootꍇ
  if not Assigned(Root) then
    Root := FParser.Root;
  //rootΏI
  if not Assigned(Root) then
    Exit;

  //s
  FIsRunning := True;
  BeforeRun(True);
  try
    Clear;
    FAbort := False;
    FAllowEvent := True;
    //GlobalZbg
    FGlobalObject.arguments.Items.Assign(Args);
    //terminatedZbg
    FGlobalObject.Terminate;
    try
      //s
      FCurrentTable := FRootTable;
      EvalStatement(Root,[]);
      FIsRan := True;
      //IuWFNggp邽߂currenttable__MAIN__ɕύX
      FCurrentTable := FRootTable.FindGlobalTable(__MAIN__);
    except
      on E:EJThrow do
        PrintlnError('Exception: ' +
          E.ExceptName + '(' + IntToStr(FLineNo) + ') => ' + E.Message);
      on E:EJReturn do
      begin
        Result := AsInteger(@E.Value);
      end;
      on E:EJAbort do
        PrintlnError('Abort Script(' + IntToStr(FLineNo) + ')');
      on E:EJExit do
        Result := E.Status;
      on E:EJSyntaxError do
      begin
        PrintlnError('SyntaxError: ' +
          'Line(' + IntToStr(FLineNo) + ') => ' + E.Message);
      end;
    end;

    //Cxg[vɓ
    while ((not FGlobalObject.Terminated) and
           DoEvents) do
    begin
      Sleep(5);
    end;

    AfterRun;
  finally
    FIsRunning := False;
  end;
end;

procedure TJEngine.EvalStatement(P: PJStatement;
  Flags: TJEvalStatementFlags; SwitchValue: PJSwitchValue);
//ԂɎs
var
  current,catch: PJStatement;
  v,compared: TJValue;
  abrt,ebreak: Boolean;
  element: String;
  sl: TStringList;
  i: Integer;
  func: IJFunction;
  switch: TJSwitchValue;
{$IFNDEF NO_ACTIVEX}
  enum: TJEnumeratorObject;
  param: TJValueList;
{$ENDIF}
  arry: TJObject;
  blocktable,
  oldtable: TJLocalSymbolTable;
begin
  current := P;
  while Assigned(current) do
  begin
    //abort
    if FAbort then
      raise EJAbort.Create('script abort');

    //sԍ
    FLineNo := current^.LineNo;
    //Cxg
    if Assigned(FOnStep) then
    begin
      abrt := False;
      FOnStep(Self,abrt);
      //~
      if abrt then
        raise EJAbort.Create('script abort');
    end;

    case current^.SType of
      stNone:;

      //sourceC|[g
      stSource:
      begin
        //Roote[uɒlƂēo^
        EmptyFunction(func);
        func.FuncType := ftImport;
        func.vStatement := current^.Sub1;
        //O exprȂGlobal
        if not Assigned(current^.Expr) then
          func.Symbol := __MAIN__
        else
          func.Symbol := current^.Expr^.Symbol;

        //e[u쐬 pointern thiso^
        func.FunctionTable := FRootTable.MakeGlobalTable(func.Symbol,current);
        func.FunctionTable.This := FGlobalObject;
        //O[oϐo^
        RegistGlobalObjects(func.FunctionTable);
        //Namespaceo^
        FRootTable.RegistGlobalValue(func.Symbol,BuildFunction(func));
        //Ve[uŎs
        oldtable := FCurrentTable;
        FCurrentTable := func.FunctionTable;
        try
          EvalStatement(func.vStatement,[]);
        finally
          FCurrentTable := oldtable;
          //global table͍폜Ȃ
        end;
      end;
      //ϐ錾Jn
      stVar:
      begin
        //stVarDecl
        EvalStatement(current^.Sub1,Flags + [esfVar]);
      end;
      //staticϐ錾Jn
      stStatic:
      begin
        //stVarDecl
        EvalStatement(current^.Sub1,Flags + [esfStaticVar]);
      end;
      //Globalϐ錾Jn
      stGlobal:
      begin
        //stVarDecl
        EvalStatement(current^.Sub1,Flags + [esfGlobalVar]);
      end;
      stVariableDecl:
      begin  //ϐ錾o^
        if Assigned(current^.Expr^.Left) then
          v := EvalExpr(current^.Expr^.Left)
        else  //0
          v := BuildInteger(0);

        //ϐo^
        if esfVar in Flags then
          FCurrentTable.RegistValue(current^.Expr^.Symbol,v)
        else if esfStaticVar in Flags then
          FCurrentTable.RegistStaticValue(current^.Expr^.Symbol,v)
        else
          FCurrentTable.RegistGlobalValue(current^.Expr^.Symbol,v)
      end;
      //֐`
      stFunctionDecl:
      begin
        //֐Zbg
        EmptyFunction(func);
        func.FuncType := ftStatement;
        func.vStatement := current;
        //p[^Zbg
        func.Parameter := current^.Sub1;
        //V{e[u쐬
        //e֐p
        func.FunctionTable :=
          FRootTable.GetFunctionTable(current^.Temp,current);
        //ϐ݂Ȃꍇ
        if Assigned(current^.Expr) then
        begin
          //֐
          func.Symbol := current^.Expr^.Symbol;
          //e[uɓo^
          FCurrentTable.RegistValue(func.Symbol,BuildFunction(func));
        end;
      end;
      //NX`
      stClassDecl:
      begin
        EmptyFunction(func);
        func.Symbol := current^.Expr^.Symbol;
        func.FuncType := ftClass;
        func.vStatement := current;
        //V{e[u쐬
        //e֐p
        func.FunctionTable :=
          FRootTable.GetFunctionTable(current^.Temp,current);
        //o^
        FCurrentTable.RegistValue(func.Symbol,BuildFunction(func));
      end;
      //
      stExpr: EvalExpr(current^.Expr);
      //blocks
      stBlock:
      begin
        EvalStatement(current^.Sub1,Flags);
      end;
      //for
      stFor:
      begin
        //
        EvalExpr(current^.Expr);
        while True do
        begin
          //݂ꍇ̂
          if Assigned(current^.Sub2^.Expr) then
          begin
            v := EvalExpr(current^.Sub2^.Expr);
            if not AsBool(@v) then
              Break;
          end;

          ebreak := False;
          try
            try
              //ubNs
              EvalStatement(current^.Sub1,[esfIteration]);
            except
              //OƂĎ
              on EJBreak do
              begin
                ebreak := True;
                Break;
              end;
              on EJContinue do
                Continue;
            end;
          finally
            //n break̏ꍇ͎sȂ
            if not ebreak then
              EvalExpr(current^.Sub2^.Next^.Expr);
          end;
        end;
      end;
      //if
      stIf:
      begin
        v := EvalExpr(current^.Expr);
        if AsBool(@v) then
          EvalStatement(current^.Sub1,Flags)
        else begin
          EvalStatement(current^.Sub2,Flags);
        end;
      end;
      //while 
      stWhile:
      begin
        while True do
        begin
          v := EvalExpr(current^.Expr);
          if not AsBool(@v) then
            Break;

          try
            //s
            EvalStatement(current^.Sub1,[esfIteration]);
          except
            //OƂĎ
            on EJBreak do
              Break;
            on EJContinue do
              Continue;
          end;
        end;
      end;
      //for in
      stForIn,stForInArrayElement:
      begin
        //var
        if current^.Expr^.Code = opVariable then
          element := current^.Expr^.Symbol
        //var
        else if Assigned(current^.Expr^.Left) and
               (current^.Expr^.Left^.Code = opVariable) then
        begin
          element := current^.Expr^.Left^.Symbol;
          //[Jɕϐo^
          EmptyValue(v);
          FCurrentTable.RegistValue(element,v);
        end
        else //ϐŖꍇ͗O
          raise EJThrow.Create(E_TYPE,'need variable - for..in');

        v := EvalExpr(current^.Sub2^.Expr);
        //z
        if IsArrayObject(@v) then
        begin
          arry := v.vObject;
          case current^.SType of
            //vf
            stForInArrayElement:
            begin
              for i := 0 to arry.GetCount - 1 do
              begin
                FCurrentTable.SetValue(element,arry.GetItem(i),FRegistVar);
                try
                  //ubNs
                  EvalStatement(current^.Sub1,[esfIteration]);
                except
                  //OƂĎ
                  on EJBreak do
                    Break;
                  on EJContinue do
                    Continue;
                end;
              end;
            end;
            //index
            stForIn:
            begin
              for i := 0 to arry.GetCount - 1 do
              begin
                FCurrentTable.SetValue(element,BuildInteger(i),FRegistVar);
                try
                  //ubNs
                  EvalStatement(current^.Sub1,[esfIteration]);
                except
                  //OƂĎ
                  on EJBreak do
                    Break;
                  on EJContinue do
                    Continue;
                end;
              end;
            end;
          end;
        end
{$IFNDEF NO_ACTIVEX}
        else if IsCollection(@v) then //Enumerators
        begin
          param := TJValueList.Create;
          try
            param.Add(v);
            enum := TJEnumeratorObject.Create(Self,param);
            try
              enum.IncRef;

              while not enum.AtEnd do
              begin
                FCurrentTable.SetValue(element,enum.Item,FRegistVar);
                try try
                  //ubNs
                  EvalStatement(current^.Sub1,[esfIteration]);
                finally
                  enum.MoveNext;
                end;
                except
                  //OƂĎ
                  on EJBreak do
                    Break;
                  on EJContinue do
                    Continue;
                end;
              end;
            finally
              enum.DecRef;
            end;
          finally
            param.Free;
          end;
        end
{$ENDIF}
        else if IsObject(@v) then
        begin
          //SĂkey𓾂
          sl := TStringList.Create;
          try
            v.vObject.GetPropertyList(sl);
            for i := 0 to sl.Count - 1 do
            begin
              //keyϐɓ
              FCurrentTable.SetValue(element,BuildString(sl[i]),FRegistVar);
              try
                //ubNs
                EvalStatement(current^.Sub1,[esfIteration]);
              except
                //OƂĎ
                on EJBreak do
                  Break;
                on EJContinue do
                  Continue;
              end;
            end;
          finally
            sl.Free;
          end;
        end
        else //IuWFNgłȂȂO
          raise EJThrow.Create(E_TYPE,'need object,array or collection - for..in');
      end;

      //switch
      stSwitch:
      begin
        //]
        v := EvalExpr(current^.Expr);
        try
          //labeleds SwitchValuet
          switch.Match := False;
          switch.Default := nil;
          switch.Value := @v;
          //iterationtrue
          //܂xdefault𖳎ĎsĂ݂
          EvalStatement(current^.Sub1,[esfIteration],@switch);
          //matchȂdefault傪݂default傩s
          if not switch.Match and Assigned(switch.Default) then
          begin
            switch.Match := True;
            EvalStatement(switch.Default,[esfIteration],@switch);
          end;
        except //break󂯂
          on EJBreak do
        end;
      end;
      //case default
      stLabeled:
      begin
        //switch value鎞̂ݎs
        if Assigned(SwitchValue) then
        begin
          //matchĂ鎞͖Ŏs
          if SwitchValue^.Match then
            EvalStatement(current^.Sub1,Flags,nil)
          else begin
            //case:
            if Assigned(current^.Expr) then
            begin
              //萔l𓾂
              v := EvalExpr(current^.Expr);
              //K\eŔr
              if IsRegExpObject(@v) then
              begin
                compared :=
                  BuildBool((v.vObject as TJRegExpObject).Test(SwitchValue^.Value^));
              end
              else if IsRegExp(@v) then
              begin
                FRegExpObject.SetRegExpValue(v);
                compared :=
                  BuildBool(FRegExpObject.Test(SwitchValue^.Value^));
              end
              else //Ŕr
                compared := CompareValue(opEQ,v,SwitchValue^.Value^);

              if AsBool(@compared) then
              begin
                EvalStatement(current^.Sub1,Flags,nil);
                //vȍ~͖Ŏs
                SwitchValue^.Match := True;
              end;
            end
            //default:
            else
              SwitchValue^.Default := current; //default̏ꏊۑƂ
          end;
        end
        else //ςȏꏊlabel
          raise EJThrow.Create(E_SYNTAX,'switch case: or default:');
      end;

      stDo: //do - while
      begin
        while True do
        begin
          try
            //s
            EvalStatement(current^.Sub1,[esfIteration]);
          except
            //OƂĎ
            on EJBreak do
              Break;
            on EJContinue do
              Continue;
          end;

          //𔻒f
          v := EvalExpr(current^.Expr);
          if not AsBool(@v) then
            Break;
        end;
      end;
      //break  for,while doswitch~߂
      stBreak:
      begin
        if esfIteration in Flags then
          raise EJBreak.Create('break')
        else
          raise EJThrow.Create(E_SYNTAX,'break');
      end;
      //continue
      stContinue:
      begin
        if esfIteration in Flags then
          raise EJContinue.Create('continue')
        else
          raise EJThrow.Create(E_SYNTAX,'continue');
      end;
      //return
      stReturn:
      begin
        //returnO
        v := EvalExpr(current^.Expr);
        //QƃJEg₷
        if IsObject(@v) then
          v.vObject.IncRef
        //֐ȂΕϐRs[
        else if IsFunction(@v) then
        begin
          //VK쐬
          EmptyFunction(func);
          //copy
          func.Assign(v.vFunction);
          //localtable쐬
          if not Assigned(func.LocalTable) then
            func.LocalTable := TJLocalSymbolTable.Create(nil);

          //Jgϐcopy
          func.LocalTable.LocalCopy(FCurrentTable);
          //vύX
          v := BuildFunction(func);
        end;

        raise EJReturn.Create(v);
      end;
      //throw
      stThrow:
      begin
        v := EvalExpr(current^.Expr);
        //QƃJEg₷
        if IsObject(@v) then
          v.vObject.IncRef
        else if IsUndefined(@v) then
          v := BuildString(''); //󕶎
        //throwO
        raise EJThrow.Create(E_THROW,'',@v);
      end;
      //try
      stTry:
      begin
        //try - sub1(block)
        //    - sub2(catch)
        //    - sub3(finally)
        try try
          EvalStatement(current^.Sub1,Flags);
        except
          //catch
          on E:EJRuntimeError do
          begin
            //Đ
            if not Assigned(current^.Sub2) then
              raise;

            catch := current^.Sub2;
            //ϐo^
            if IsVariable(catch^.Expr) then
            begin
              //userO
              if E.ExceptName = E_THROW then
              begin
                //tempɎQƃJEgωȂœo^
                if IsObject(@E.Value) then
                  FCurrentTable.AddTemporaryObject(E.Value.vObject,False);
                //o^
                FCurrentTable.RegistValue(catch^.Expr^.Symbol,E.Value);
              end
              else //Oo^
                FCurrentTable.RegistValue(
                  catch^.Expr^.Symbol,BuildString(E.ExceptName));
            end;
            //catchs
            EvalStatement(catch^.Sub1,Flags);
          end;
        end;

        finally
          //finallys
          if Assigned(current^.Temp) then
            EvalStatement(current^.Temp^.Sub1,Flags);
        end;
      end;
      //with
      stWith:
      begin
        v := EvalExpr(current^.Expr);
        //objectłȂȂO
        if not IsObject(@v) then
          raise EJThrow.Create(E_TYPE,'need object - with');

        //VubN thispush
        blocktable := FCurrentTable.PushLocalTable(nil,v.vObject);
        oldtable := FCurrentTable;
        FCurrentTable := blocktable;
        try
          EvalStatement(current^.Sub1,Flags);
        finally
          FCurrentTable := oldtable;
          FCurrentTable.PopLocalTable;
        end;
      end;

    end;

    //
    current := current^.Next;
  end;
end;

function TJEngine.EvalExpr(P: PJExpr; Flags: TJEvalExprFlags): TJValue;
//]
var
  l,r,t: PJExpr;
  v: TJValue;
  param: TJValueList;
  name: String;
  func: IJFunction;
begin
  EmptyValue(Result);
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  t := P^.Third;

  case P^.Code of
    opExpr:
    begin
      EvalExpr(l);
      Result := EvalExpr(r);
    end;

    //萔ĉ܂ܕԂ
    opConstant:
    begin
      Result := P^.Value^;
    end;

    //[Jϐ錾(forŎg)
    opVar:
    begin
      //
      Result := EvalExpr(l,Flags + [eefVar]);
    end;

    //ϐce[u猟
    opVariable:
    begin
      //ϐ錾
      {if eefVar in Flags then
      //  FCurrentTable.RegistLocal(P^.Symbol,Result)
      //ʏ
      else
      }
      if FCurrentTable.GetValue(P^.Symbol,Result) then
      begin
        {if eefDelete in Flags then
        begin
        end;}
      end
      else //ϐ`Ȃ̂ŗO
        raise EJThrow.Create(E_NAME,'undefined - ' + P^.Symbol);
    end;

    // variable = expr
    opAssign:
    begin
      Result := EvalExpr(r);
      //ł̂4ނ̂
      case l^.Code of
        opVariable:
        begin
          if eefVar in Flags then //opVar(for)Ŏgp
            FCurrentTable.RegistValue(l^.Symbol,Result)
          else
            FCurrentTable.SetValue(l^.Symbol,Result,FRegistVar);
        end;

        opMember: MemberAssign(EvalExpr(l^.Left),l^.Right^.Symbol,Result);
        opCallArray: CallArrayAssign(EvalExpr(l^.Left),l^.Right,Result);
        opMethod: MethodAssign(l,Result);
      else
        raise EJThrow.Create(E_TYPE,'can not assign - ' + l^.Symbol);
      end;
    end;

    //Z
    opMulAssign,opDivAssign,opAddAssign,opSubAssign,opModAssign,
    opBitLeftAssign,opBitRightAssign,opBitRightZeroAssign,
    opBitAndAssign,opBitXorAssign,opBitOrAssign:
    begin
      Result := AssignValue(P^.Code,EvalExpr(l),EvalExpr(r));
      //ł̂4ނ̂
      case l^.Code of
        opVariable: FCurrentTable.SetValue(l^.Symbol,Result,FRegistVar);
        opMember: MemberAssign(EvalExpr(l^.Left),l^.Right^.Symbol,Result);
        opCallArray: CallArrayAssign(EvalExpr(l^.Left),l^.Right,Result);
        opMethod: MethodAssign(l,Result);
      else
        raise EJThrow.Create(E_TYPE,'can not assign - ' + l^.Symbol);
      end;
    end;

    //oĂяo L ... object  R ... variable
    opMember: Result := MemberExpr(EvalExpr(l),r^.Symbol,eefDelete in Flags);

    //z           L ... object|function  R ... arguments
    opCallArray: Result := CallArrayExpr(EvalExpr(l),r);

    //\bh L..object R..variable T..arg
    opMethod: Result := MethodExpr(P);

    opMinus,opPlus,opBitNot:
    begin
      Result := CalcValue1(P^.Code,EvalExpr(l));
    end;
    opPreInc:
    begin
      Result := EvalExpr(l);
      Result := BuildInteger(AsInteger(@Result) + 1);
      if l^.Code = opVariable then
        FCurrentTable.SetValue(l^.Symbol,Result,FRegistVar);
    end;
    opPreDec:
    begin
      Result := EvalExpr(l);
      Result := BuildInteger(AsInteger(@Result) - 1);
      if l^.Code = opVariable then
        FCurrentTable.SetValue(l^.Symbol,Result,FRegistVar);
    end;
    opPostInc:
    begin
      Result := EvalExpr(l);
      if l^.Code = opVariable then
        FCurrentTable.SetValue(l^.Symbol,BuildInteger(AsInteger(@Result) + 1),FRegistVar);
    end;
    opPostDec:
    begin
      Result := EvalExpr(l);
      if l^.Code = opVariable then
        FCurrentTable.SetValue(l^.Symbol,BuildInteger(AsInteger(@Result) - 1),FRegistVar);
    end;
    //Q
    opAdd,opSub,opMul,opDiv,opMod,opDivInt,opBitAnd,opBitOr,opBitXor,
    opBitLeft,opBitRight,opBitRightZero:
    begin
      Result := CalcValue2(P^.Code,EvalExpr(l),EvalExpr(r));
    end;

    //r
    opLS,opGT,opLSEQ,opGTEQ,opEQ,opNE,opEQEQEQ,opNEEQEQ,
    opLogicalOr2,opLogicalAnd2:
    begin
      Result := CompareValue(P^.Code,EvalExpr(l),EvalExpr(r));
    end;
    //V[gT[Lbg]
    opLogicalOr:
    begin
      v := EvalExpr(l);
      if AsBool(@v) then
        Result := BuildBool(True) //right͕]Ȃ
      else begin
        v := EvalExpr(r);
        Result := BuildBool(AsBool(@v));
      end;
    end;
    opLogicalAnd:
    begin
      v := EvalExpr(l);
      if not AsBool(@v) then
        Result := BuildBool(False) //right͕]Ȃ
      else begin
        v := EvalExpr(r);
        Result := BuildBool(AsBool(@v));
      end;
    end;
    opLogicalNot:
    begin
      Result := CompareValue(P^.Code,EvalExpr(l),v);
    end;
    //R
    opConditional:
    begin
      v := EvalExpr(l);
      if AsBool(@v) then //Е̂ݕ]
        Result := EvalExpr(r)
      else
        Result := EvalExpr(t);
      //Result := CalcValue3(opConditional,Evalexpr(l),EvalExpr(r),EvalExpr(t));
    end;
    //֐
    opFunction:
    begin
      //֐Zbg
      EmptyFunction(func);
      func.FuncType := ftStatement;
      func.vStatement := P^.Statement;
      //p[^Zbg
      func.Parameter := P^.Statement^.Sub1;
      //O
      if Assigned(P^.Statement^.Expr) then
        func.Symbol := P^.Statement^.Expr^.Symbol;

      //V{e[u쐬
      //e֐p
      func.FunctionTable :=
        FRootTable.GetFunctionTable(P^.Statement^.Temp,P^.Statement);
      {//localtable쐬
      if not Assigned(func.LocalTable) then
        func.LocalTable := TJLocalSymbolTable.Create(nil);
      //Jgϐcopy
      func.LocalTable.LocalCopy(FCurrentTable);
      }
      Result := BuildFunction(func);
    end;

    //object쐬
    opNew:      //L..Object R..
    begin
      name := l^.Symbol;
      param := ArgumentsToList(r);
      try
        //object쐬
        Result := BuildObject(MakeObject(name,param));
      finally
        param.Free;
      end;

      //tempɓ
      //FCurrentTable.AddTemporaryObject(Result.vObject);
    end;
    //Object쐬
    opNewObject:
    begin
      Result := BuildObject(TJObject.Create(Self));
      ObjectExpr(Result.vObject,l);
      //tempɓ
      FCurrentTable.AddTemporaryObject(Result.vObject);
    end;
    //z쐬
    opNewArray:
    begin
      param := ArgumentsToList(l);
      try
        //lZbg
        Result.ValueType := vtObject;
        if IsParam1(param) and (param.Count = 1) then //ЂƂ̂ƂɗvfƂĈ
        begin
          Result.vObject := TJArrayObject.Create(Self);
          (Result.vObject as TJArrayObject).Add(param[0]);
        end
        else
          Result.vObject := TJArrayObject.Create(Self,param);
      finally
        param.Free;
      end;

      //tempɓ
      FCurrentTable.AddTemporaryObject(Result.vObject);
    end;
    //݂̃JgobjectԂ
    opThis:
    begin
      Result := BuildObject(FCurrentTable.This);
    end;
    opSuper:
    begin
      raise EJThrow.Create(E_SYNTAX,'super');
      //Result := MemberExpr(P,FTables.This);
      //Result.ValueType := vtObject;
      //Result.vObject := FTable.This;
    end;
    opDelete:
    begin
      //폜
      Result := EvalExpr(l,[eefDelete]);
    end;
    opVoid:
    begin
      Result := Evalexpr(l);
      Result := BuildNull;
    end;
    opTypeOf:
    begin
      try
        v := EvalExpr(l);
      except
        on E:EJThrow do
        begin
          //undefine
          if (E.ExceptName = E_NAME) or (E.ExceptName = E_KEY) then
            EmptyValue(v)
          else //Đ
            raise;
        end;
      end;
      Result := BuildString(TypeOf(@v));
    end;
    else begin
      EvalExpr(l);
      EvalExpr(r);
    end;
  end;

end;

function TJEngine.CallFunction(Root: PJStatement; Symbol: String;
  Param: TJValueList; var RetValue: TJValue): Boolean;
//O̊֐Ăяo
var
  v: TJValue;
  old,table: TJLocalSymbolTable;
begin
  Result := False;
  EmptyValue(RetValue);
  //s̏ꍇI
  if IsRunning then
    Exit;
  //s
  FIsRunning := True;

  try
    FAbort := False;
    //rootΎs
    if Assigned(Root) then
      Run(Root,nil)
    //sς݂łȂꍇ
    else if not FIsRan then
      Exit;

    //֐s
    table := FRootTable.FindGlobalTable(__MAIN__);
    if table.GetValue(Symbol,v) and
       IsFunction(@v) then
    begin
      old := FCurrentTable;
      FCurrentTable := table;
      BeforeRun;
      try try
        RetValue := CallExpr(v.vFunction,Param);
        Result := True;
      except
        on E:EJThrow do
          PrintlnError('Exception: ' +
            E.ExceptName + '(' + IntToStr(FLineNo) + ') => ' + E.Message);
        on E:EJAbort do
          PrintlnError('Abort Script(' + IntToStr(FLineNo) + ')');
        on E:EJSyntaxError do
          PrintlnError('SyntaxError: ' +
            'Line(' + IntToStr(FLineNo) + ') => ' + E.Message);
      end;

      finally
        AfterRun;
        FCurrentTable := old;
      end;
    end;
  finally
    FIsRunning := False;
  end;
end;

function TJEngine.CallExpr(Func: IJFunction; Param: TJValueList;
  This: TJObject): TJValue;
//֐Ăяo
var
  paramdecl: PJStatement;
  i,index: Integer;
  args: TJArrayObject;
  table,oldtable: TJLocalSymbolTable;
  v: TJValue;
{$IFNDEF NO_ACTIVEX}
  oleret: OleVariant;
  dispparams: TDispParams;
  arglist: PVariantArgList;
  diput: TDispId;
{$ENDIF}
{$IFNDEF NO_DYNACALL}
  dynavalues: TDynaValueArray;
{$ENDIF}
begin
  EmptyValue(Result);
{$IFNDEF NO_DYNACALL}
  dynavalues := nil;
{$ENDIF}

  try
    case Func.FuncType of
      //\
      ftStatement:
      begin
        //Param̒l͍폜肵Ȃ

        //method owner`FbN
        if Assigned(Func.MethodOwner) then
          This := Func.MethodOwner;

        //e[u쐬
        table := Func.FunctionTable.PushLocalTable(Func.LocalTable,This);
        oldtable := FCurrentTable;
        FCurrentTable := table;
        try
          //flagfcfCall fcfApply̏ꍇParam[0]thisɂȂ
          if (Func.Flag = fcfCall) and IsParam1(Param) then
          begin
            //arguments쐬
            args := TJArrayObject.Create(Self);

            table.This := GetThisFromValue(Param[0]);

            for i := 1 to Param.Count - 1 do
              args.Add(Param[i]);
          end
          //apply̏ꍇParam[0]this Param[1]arguments
          else if (Func.Flag = fcfApply) and IsParam1(Param) then
          begin
            table.This := GetThisFromValue(Param[0]);

            if IsParam2(Param) then
            begin
              v := Param[1];
              if IsObject(@v) and (v.vObject is TJArrayObject) then
              begin
                //Paramւ
                args := v.vObject as TJArrayObject;
              end
              else
                raise EJThrow.Create(E_TYPE,Func.Symbol + '.apply arguments error');
            end
            else //arguments쐬
              args := TJArrayObject.Create(Self);
          end
          else begin
            //ʏ
            //arguments쐬
            args := TJArrayObject.Create(Self);

            if IsParam1(Param) then
              for i := 0 to Param.Count - 1 do
                args.Add(Param[i]);
          end;

          //argumentscallee
          EmptyValue(v);
          v.ValueType := vtFunction;
          v.vFunction := Func;
          //zarraystyle=falseœo^ȂƃG[
          args.SetValue('callee',v,False);
          //argumentso^
          table.RegistValue('arguments',BuildObject(args));
          //p[^o^
          i := 0;
          paramdecl := Func.Parameter;
          while Assigned(paramdecl) do
          begin
            EmptyValue(v);
            //v := BuildNull;
            //ԂɃ[Jϐɓo^
            if Assigned(paramdecl^.Expr) then
            begin
              if i < args.Count then
                table.RegistValue(paramdecl^.Expr^.Symbol,args.GetItem(i))
              else //undifinedo^
                table.RegistValue(paramdecl^.Expr^.Symbol,v);
            end;

            paramdecl := paramdecl^.Next;
            Inc(i);
          end;

          try
            EvalStatement(Func.vStatement^.Sub2,[]);
          except
            on E:EJReturn do
              Result := E.Value;
          end;
        finally
          //e[u폜
          Func.FunctionTable.PopLocalTable;
          //ɖ߂
          FCurrentTable := oldtable;
        end;
      end;
      //Delphi\bh
      ftMethod: Result := Func.vMethod(Param);

  {$IFNDEF NO_ACTIVEX}
      //ActiveX\bh
      ftActiveX:
      begin
        //VarClear(oleret); VarClear̓oOĂ
        VariantInit(oleret);
        //p[^쐬
        if IsParam1(Param) then
        begin
          GetMem(arglist,SizeOf(TVariantArg) * Param.Count);
          //tɂ
          index := 0;
          for i := Param.Count - 1 downto 0 do
          begin
            //tagVariantOleVariant͓
            arglist^[index] := TVariantArg(ValueToVariant(Param[i]));
            Inc(Index);
          end;
          dispparams.rgvarg := arglist;
          dispparams.cArgs := Param.Count;
          dispparams.rgdispidNamedArgs := nil;
          dispparams.cNamedArgs := 0;
        end
        else begin
          arglist := nil;
          dispparams.rgvarg := nil;
          dispparams.cArgs := 0;
          dispparams.rgdispidNamedArgs := nil;
          dispparams.cNamedArgs := 0;
        end;

        try
          //property put̏ꍇ
          if Func.vActiveX.Flag = axfPut then
          begin
            diput := DISPID_PROPERTYPUT;
            dispparams.rgdispidNamedArgs := @diput;
            dispparams.cNamedArgs := 1;
          end;

          //Ăяo
          try
            //\bhĂяõoOVarClearVariantInitɑウƒ
            OleCheck(Func.vActiveX.Parent.Invoke(
              Func.vActiveX.Dispid,
              GUID_NULL,
              GetUserDefaultLCID,
              AXMethodFlagToDisp(Func.vActiveX.Flag),
              dispparams,
              @oleret,nil,nil));

            Result := VariantToValue(oleret,Self);
          except
            //O
            raise EJThrow.Create(E_ACTIVEX,
              AXMethodFlagToString(Func.vActiveX.Flag) + ' error: ' + Func.Symbol);
          end;
        finally
          if Assigned(arglist) then
            FreeMem(arglist);
        end;
      end;
    {$ENDIF}

    {$IFNDEF NO_DYNACALL}
      //DLL֐̌Ăяo
      ftDynaCall:
      begin
        //SynaValueXg쐬
        dynavalues := ValueListToDynaValueArray(Func.vDynaCall.Arguments,Param);
        //Ăяo
        Result :=
          DynaResultToValue(
            Func.vDynaCall.ReturnValue,
            DynaCall(
              MakeCallFlags(Func.vDynaCall.Call),
              Func.vDynaCall.Procaddr,
              DynaValueArrayToDynaParmArray(dynavalues),
              nil,
              0
            )
          );
      end;
    {$ENDIF}
    else
      raise EJThrow.Create(E_CALL,'not support function type');
    end;
  finally
    //result objecttempɓo^
    if IsObject(@Result) then
      FCurrentTable.AddTemporaryObject(
        Result.vObject,
        //ftStatement͎̎QƃJEgωȂ̂false
        Func.FuncType <> ftStatement);
  end;
end;

function TJEngine.MemberExpr(Parent: TJValue; Member: String; Deleting: Boolean): TJValue;
//o
var
  ax,vcl: Boolean;
  obj: TJObject;
begin
  EmptyValue(Result);
  ax := False;
  vcl := False;

  if IsObject(@parent) then
  begin
{$IFNDEF NO_ACTIVEX}
    //activexłmember exprŐVKobjectAĂ
    if (parent.vObject is TJActiveXObject) then
      ax := True
    else
{$ENDIF}
    //vclłmember exprŐVKobjectAĂ
    if (parent.vObject is TJVCLPersistent) then
      vcl := True;

    //property폜
    if Deleting then
      Result := BuildBool(parent.vObject.RemoveKey(Member))
    //prototype
    else if Member = 'prototype' then
      Result := BuildObject(FFactory.GetPrototype(parent.vObject.Name))
    else
      Result := parent.vObject.GetValue(Member,False);
  end
  else if IsString(@parent) then //̃vpeB
  begin
    obj := MakeObject('String',nil);
    (obj as TJStringObject).text := AsString(@parent);
    Result := obj.GetValue(Member,False);

{ TODO : ꕶ炵 }
// "$$" $ Ƃ̂
// "$&" Ovł
// "$`" OvO̕ł
// "$'" Ov̕ł
// "$n" OvnԖ(1-9,01-99)̕ł
  end
  else if IsRegExp(@parent) then //K\
  begin
    obj := MakeObject('RegExp',nil);
    (obj as TJRegExpObject).SetRegExpValue(parent);
    Result := obj.GetValue(Member,False);
  end
  else if TryAsNumber(@parent) then //
  begin
    obj := MakeObject('Number',nil);
    (obj as TJNumberObject).FValue := parent;
    Result := obj.GetValue(Member,False);
  end
  else if IsConstructor(@parent) then //֐
  begin
    //prototype
    if Member = 'prototype' then
      Result := BuildObject(FFactory.GetPrototype(parent.vFunction.Symbol))
    else if Member = 'call' then
    begin
      //Rs[
      Result := parent;
      //call flagZbg
      Result.vFunction.Flag := fcfCall;
    end
    else if Member = 'apply' then
    begin
      //Rs[
      Result := parent;
      //call flagZbg
      Result.vFunction.Flag := fcfApply;
    end
    else //G[
      raise EJThrow.Create(E_NAME,'member error ' + Member);
  end
  else if IsBool(@parent) then //bool
  begin
    obj := MakeObject('Boolean',nil);
    (obj as TJBooleanObject).FBool := AsBool(@parent);
    Result := obj.GetValue(Member,False);
  end
{$IFNDEF NO_ACTIVEX}
  else if IsDispatch(@parent) then
  begin
    ax := True;
    obj := MakeObject('ActiveXObject',nil);
    (obj as TJActiveXObject).disp := AsDispatch(@parent);
    Result := obj.GetValue(Member,False);
  end
{$ENDIF}
  else if IsNameSpace(@parent) then
  begin
    //OԂ
    FRootTable.FindGlobalTable(parent.vFunction.Symbol).GetValue(Member,Result);
  end
  else
    raise EJThrow.Create(E_NAME,'member error ' + Member);
{$IFNDEF NO_ACTIVEX}
  //activexObject̏ꍇtempɓo^
  if ax and IsObject(@Result) and (Result.vObject is TJActiveXObject) then
    FCurrentTable.AddTemporaryObject(Result.vObject)
  else
{$ENDIF}
  if vcl and IsVCLObject(@Result) then
    FCurrentTable.AddTemporaryObject(Result.vObject);
end;

procedure TJEngine.MemberAssign(Parent: TJValue; Member: String; Value: TJValue);
//o֑
//member ... object.variable
begin
  if IsObject(@parent) then
  begin
    //protoype
    if (Member = 'prototype') and (IsObject(@Value) or IsNull(@Value)) then
    begin
      //object
      if not FFactory.SetPrototype(parent.vObject.Name,Value.vObject) then
        raise EJThrow.Create(E_NAME,'prototype assign error ' + Value.vObject.Name);
    end
    else
      parent.vObject.SetValue(Member,Value,False);
  end
  //֐ prototype
  else if IsConstructor(@parent) and (Member = 'prototype') and
          (IsObject(@Value) or IsNull(@Value)) then
  begin
    //object
    if not FFactory.SetPrototype(parent.vFunction.Symbol,Value.vObject) then
      raise EJThrow.Create(E_NAME,'prototype assign error ' + Value.vObject.Name);
  end
  //O
  else if IsNameSpace(@parent) then
    FRootTable.FindGlobalTable(parent.vFunction.Symbol).SetValue(Member,Value,FRegistVar)
  else
    raise EJThrow.Create(E_NAME,'member assign error ' + Member);
end;

procedure TJEngine.Clear;
//e[uNA
begin
  FAllowEvent := False;
  FIsRan := False;
  ClearGlobalObjects;
  FRootTable.Clear;
  FFactory.Clear;
  FLineNo := E_UNKNOWN_LINE_NO;
end;

procedure TJEngine.Abort;
begin
  FAbort := True;
  FAllowEvent := False;
end;

procedure TJEngine.FactoryOnNewObject(Sender: TObject;
  JObject: TJObject);
var
  re: TJRegExpObject;
begin
  if JObject is TJRegExpObject then
  begin
    //K\ɍ׍H
    re := TJRegExpObject(JObject);
    re.OnMatchStart := RegExpOnMatchStart;
    re.OnMatchEnd := RegExpOnMatchEnd;
    re.OnExecInput := RegExpOnExecInput;
  end;

{$IFNDEF NO_SOCKET}
  //socket֌Wɍ׍H
  if JObject is TJBaseSocketObject then
  begin
    TJBaseSocketObject(JObject).OnPrint := FGlobalObject.Println;
  end;
{$ENDIF}

  if Assigned(FOnNewObject) then
    FOnNewObject(Self,JObject);
end;

procedure TJEngine.ObjectExpr(Obj: TJObject; Elements: PJExpr);
//L(ϐ)
//R(l)
var
  current: PJExpr;
  s: String;
begin
  current := Elements;
  while Assigned(current) do
  begin
    //quoteString
    if IsString(current^.Right^.Left^.Value) then
      s := current^.Right^.Left^.Value^.vString
    else if TryAsNumber(current^.Right^.Left^.Value) then
      s := AsString(current^.Right^.Left^.Value)
    else //variable
      s := current^.Right^.Left^.Symbol;

    Obj.SetValue(s,EvalExpr(current^.Right^.Right),True);
    current := current^.Left;
  end;
end;

procedure TJEngine.MakeInstance(Obj: TJObject; Members: PJStatement);
//objectɃoZbg
var
  current: PJStatement;
  func: IJFunction;
  v: TJValue;
  exp: PJExpr;
begin
  //Oo^
  Obj.RegistName(Members^.Expr^.Symbol);
  current := Members^.Sub1;
  while Assigned(current) do
  begin
    case current^.SType of
      stFunctionDecl:
      begin
        //֐Zbg ϐ݂Ȃꍇ
        if Assigned(current^.Expr) then
        begin
          EmptyFunction(func);
          func.Symbol := current^.Expr^.Symbol;
          func.FuncType := ftStatement;
          func.vStatement := current;
          //p[^Zbg
          func.Parameter := current^.Sub1;
          //V{e[u쐬
          //e֐p
          func.FunctionTable :=
            FRootTable.GetFunctionTable(current^.Temp,current);
          func.MethodOwner := Obj;
          //oɓo^
          Obj.RegistProperty(current^.Expr^.Symbol,BuildFunction(func));
        end
      end;
      //varƕϐ錾
      stVar,stVariableDecl:
      begin
        exp := nil;
        case current^.SType of
          stVar: exp := current^.Sub1^.Expr;
          stVariableDecl: exp := current^.Expr;
        end;

        if Assigned(exp) then
        begin
          if Assigned(exp^.Left) then
            v := EvalExpr(exp^.Left)
          else
            v := BuildNull;

          Obj.RegistProperty(exp^.Symbol,v);
        end;
      end;
    end;
    current := current^.Next;
  end;
end;

function TJEngine.MakeObject(Name: String; Param: TJValueList): TJObject;
{ TODO : ւ񌩒 }
var
  v,con: TJValue;
  objclass: PJObjectClass;
begin
  //[U`邩H
  if FCurrentTable.GetValue(Name,v) and
    (IsConstructor(@v) or IsClass(@v)) then
  begin
    case v.vFunction.FuncType of
      //NX
      ftClass:
      begin
        //super objectꍇobject
        if not Assigned(v.vFunction.vStatement^.Expr^.Left) then
          Result := TJObject.Create(Self,Param)
        else //֍ċA
          Result := MakeObject(v.vFunction.vStatement^.Expr^.Left^.Symbol,Param);

        //o쐬
        MakeInstance(Result,v.vFunction.vStatement);
        //RXgN^Ă
        if Result.HasKey(Name) then
        begin
          con := Result.GetValue(Name,False);
          if IsConstructor(@con) then
          begin
            //tempɓ
            FCurrentTable.AddTemporaryObject(Result);
            CallExpr(con.vFunction,Param,Result);
          end;
        end;

      end;
      //֐
      ftStatement:
      begin
        //object쐬
        Result := TJObject.Create(Self);
        //Oo^
        Result.RegistName(Name);
        //constructor
        Result.RegistProperty('constructor',v);

        //tempɓ
        FCurrentTable.AddTemporaryObject(Result);
        //constructorĂ
        CallExpr(v.vFunction,Param,Result);
      end
    else
      //͎ۂɂ͎sȂ
      raise EJThrow.Create(E_NAME,'create object constructor error ' + Name);
    end;
  end
  //g݃IuWFNgΕԂ
  else if FFactory.HasObject(Name) then
  begin
    objclass := FFactory.GetObject(Name);
    Result := objclass^.Create(Self,Param);
    //tempɓ
    FCurrentTable.AddTemporaryObject(Result);
  end
  else //object̂ŗO
    raise EJThrow.Create(E_NAME,'create object error ' + Name);
end;

procedure TJEngine.ImportObject(ObjectName: String;
  ObjectClass: TJObjectClass);
begin
  FFactory.ImportObject(ObjectName,ObjectClass);
end;

procedure TJEngine.RegExpOnMatchStart(Sender: TObject);
//}b`Jn O[oXV
begin
  FRegExpObject.ClearMatch;
end;

procedure TJEngine.RegExpOnMatchEnd(Sender: TObject);
//}b`I O[oXV
begin
  FRegExpObject.Assign(Sender as TJRegExpObject);
end;

procedure TJEngine.GlobalObjectOnPrint(Sender: TObject; S: String);
begin
  if Assigned(FOnStdout) then
    FOnStdout(Self,S);
end;

procedure TJEngine.RegistGlobalObjects(ASymbolTable: TJLocalSymbolTable);
//globalIuWFNgo^
var
  names: TStringList;
  i: Integer;
  objclass: PJObjectClass;
begin
  //ׂĂo^
  names := FFactory.ObjectNameList;
  for i := 0 to names.Count - 1 do
  begin
    objclass := FFactory.GetObject(names[i]);
    if objclass^.IsMakeGlobalInstance then
    begin
{ TODO : except }
      try
        ASymbolTable.RegistGlobalValue(names[i],BuildObject(objclass^.Create(Self)));
      except
        on EJThrow do
      end;
    end;
  end;
  //dv㏑
  ASymbolTable.RegistGlobalValue('Global',BuildObject(FGlobalObject));
  ASymbolTable.RegistGlobalValue('RegExp',BuildObject(FRegExpObject));
{$IFNDEF NO_WSH}
  ASymbolTable.RegistGlobalValue('WScript',BuildObject(FWScriptObject));
{$ENDIF}
end;

procedure TJEngine.PrintlnError(S: String);
//stderr
begin
  GlobalObjectOnPrintError(Self,S + CRLF);
  //event
  if Assigned(FOnError) then
    FOnError(Self,FLineNo,S);
end;

procedure TJEngine.GlobalObjectOnPrintError(Sender: TObject; S: String);
begin
  if Assigned(FOnStderr) then
    FOnStderr(Self,S);
end;

function TJEngine.IsRunning: Boolean;
//sǂ
begin
  Result := FIsRunning;
end;

function TJEngine.DoEvents: Boolean;
//ҋ@
var
  tid,aid: DWORD;
  abrt: Boolean;
begin
  Result := IsRunning and FAllowEvent;
  //s̏ꍇ
  if Result then
  begin
    abrt := False;
    //~`FbN
    if Assigned(FOnDoEvents) then
      FOnDoEvents(Self,abrt);
    //~
    if abrt then
    begin
      Result := False;
      Exit;
    end;
{$IFNDEF CONSOLE}
    //sXbh`FbN
    tid := GetCurrentThreadId;
    aid := GetWindowThreadProcessId(Application.Handle,nil);
    //C̏ꍇ̓bZ[W
    if aid = tid then
    begin
      Result := not Application.Terminated;
      if Result then
        Application.ProcessMessages;
    end;
{$ENDIF}
    //ҋ@
    Sleep(10);
  end;
end;

procedure TJEngine.CallArrayAssign(Parent: TJValue;
  Arguments: PJExpr; Value: TJValue);
//z or ֐Call֑
// parent(arguments)
// parent[arguments]
var
  s: TJValue;
  param: TJValueList;
begin
  //objectꍇ z
  if IsObject(@parent) then
  begin
    //Ō̈𓾂
    s := ArgumentsToValue(Arguments);
    //1傫ƂparamZbg
    if ArgumentsCount(Arguments) > 1 then
    begin
      //Zbg
      param := ArgumentsToList(Arguments);
      try
        //param̍Ōv͓
        parent.vObject.SetValue(AsString(@s),Value,True,param);
      finally
        param.Free;
      end;
    end
    else //
      parent.vObject.SetValue(AsString(@s),Value,True);
  end
  //֐̏ꍇ
  else if IsFunction(@parent) then
  begin
    //Zbg
    param := ArgumentsToList(Arguments);
    if not Assigned(param) then
      param := TJValueList.Create;
    try
      //l
      param.Add(Value);
      //activex̏ꍇflagZbg
      if parent.vFunction.FuncType = ftActiveX then
        parent.vFunction.vActiveX.Flag := axfPut;
      //֐Ă
      CallExpr(parent.vFunction,param);
    finally
      param.Free;
    end;
  end
  else
    raise EJThrow.Create(E_CALL,'call function error,need function or object');
end;

function TJEngine.CallArrayExpr(Parent: TJValue; Arguments: PJExpr): TJValue;
//z or ֐Call
// parent(arguments)
// parent[arguments]
var
  s: TJValue;
  param: TJValueList;
  obj: TJObject;
begin
  EmptyValue(Result);
  //֐̏ꍇ
  if IsFunction(@parent) then
  begin
    //Zbg
    param := ArgumentsToList(Arguments);
    try
      //activex̏ꍇflagZbg
      if parent.vFunction.FuncType = ftActiveX then
        parent.vFunction.vActiveX.Flag := axfGet;
      //֐Ă thisp
      Result := CallExpr(parent.vFunction,param,FCurrentTable.This);
    finally
      param.Free;
    end;
  end
  //object̏ꍇ z
  else if IsObject(@parent) or IsString(@parent) then
  begin
    if IsObject(@parent) then
      obj := parent.vObject
    else begin
      obj := MakeObject('String',nil);
      (obj as TJStringObject).text := AsString(@parent);
    end;
    //Ō̈𓾂
    s := ArgumentsToValue(Arguments);
    //1傫ƂparamZbg
    if ArgumentsCount(Arguments) > 1 then
    begin
      //Zbg
      param := ArgumentsToList(Arguments);
      try
        //param̍Ōv͓
        Result := obj.GetValue(AsString(@s),True,param);
      finally
        param.Free;
      end;
    end
    else //
      Result := obj.GetValue(AsString(@s),True);
  end
  else
    raise EJThrow.Create(E_CALL,'call function error,need function or object');
end;

procedure TJEngine.GlobalObjectOnRead(Sender: TObject; var S: String; var Success: Boolean;
  Count: Integer; Line: Boolean);
begin
  if Assigned(FOnStdin) then
    FOnStdin(Self,S,Success,Count,Line);
end;

function TJEngine.GetObjectCount: Integer;
begin
  Result := FFactory.ObjectCount;
end;

procedure TJEngine.AfterRun;
//s
begin
  if Assigned(FOnDone) then
    FOnDone(Self);
end;

procedure TJEngine.BeforeRun(Main: Boolean);
//sO
begin
{$IFNDEF NO_WSH}
  //WScripẗ
  if Main then
    FWScriptObject.Arguments.Parse(FGlobalObject.arguments);
{$ENDIF}
  if Assigned(FOnRun) then
    FOnRun(Self);
end;

procedure TJEngine.MethodAssign(P: PJExpr;
  Value: TJValue);
//\bh
//L ... ParentObject
//R ... Member
//T ... Arguments
var
  l,r,t: PJExpr;
  parent,member: TJValue;
  param: TJValueList;
begin
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  t := P^.Third;

  //eobject
  parent := EvalExpr(l);
  //member𓾂
  member := MemberExpr(parent,r^.Symbol);
  //֐call
  if IsFunction(@member) then
  begin
    //Zbg
    param := ArgumentsToList(t);
    if not Assigned(param) then
      param := TJValueList.Create;
    try
      //ɑlŌɉ
      param.Add(Value);
      //activex̏ꍇflagZbg
      if member.vFunction.FuncType = ftActiveX then
        member.vFunction.vActiveX.Flag := axfPut;
      //֐Ă
      CallExpr(member.vFunction,param,GetThisFromValue(parent));
    finally
      param.Free;
    end;
  end
  else if IsObject(@member) then
  begin
    //Object̏ꍇ͔z
    CallArrayAssign(member,t,Value);
  end
  else
    raise EJThrow.Create(E_CALL,'call function error,need function or object');
end;

function TJEngine.MethodExpr(P: PJExpr): TJValue;
//\bh
//postfix_expression DOT[.] variable LSQ[\[] (arguments|null) RSQ[\]]
//postfix_expression DOT[.] variable LP[(] (arguments|null) RP[)]
//L ... ParentObject
//R ... Member
//T ... Arguments
var
  l,r,t: PJExpr;
  parent,member: TJValue;
  param: TJValueList;
begin
  EmptyValue(Result);
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  t := P^.Third;

  //eobject
  parent := EvalExpr(l);
  //member𓾂
  member := MemberExpr(parent,r^.Symbol);
  //֐call
  if IsFunction(@member) then
  begin
    //Zbg
    param := ArgumentsToList(t);
    try
      //activex̏ꍇflagZbg
      if member.vFunction.FuncType = ftActiveX then
        member.vFunction.vActiveX.Flag := axfGet;
      //֐Ă
      Result := CallExpr(member.vFunction,param,GetThisFromValue(parent));
    finally
      param.Free;
    end;
  end
  else if IsObject(@member) then
  begin
    //Object̏ꍇ͔z
    Result := CallArrayExpr(member,t);
  end
  else
    raise EJThrow.Create(E_CALL,'call function error,need function or object');
end;

function TJEngine.ArgumentsCount(Arg: PJExpr): Integer;
//arg̐𓾂
var
  current: PJExpr;
begin
  Result := 0;
  current := Arg;
  while Assigned(current) do
  begin
    Inc(Result);
    current := current^.Left;
  end;
end;

function TJEngine.ArgumentsToList(Arg: PJExpr): TJValueList;
//ListĊ֐p[^Zbg
var
  current: PJExpr;
  v: TJValue;
begin
  if not Assigned(Arg) then
  begin
    Result := nil;
    Exit;
  end;

  Result := TJValueList.Create;
  try
    current := Arg;
    while Assigned(current) do
    begin
      v := EvalExpr(current^.Right);
      Result.Insert(0,v);
      current := current^.Left;
    end;
  except
    //ÔƂ͊J
    FreeAndNil(Result);
    raise;
  end;
end;

function TJEngine.ArgumentsToValue(Arg: PJExpr): TJValue;
//Ō̈𓾂
begin
  //RightōŌ̒l𓾂邱Ƃł
  if Assigned(Arg) then
    Result := EvalExpr(Arg^.Right)
  else
    Result := BuildString('');
end;

function TJEngine.GetThisFromValue(Value: TJValue): TJObject;
//this𓾂
begin
  if IsObject(@Value) then
    Result := Value.vObject
  else if IsString(@Value) then  //
  begin
    Result := MakeObject('String',nil);
    (Result as TJStringObject).Text := AsString(@Value);
  end
  else if IsRegExp(@Value) then //K\
  begin
    Result := MakeObject('RegExp',nil);
    (Result as TJRegExpObject).SetRegExpValue(Value);
  end
  else if TryAsNumber(@Value) then //
  begin
    Result := MakeObject('Number',nil);
    (Result as TJNumberObject).FValue := Value;
  end
  else if IsBool(@Value) then //bool
  begin
    Result := MakeObject('Boolean',nil);
    (Result as TJBooleanObject).FBool := AsBool(@Value);
  end
{$IFNDEF NO_ACTIVEX}
  else if IsDispatch(@Value) then
  begin
    Result := MakeObject('ActiveXObject',nil);
    (Result as TJActiveXObject).disp := AsDispatch(@Value);
  end
{$ENDIF}
  else
    Result := nil;
    //Result := FCurrentTable.This;
end;

function TJEngine.GetVariable(Symbol: String;
  var RetVal: TJValue): Boolean;
//O[oϐ𓾂
begin
  Result := FCurrentTable.GetValue(Symbol,RetVal);
end;

function TJEngine.CallEvent(var Event: TJValue; Param: TJValueList;
  This: TJObject): TJValue;
begin
  try
    //֐̏ꍇ
    if IsFunction(@Event) then
      Result := CallExpr(Event.vFunction,Param,This)
    //̏ꍇeval
    else if IsString(@Event) then
      Result := Eval(AsString(@Event),This)
    else
      EmptyValue(Result);
  except
    on E:EJException do
    begin
      //s̏ꍇ͍Đ
      if not FIsRan then
        raise
      else begin
        if E is EJThrow then
          PrintlnError('Exception: ' +
            E.ExceptName + '(' + IntToStr(FLineNo) + ') => ' + E.Message)
        else if E is EJAbort then
          PrintlnError('Abort Script(' + IntToStr(FLineNo) + ')')
        else if E is EJSyntaxError then
          PrintlnError('SyntaxError: ' +
            'Line(' + IntToStr(FLineNo) + ') => ' + E.Message);
      end;
    end;
  end;
end;

function TJEngine.Run: Integer;
begin
  Result := Run(FParser.Root,nil);
end;

function TJEngine.CallFunction(Symbol: String; Param: TJValueList;
  var RetValue: TJValue): Boolean;
begin
  Result := CallFunction(FParser.Root,Symbol,Param,RetValue);
end;

function TJEngine.Compile(SourceCode: String): Boolean;
//͖؂
begin
  Result := False;
  //s̏ꍇI
  if IsRunning then
    Exit;

  FParser.SourceCode := SourceCode;
  //exe pathǉ
  FParser.LibPath.Add(ExtractFilePath(ParamStr(0)));
  FParser.LibPath.Add(GetCurrentDir);
  try try
    Result := FParser.Parse;
  except
    on E:EJSyntaxError do
    begin
      FLineNo := E.LineNo;
      //event
      PrintlnError('SyntaxError: ' +
          'Line(' + IntToStr(FLineNo) + ') => ' + E.Message);
    end;
    on E:EJThrow do
      PrintlnError('Exception: ' + E.ExceptName + ' => ' + E.Message);
  end;
  finally
    //libpath폜
    FParser.LibPath.Delete(FParser.LibPath.Count - 1);
    FParser.LibPath.Delete(FParser.LibPath.Count - 1);
  end;
end;

function TJEngine.CompileFile(AFilename: String; UseBinary: Boolean): Boolean;
//t@Cw肵Ďs(lib pathǉ)

  function GetTempDmc(dmc: String): String;
  var
    path: array[0..MAX_PATH] of Char;
  begin
    GetTempPath(MAX_PATH,path);
    Result := String(path) + ExtractFilename(dmc);
  end;

var
  sl: TStringList;
  dmc,tmpdmc: String;
  ok: Boolean;
begin
  Result := False;
  //s̏ꍇI
  if IsRunning then
    Exit;

  FFilename := AFilename;
  if not FileExists(AFilename) then
    Exit;

  //RpCς݃oCi[h
  dmc := ChangeFileExt(AFilename,DMS_COMPILED_EXT);
  if UseBinary then
  begin
    //trĐV
    if FileExists(dmc) and (FileAge(dmc) >= FileAge(AFilename)) then
      Result := FParser.Deserialize(dmc);
    //ǂݍ݂Ɏse|ǂ
    if not Result then
    begin
      tmpdmc := GetTempDmc(dmc);
      if FileExists(tmpdmc) and (FileAge(tmpdmc) >= FileAge(AFilename)) then
        Result := FParser.Deserialize(tmpdmc);
    end;
  end;

  if not Result then
  begin
    //lib pathǉ
    FParser.LibPath.Add(ExtractFilePath(AFilename));
    sl := TStringList.Create;
    try
      sl.LoadFromFile(AFilename);
      Result := Compile(sl.Text);
      //Ȃ΃VACY
      if Result and UseBinary then
      begin
        ok := FParser.Serialize(dmc);
        //t@C쐬Ɏse|ɍ
        if not ok then
        begin
          tmpdmc := GetTempDmc(dmc);
          FParser.Serialize(tmpdmc);
        end;
       end;
    finally
      sl.Free;
      //libpath폜
      FParser.LibPath.Delete(FParser.LibPath.Count - 1);
    end;
  end;
end;

function TJEngine.GetOnDebugout: TStringEvent;
//Cxg
begin
  Result := FParser.Lex.OnDebug
end;

procedure TJEngine.SetOnDebugout(const Value: TStringEvent);
begin
  FParser.Lex.OnDebug := Value;
end;

procedure TJEngine.ClearGlobalObjects;
begin
  FGlobalObject.Clear;
  FRegExpObject.Clear;
{$IFNDEF NO_WSH}
  FWScriptObject.Clear;
{$ENDIF}
end;

function TJEngine.Eval(SourceCode: String; This: TJObject): TJValue;
//eval()
//֐ɕϊĎs
//function(){return evalR[h;}
var
  v: TJValue;
  expr: PJExpr;
  line: Integer;
  //parser: TJParser;
begin
  EmptyValue(Result);
  //sԍۑ
  line := FLineNo;
  try
    //parser := TJParser.Create;
    //FParser.Packages.Add(parser);
    //֐𓾂
    expr := FParser.ParseEval(SourceCode);
    if Assigned(expr) then
    begin
      //֐]
      v := EvalExpr(expr);
      if IsFunction(@v) then
      begin
        //currenteɐݒ
        v.vFunction.FunctionTable.Parent := CurrentTable.GetNodeTable;
        //s
        Result := CallExpr(v.vFunction,nil,This);
      end;
    end;
  finally
    FLineNo := line;
  end;
end;

procedure TJEngine.RegExpOnExecInput(Sender: TObject; var Input: String);
begin
  Input := FRegExpObject.input;
end;

function TJEngine.GetScriptFilename: String;
begin
  Result := FFilename;
end;

function TJEngine.FindImportFilename(Filename: String;
  var FindedFilename: String): Boolean;
begin
  Result := FParser.FindImportFilename(Filename,FindedFilename);
end;

end.

