class MsdefnoController < ApplicationController
  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @ms_def_no_pages, @ms_def_nos = paginate :ms_def_nos, :per_page => 10
  end

  def show
    @ms_def_no = MsDefNo.find(params[:id])
  end

  def new
    @ms_def_no = MsDefNo.new
  end

  def create
    @ms_def_no = MsDefNo.new(params[:ms_def_no])
    if @ms_def_no.save
      flash[:notice] = 'MsDefNo was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @ms_def_no = MsDefNo.find(params[:id])
  end

  def update
    @ms_def_no = MsDefNo.find(params[:id])
    if @ms_def_no.update_attributes(params[:ms_def_no])
      flash[:notice] = 'MsDefNo was successfully updated.'
      redirect_to :action => 'show', :id => @ms_def_no
    else
      render :action => 'edit'
    end
  end

  def destroy
    MsDefNo.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
