class MskbnmidController < ApplicationController
  layout "doc_main"

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @ms_kbn_mid_pages, @ms_kbn_mids = paginate :ms_kbn_mids, :per_page => 100
  end

  def show
    @ms_kbn_mid = MsKbnMid.find(params[:id])
  end

  def new
    @ms_kbn_mid = MsKbnMid.new
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def create
  
      ## 登録数制限  
    count_d = MsKbnMid.find(:first , :select=>"count(*) as ct_num")
    if count_d[:ct_num].to_i >= $ENV_PARAM_max_num_mst_project.to_i
        render :text=>"最大登録件数を超えました[中区分マスタ]、"+ $ENV_PARAM_max_num_mst_project.to_s + "件まで登録可能です。<br><a href='#' onClick='history.back();'>[戻る]</a>"
        return
    end
        
    kParam={}
    kParam[:kbn_name]   = params[:ms_kbn_mid][:kbn_name]
    kParam[:order_no]   = params[:ms_kbn_mid][:order_no]
    kParam['userid']       = session['user'][:id].to_s
    kParam['createat']     = Time.now
    kParam['updateat']     = Time.now
      
#    @ms_kbn_mid = MsKbnMid.new(params[:ms_kbn_mid])
    @ms_kbn_mid = MsKbnMid.new(kParam)
    if @ms_kbn_mid.save
      flash[:notice] = 'MsKbnMid was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @ms_kbn_mid = MsKbnMid.find(params[:id])
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def update

    kParam={}
    kParam[:kbn_name]   = params[:ms_kbn_mid][:kbn_name]
    kParam[:order_no]   = params[:ms_kbn_mid][:order_no]
    kParam['userid']       = session['user'][:id].to_s
    kParam['updateat']     = Time.now
  
    @ms_kbn_mid = MsKbnMid.find(params[:id])
    if @ms_kbn_mid.update_attributes(kParam)
      flash[:notice] = 'MsKbnMid was successfully updated.'
#      redirect_to :action => 'show', :id => @ms_kbn_mid
      redirect_to :action => 'list'
    else
      render :action => 'edit'
    end
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def destroy
    MsKbnMid.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
