class MsuserController < ApplicationController
  layout "doc_main"

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @ms_user_pages, @ms_users = paginate :ms_users, :per_page => 10
  end

  def show
    @ms_user = MsUser.find(params[:id])
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def new
    @ms_user = MsUser.new
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def create

    ## 登録数制限  
#    logger.debug '#:ct_num='+count_d[:ct_num].inspect

=begin
    count_d = MsUser.find(:first , :select=>"count(*) as ct_num")
    if count_d[:ct_num].to_i >= $ENV_PARAM_max_num_mst_user.to_i
        render :text=>"最大登録件数を超えました[ユーザーマスタ]、"+ $ENV_PARAM_max_num_mst_user.to_s + "件まで登録可能です。<br><a href='#' onClick='history.back();'>[戻る]</a>"
        return
    end
=end

  
    uParam={}
    uParam[:user_name]  = params[:ms_user][:user_name]
    uParam[:order_no]   = params[:ms_user][:order_no]
    uParam[:password]   = params[:ms_user][:password]
    uParam[:mail]        = params[:ms_user][:mail]
  
    uParam['userid']       = session['user'][:id].to_s
    uParam['createat']     = Time.now
    uParam['updateat']     = Time.now

#    @ms_user = MsUser.new(params[:ms_user])
    @ms_user = MsUser.new(uParam)
    if @ms_user.save
      flash[:notice] = 'MsUser was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def edit
    @ms_user = MsUser.find(params[:id])
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def update
  
    uParam={}
    uParam[:user_name]  = params[:ms_user][:user_name]
    uParam[:order_no]   = params[:ms_user][:order_no]
    uParam[:password]   = params[:ms_user][:password]
    uParam[:mail]        = params[:ms_user][:mail]
  
    uParam['userid']       = session['user'][:id].to_s
    uParam['updateat']     = Time.now
    @ms_user = MsUser.find(params[:id])
    if @ms_user.update_attributes(uParam)
      flash[:notice] = 'MsUser was successfully updated.'
#      redirect_to :action => 'show', :id => @ms_user
      redirect_to :action => 'list'
    else
      render :action => 'edit'
    end
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def destroy
    MsUser.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
