class UserController < ApplicationController
  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @ms_user_pages, @ms_users = paginate :ms_users, :per_page => 5
  end

  def show
    @ms_user = MsUser.find(params[:id])
  end

  def new
    @ms_user = MsUser.new
  end

  def create
    @ms_user = MsUser.new(params[:ms_user])
    if @ms_user.save
      flash[:notice] = 'MsUser was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @ms_user = MsUser.find(params[:id])
  end

  def update
    @ms_user = MsUser.find(params[:id])
    if @ms_user.update_attributes(params[:ms_user])
      flash[:notice] = 'MsUser was successfully updated.'
      redirect_to :action => 'show', :id => @ms_user
    else
      render :action => 'edit'
    end
  end

  def destroy
    MsUser.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
