require File.dirname(__FILE__) + '/../test_helper'
require 'mscode_controller'

# Re-raise errors caught by the controller.
class MscodeController; def rescue_action(e) raise e end; end

class MscodeControllerTest < Test::Unit::TestCase
  fixtures :ms_codes

  def setup
    @controller = MscodeController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    @first_id = ms_codes(:first).id
  end

  def test_index
    get :index
    assert_response :success
    assert_template 'list'
  end

  def test_list
    get :list

    assert_response :success
    assert_template 'list'

    assert_not_nil assigns(:ms_codes)
  end

  def test_show
    get :show, :id => @first_id

    assert_response :success
    assert_template 'show'

    assert_not_nil assigns(:ms_code)
    assert assigns(:ms_code).valid?
  end

  def test_new
    get :new

    assert_response :success
    assert_template 'new'

    assert_not_nil assigns(:ms_code)
  end

  def test_create
    num_ms_codes = MsCode.count

    post :create, :ms_code => {}

    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_equal num_ms_codes + 1, MsCode.count
  end

  def test_edit
    get :edit, :id => @first_id

    assert_response :success
    assert_template 'edit'

    assert_not_nil assigns(:ms_code)
    assert assigns(:ms_code).valid?
  end

  def test_update
    post :update, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'show', :id => @first_id
  end

  def test_destroy
    assert_nothing_raised {
      MsCode.find(@first_id)
    }

    post :destroy, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_raise(ActiveRecord::RecordNotFound) {
      MsCode.find(@first_id)
    }
  end
end
