require File.dirname(__FILE__) + '/../test_helper'
require 'mskbnmid_controller'

# Re-raise errors caught by the controller.
class MskbnmidController; def rescue_action(e) raise e end; end

class MskbnmidControllerTest < Test::Unit::TestCase
  fixtures :ms_kbn_mids

  def setup
    @controller = MskbnmidController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    @first_id = ms_kbn_mids(:first).id
  end

  def test_index
    get :index
    assert_response :success
    assert_template 'list'
  end

  def test_list
    get :list

    assert_response :success
    assert_template 'list'

    assert_not_nil assigns(:ms_kbn_mids)
  end

  def test_show
    get :show, :id => @first_id

    assert_response :success
    assert_template 'show'

    assert_not_nil assigns(:ms_kbn_mid)
    assert assigns(:ms_kbn_mid).valid?
  end

  def test_new
    get :new

    assert_response :success
    assert_template 'new'

    assert_not_nil assigns(:ms_kbn_mid)
  end

  def test_create
    num_ms_kbn_mids = MsKbnMid.count

    post :create, :ms_kbn_mid => {}

    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_equal num_ms_kbn_mids + 1, MsKbnMid.count
  end

  def test_edit
    get :edit, :id => @first_id

    assert_response :success
    assert_template 'edit'

    assert_not_nil assigns(:ms_kbn_mid)
    assert assigns(:ms_kbn_mid).valid?
  end

  def test_update
    post :update, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'show', :id => @first_id
  end

  def test_destroy
    assert_nothing_raised {
      MsKbnMid.find(@first_id)
    }

    post :destroy, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_raise(ActiveRecord::RecordNotFound) {
      MsKbnMid.find(@first_id)
    }
  end
end
