<?php

// ルートディレクトリを変数にセットする
// define("ROOT_DIR", $_SERVER['DOCUMENT_ROOT']."/..");

// Smartyクラスを呼び出す
require_once("Smarty.class.php");

// require_once("AppConst.php");

// Smartyクラスを継承したMySmartyクラスを作成する
class MySmarty extends Smarty {
	
	// 変数
	//public $AppConst;
	
	//コンストラクタ（コンストラクタとは、オブジェクトを生成する際に呼び出されて内容の初期化などを行なうメソッドです。
	function MySmarty () {
		$clsConst = new AppConst();

		// テンプレートディレクトリの上書き
		 $this->template_dir   = DC_ROOT_DIR . "/templates";
		
		// コンパイルディレクトリの上書き
		 $this->compile_dir    = DC_ROOT_DIR . "/templates_c";
		
		// 左右デリミタの上書き
		// $this->left_delimiter  = "{{";   // デミリタとは、Smartyの変数や関数などを区切る記号です。
		// $this->right_delimiter = "}}";   // デフォルトのデミリタだと開始区切りが「{」で終了区切りが「}」で区切るとSmartyの処理として認識される設定になっています。
		
		// Smartyクラスのコンストラクタの呼び出し
		$this->Smarty();
		
		// Const
		$base_dir   = DC_ROOT_URL;
		$this->assign("ANQ_ROOT_DIR"     , $base_dir );
		$this->assign("ANQ_ROOT_URL"     , $base_dir );
		$this->assign("PUBLIC_DIR"       , $base_dir . "/public");
		$this->assign("PHP_DIR"          , $base_dir . "/php");
		$this->assign("IMAGE_DIR"        , $base_dir . "/image");
		$this->assign("IMAGE_DIR_USER"   , $base_dir . "/image_user");
		$this->assign("DC_DOC_DIR"       , $base_dir . "/doc_file");
		$this->assign("DC_SERVER_NAME"   ,  DC_SERVER_NAME);
		$this->assign("DC_PUB_URL_PATH"  ,  DC_PUB_URL_PATH);
		$this->assign("APP_CONST"        , $clsConst);
	}
	
	//
	// function getLayout(){
	// 	return "/Layout/anq_main.tpl";
	// 	}
	
	//------------------------------------
	// @calling
	// @purpose
	// @date
	// @argment
	// @return
	//------------------------------------
	function disp_Layout ( $tpl_name ) {
		$this->display($this->template_dir . "/Layout/dc_head.tpl");
		$this->display($this->template_dir . "/" .$tpl_name );
		$this->display($this->template_dir . "/Layout/dc_foot.tpl");
	}
}
?>