// docmi_dumper.cpp : R\[ AvP[Vp̃Gg |Cg̒`
//

#include "stdafx.h"
#include "../import/FileReader.h"
using namespace docmi;

void printSequence( const Sequence* s, int nest );

void indent( int count )
{
	for( int i=0; i < count; i++ ){
		printf( "  " );
	}
}

// 1Gg_v
void printElement( const Element* e, int nest )
{
	String tmp;
	indent( nest );

	if( e->isStringVR() ){
		tmp = "\"";
		tmp += e->getString();
		tmp += "\"";
	} else {
		tmp = e->getString();
	}

	String vr = e->getVR();
	if( vr.size() <= 0 ){ vr = "??"; }

	printf( "(%04x,%04x) [%s] %-25s # %-6d\n", e->groupID(), e->elementID(), vr.c_str(), tmp.c_str(), e->length() );
	const Sequences* sequences = e->getSequences();

	for( Sequences::const_iterator it=sequences->begin(); it != sequences->end(); ++it ){
		printSequence( it, nest + 1 );
	}
}

// 1V[PX_v
void printSequence( const Sequence* s, int nest )
{
	const Elements* elements = s->getElements();
	
	indent( nest );
	printf( "<Sequence start>\n" );

	for( Elements::const_iterator it=elements->begin(); it != elements->end(); ++it ){
		printElement( it, nest + 1 );
	}

	indent( nest );
	printf( "<Sequence end>\n" );
}


int main(int argc, char* argv[])
{
	if( argc < 2 ){
		puts( "docmi_dumper [path]" );
		return 1;
	}

	FileReader reader;
	Sequence dicom_data;

	try {
		reader.open( dicom_data, argv[1] );
		puts( "FileReader::open() Success" );

		printSequence( &dicom_data, 0 );
	} catch( Exception& x ){
		puts( "FileReader::open() Failed" );
	}

	return 0;
}

