#ifndef INCLUDE_IMAGE_DATA_H
#define INCLUDE_IMAGE_DATA_H

#include "FileReader.h"

/** 摜f[^NX
 */

class DicomImageData
{
	docmi::Sequence m_data;
	int m_window_center;
	int m_window_width;
	BYTE* m_image_data;
	const BYTE* m_row_data;
	int   m_row_data_size;
	double m_zoom_ratio;
	BITMAPINFO m_bmp_info;
	docmi::String m_path;

	int m_image_xsize;
	int m_image_ysize;

	// 쐬ς݃rbg}bv
	int m_bmp_window_center;
	int m_bmp_window_width;
	BYTE* m_bmp_image_data;
	int m_bmp_select_frame;

	int m_left;
	int m_top;
	int m_select_frame;

private:
	DicomImageData( const DicomImageData& );
	DicomImageData& operator=( const DicomImageData& );
	

public:

	// 摜t@Cǂݍ
	bool load()
	{
		if( m_path.size() <= 0 ) return false;
		if( m_image_data ) return true;

		docmi::FileReader reader;
		try{
			reader.open( m_data, m_path );
		} catch( docmi::Exception& x ){
			x.message();
			return false;
		}

		// 摜f[^擾		
		const docmi::Element* e = m_data.search( 0x7fe0, 0x0010 );
		m_row_data = e->data();
		m_row_data_size = e->length();

		// rbg}bvf[^̈m
		m_image_data = new BYTE[ atof( m_data.getString( 0x0028, 0x0011 ) ) * atof( m_data.getString( 0x0028, 0x0010 ) ) * 3 ];

		return true;
	}

	// 摜t@CJ
	void unload()
	{
		delete [] m_image_data;
		m_image_data = NULL;
		m_row_data = NULL;
		m_row_data_size = 0;
		m_data.clear();

		m_bmp_window_center = 0;
		m_bmp_window_width = 0;
		m_bmp_image_data = NULL;
		m_bmp_select_frame = -1;
	}

	DicomImageData()
	{
		m_image_data = NULL;

		// BITMAPINFOHEADER \̂ɒlZbg
		ZeroMemory(&m_bmp_info, sizeof(BITMAPINFO));
		m_bmp_info.bmiHeader.biSize = sizeof(BITMAPINFO);         // \̂̃TCY
		m_bmp_info.bmiHeader.biPlanes = 1;                              // v[
		m_bmp_info.bmiHeader.biBitCount = 24;                           // rbg
		m_bmp_info.bmiHeader.biCompression = BI_RGB;                    // k`
		m_bmp_info.bmiHeader.biSizeImage = 0;                           // C[WTCY
		m_bmp_info.bmiHeader.biXPelsPerMeter = 0;                       // w𑜓x
		m_bmp_info.bmiHeader.biYPelsPerMeter = 0;                       // x𑜓x
		m_bmp_info.bmiHeader.biClrUsed = 0;                             // J[CfbNX
		m_bmp_info.bmiHeader.biClrImportant = 0;                        // dvJ[CfbNX

		clear();
	}

	~DicomImageData()
	{
		clear();
	}

	void clear()
	{
		delete [] m_image_data;
		m_image_data = NULL;
		m_row_data = NULL;
		m_row_data_size = 0;
		m_data.clear();
		m_zoom_ratio = 1.0;
		m_window_center = 0;
		m_window_width = 1;

		m_bmp_window_center = 0;
		m_bmp_window_width = 0;
		m_bmp_image_data = NULL;
		m_bmp_select_frame = -1;
		m_path = "";
		m_left = 0;
		m_top = 0;
		m_select_frame = 0;

		m_image_xsize = 0;
		m_image_ysize = 0;
	}

	// t@CJ
	bool open( const char* path )
	{
		clear();
		m_path = path;

		docmi::FileReader reader;
		try{
			reader.open( m_data, path );
		} catch( docmi::Exception& x ){
			x.message();
			return false;
		}

		// 摜f[^擾		
		const docmi::Element* e = m_data.search( 0x7fe0, 0x0010 );
		m_row_data = e->data();
		m_row_data_size = e->length();

		m_image_xsize = atof( m_data.getString( 0x0028, 0x0011 ) );
		m_image_ysize = atof( m_data.getString( 0x0028, 0x0010 ) );

		// rbg}bvf[^̈m
		m_image_data = new BYTE[ m_image_xsize * m_image_ysize * 3 ];

		// KZbg
		m_window_center = atof( m_data.getString( 0x0028, 0x1050 ) );
		m_window_width  = atof( m_data.getString( 0x0028, 0x1051 ) );
		if( m_window_width == 0 ){
			int bits_stored = getBitsStored();
			int rep = getPixelRepresentation();
			int unsigned_max_value = 1 << bits_stored;
			if( rep == 1 ){
				m_window_center = 0;
				m_window_width = unsigned_max_value;
			} else {
				m_window_center = unsigned_max_value / 2;
				m_window_width = unsigned_max_value;
			}
		}

		return true;
	}

	void setWindowCenter( int center ){ m_window_center = center; }
	void setWindowWidth( int width ){ m_window_width = max( 1, width ); }

	int getWindowCenter(){ return m_window_center; }
	int getWindowWidth(){ return m_window_width; }

	int getImageWidth()
	{
		return m_image_xsize;
	}

	int getImageHeight()
	{
		return m_image_ysize;
	}

	int getSamplePerPixel()
	{
		return atoi( m_data.getString( 0x0028, 0x0002 ) );
	}

	int getBitsAlloc()
	{
		return atoi( m_data.getString( 0x0028, 0x0100 ) );
	}

	int getBitsStored()
	{
		return atoi( m_data.getString( 0x0028, 0x0101 ) );
	}

	int getPixelRepresentation()
	{
		return atoi( m_data.getString( 0x0028, 0x0103 ) );
	}

	int getFrameCount()
	{
		return max( 1, atoi( m_data.getString( 0x0028, 0x0008 ) ) );
	}

	/** 摜1t[f[^TCYԂ
	 */
	int getFrameSize()
	{
		return getImageWidth() * getImageHeight() * ( getBitsAlloc() / 8 ) * getSamplePerPixel();
	}

	double getZoomRatio()
	{
		return m_zoom_ratio;
	}

	void setZoomRatio( double zoom_ratio )
	{
		m_zoom_ratio = zoom_ratio;
	}

	void setPan( int left, int top )
	{
		m_left = left;
		m_top  = top;
	}

	int getPanTop()
	{
		return m_top;
	}

	int getPanLeft()
	{
		return m_left;
	}

	int getSelectFrame()
	{
		return m_select_frame;
	}

	void setSelectFrame( int frame )
	{
		m_select_frame = max( 0, min( frame, getFrameCount() - 1 ) );
	}

	/** w肳ꂽt[̉摜f[^Ԃ
	 */
	const BYTE* getFrameData( int index )
	{
		int frame_count = getFrameCount();
		if( index < 0 || index >= frame_count ) return NULL;
		int frame_size = getFrameSize();

		if( m_row_data_size >= frame_size * ( index + 1 ) ){
			return m_row_data + frame_size * index;
		} else {
			return NULL;
		}
	}

	// \
	void show( HDC dc, RECT& show_area )
	{
		int start_lap = timeGetTime();

		FillRect( dc, &show_area, (HBRUSH)GetStockObject( WHITE_BRUSH ) );
		SetTextColor(dc, RGB(0, 0, 0));
		SetBkColor( dc, RGB(255,255,255) );

		if( !load() ){
			docmi::String s = "摜J܂";
			TextOut( dc, 10, 50, s.c_str(), s.size() );
			return;
		}

		try {
			convertDicom2Bmp();

			int wx = getImageWidth();
			int wy = getImageHeight();

			// BITMAPINFOHEADER \
			m_bmp_info.bmiHeader.biWidth = wx;                 // 
			m_bmp_info.bmiHeader.biHeight = -wy;              // 

			// 摜\
			::SetStretchBltMode( dc, HALFTONE );

			StretchDIBits(dc, -m_left, -m_top, wx * m_zoom_ratio, wy * m_zoom_ratio, 0, 0, wx, wy,
				m_image_data, &m_bmp_info, DIB_RGB_COLORS, SRCCOPY);
		} catch( docmi::Exception& x ){
			x.message();
			docmi::String s = "\ł܂";
			TextOut( dc, 10, 70, s.c_str(), s.size() );
		}

		// I[oCeLXg\ -->
		char temp[512];
		sprintf( temp, "C:%d W:%d", m_window_center, m_window_width );
		TextOut( dc, 10, 10, temp, strlen( temp ) );

		sprintf( temp, "Image Creation Time: %dmsec", timeGetTime() - start_lap );
		TextOut( dc, 10, 30, temp, strlen( temp ) );

		sprintf( temp, "Frame: %d", getSelectFrame() + 1 );
		TextOut( dc, 10, 50, temp, strlen( temp ) );

		// <--
	}

	/** KύXe[uNX
	*/
	class Lut
	{
		int m_lower;
		int m_higher;
	public:
		Lut( int lower, int higher ){
			m_lower = lower;
			m_higher = higher;
		}

		// lLUTϊ0`255͈̔͂ŕԂ
		u_char convert( int value ){
			if( value <= m_lower ) return 0;
			if( value >= m_higher ) return 255;

			return ( value - m_lower ) * 255 / ( m_higher - m_lower );
		}
	};

	/** DICOMEf[^rbg}bvɕϊ
	 */
	void convertDicom2Bmp()
	{
		int image_x = getImageWidth();
		int image_y = getImageHeight();
		docmi::Exception x;

		if( m_row_data ){

			// O쐬rbg}bvƓȂArbg}bvg܂킷
			if( m_bmp_window_center == m_window_center &&
				m_bmp_window_width  == m_window_width &&
				m_bmp_image_data    == m_image_data &&
				m_bmp_select_frame  == m_select_frame ){
				return;
			}

			const BYTE* image = getFrameData( getSelectFrame() );
			if( image == NULL ){
				throw x;
			}
			
			Lut lut( m_window_center - m_window_width / 2, m_window_center + m_window_width / 2 );

			int sample = getSamplePerPixel();
			int bits_alloc = getBitsAlloc();
			int representation = getPixelRepresentation();

			if( sample == 1 ){ // mN摜
				if( bits_alloc == 16 ){
					const short* s_image = (const short*)image;
					for( int y=0; y < image_y; y++ ){
						for( int x=0; x < image_x; x++ ){
							m_image_data[ ( y * image_x + x ) * 3 ] = 
							m_image_data[ ( y * image_x + x ) * 3 + 1 ] = 
							m_image_data[ ( y * image_x + x ) * 3 + 2 ] = lut.convert( s_image[ y * image_x + x ] );
						}
					}
				} else if( bits_alloc == 8 ){
					const BYTE* uc_image = (const BYTE*)image;
					for( int y=0; y < image_y; y++ ){
						for( int x=0; x < image_x; x++ ){
							m_image_data[ ( y * image_x + x ) * 3 ] = 
							m_image_data[ ( y * image_x + x ) * 3 + 1 ] = 
							m_image_data[ ( y * image_x + x ) * 3 + 2 ] = lut.convert( uc_image[ y * image_x + x ] );
						}
					}

				} else {
					throw x;
				}

			} else if( sample == 3 ){ // J[摜
				if( bits_alloc == 8 ){
					const BYTE* uc_image = (const BYTE*)image;
					for( int y=0; y < image_y; y++ ){
						for( int x=0; x < image_x; x++ ){
							m_image_data[ ( y * image_x + x ) * 3 ]     = lut.convert( uc_image[ ( y * image_x + x ) * 3 + 2 ] );
							m_image_data[ ( y * image_x + x ) * 3 + 1 ] = lut.convert( uc_image[ ( y * image_x + x ) * 3 + 1 ] );
							m_image_data[ ( y * image_x + x ) * 3 + 2 ] = lut.convert( uc_image[ ( y * image_x + x ) * 3 ] );
						}
					}

				} else {
					throw x;
				}
				
			} else {
				throw x;
			}

			// 쐬rbg}bṽp[^ۑ
			m_bmp_window_center = m_window_center;
			m_bmp_window_width  = m_window_width;
			m_bmp_image_data    = m_image_data;
			m_bmp_select_frame  = m_select_frame;
		}
	}
};

#endif
