#ifndef INCLUDE_IMAGE_MANAGER
#define INCLUDE_IMAGE_MANAGER

#include "ImageData.h"


/** 摜ǗNX
 */
class ImageManager
{
	std::vector<DicomImageData*> m_images;
	int m_select_index;
	DicomImageData m_null_object;

public:
	ImageManager()
	{
		m_select_index = 0;
	}

	~ImageManager()
	{
		std::vector<DicomImageData*>::iterator it;
		for( it = m_images.begin(); it != m_images.end(); ++it ){
			delete *it;
		}

		m_images.clear();
	}

	// I摜ԍԂ(m_images.size()͈͓̔Ɋۂ߂ĕԂ)
	int getSelectIndex()
	{
		if( m_select_index >= (int)m_images.size() ) m_select_index = m_images.size() - 1;
		if( m_select_index < 0 ) m_select_index = 0;
		return m_select_index;
	}

	DicomImageData* getSelectImage()
	{
		if( m_images.size() > 0 ){
			return m_images[ getSelectIndex() ];
		} else {
			return &m_null_object;
		}
	}
	void next() // ̉摜I
	{
		m_select_index = getSelectIndex() + 1;
	}

	void prev() // Ỏ摜I
	{
		m_select_index = getSelectIndex() - 1;
	}

	// 摜ǉ(̉ImageManagers)
	void add( DicomImageData* image )
	{
		m_images.push_back( image );
		m_select_index = m_images.size() - 1;
	}

	void close( int index )
	{
		if( index >= 0 && index < (int)m_images.size() ){
			std::vector<DicomImageData*>::iterator it = m_images.begin() + index;
			delete *it;
			m_images.erase( it );

		}
	}

	void remove( int index );
	void removeSelectImage();
};

#endif
