#ifndef INCLUDE_SURFACE_CONTROLLER_H
#define INCLUDE_SURFACE_CONTROLLER_H

/** DCiT[tFCXjǗNX
 */
class SurfaceController
{
	int m_current_width;
	int m_current_height;
	int m_new_width;
	int m_new_height;
	HDC m_hdc_mem;
	HBITMAP m_hbmp;
	BYTE* m_bmp_data;

public:
	SurfaceController()
	{
		m_current_width = m_current_height = 1;
		m_new_width = m_new_height = 1;
		m_hdc_mem = CreateCompatibleDC( NULL );
		if( m_hdc_mem == NULL ){
			docmi::Exception x;
			throw x;
		}
		m_hbmp = NULL;
		m_bmp_data = NULL;
	}

	~SurfaceController()
	{
		if( m_hbmp ){
			DeleteObject( m_hbmp );
		}

		if( m_hdc_mem ){
			DeleteDC( m_hdc_mem );
		}
	}

	// ʂ̑傫Zbg
	void setBitmapSize( int width, int height )
	{
		m_new_width = max( m_new_width ,width );
		m_new_height = max( m_new_height, height );
	}

	// DCnhԂ
	// EȂƂNULLԂ
	HDC getMemDC()
	{
		if( m_hbmp == NULL || m_current_width < m_new_width || m_current_height < m_new_height ){
			if( m_hbmp ){
				DeleteObject( m_hbmp );
			}

			//	DIBSectionɗꍇ
			BITMAPINFO bmi;
			bmi.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
			bmi.bmiHeader.biWidth		=  m_new_width;
			bmi.bmiHeader.biHeight		= -m_new_height;
			bmi.bmiHeader.biPlanes		= 1;
			bmi.bmiHeader.biBitCount	= 24;
			bmi.bmiHeader.biCompression	= BI_RGB /* BI_BITFIELDS */ ;

			HDC hdc = ::GetDC(NULL);
			m_hbmp = ::CreateDIBSection( hdc, &bmi , DIB_RGB_COLORS, (void**)&m_bmp_data, NULL, 0 );
			::ReleaseDC(NULL,hdc);

			if( m_hbmp==NULL ){
				docmi::Exception x;
				throw x;
			}

			m_current_width  = m_new_width;
			m_current_height = m_new_height;
		}

		SelectObject( m_hdc_mem, m_hbmp );

		return m_hdc_mem;
	}
};

#endif
