#define _WIN32_WINNT 0x0400

#include <windows.h>
#include "resrc1.h"
#include <math.h>
#include <stdio.h>
#include <commdlg.h>
#include "ImageManager.h"
#include "SurfaceController.h"
#include "ImageListWindow.h"
#include <crtdbg.h>

const char WINDOW_CLASS_NAME[] = "Docmi View";
const char LIST_WINDOW_CLASS_NAME[] = "List Window";
HINSTANCE g_hInst;

SurfaceController g_mem_dc;
ImageManager g_image_manager;

/** t@CJ_CAO\
 */
void openFile(HWND hWnd)
{
	char FileName[_MAX_PATH+1];
	char FileTitle[_MAX_PATH+1];

	strcpy( FileName, "" );
	strcpy( FileTitle, "" );

    OPENFILENAME ofn;
    memset(&ofn, 0, sizeof(OPENFILENAME));
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = hWnd;
    ofn.lpstrFilter = "DICOM files(*.dcm)\0*.dcm\0All Files(*.*)\0*.*\0\0";
    ofn.lpstrFile = FileName;
    ofn.nMaxFile = sizeof(FileName)-1;
    ofn.Flags = OFN_FILEMUSTEXIST;
    ofn.lpstrDefExt = "bmp";
    ofn.nMaxFileTitle = sizeof(FileTitle)-1;
    ofn.lpstrFileTitle = FileTitle;
    ofn.lpstrTitle = "t@CJ";

    if (GetOpenFileName(&ofn)) {
		DicomImageData* temp = new DicomImageData;
		temp->open( FileName );
		g_image_manager.add( temp );
		InvalidateRect(hWnd, NULL, TRUE);
    }
}

void closeFile()
{
	g_image_manager.close( g_image_manager.getSelectIndex() );
}

void repaint( HWND hWnd )
{
    PAINTSTRUCT paint;
    RECT rt;
    GetClientRect( hWnd, &rt );
    HDC hdc = BeginPaint( hWnd, &paint );

	// DC̃nh擾
	//g_mem_dc.setSrcDC( hdc );
	g_mem_dc.setBitmapSize( rt.right - rt.left, rt.bottom - rt.top );
	HDC mem_hdc = g_mem_dc.getMemDC();

	// 摜DCɕ`
	g_image_manager.getSelectImage()->show( mem_hdc, rt );

	// DCEChEDCɃRs[
	BitBlt( hdc, 0, 0, rt.right - rt.left, rt.bottom - rt.top, mem_hdc, 0, 0, SRCCOPY );

	ValidateRect(hWnd, NULL);
    EndPaint(hWnd, &paint);
    return;
}



static SCROLLINFO v_si;
static SCROLLINFO h_si;

// XN[o[XV
void updateScrollBar( HWND hWnd )
{
	// XN[o[ݒ
	int image_height = g_image_manager.getSelectImage()->getImageHeight() * g_image_manager.getSelectImage()->getZoomRatio();
	RECT rc;
	GetClientRect(hWnd, &rc);
	v_si.cbSize = sizeof(SCROLLINFO);
	v_si.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
	v_si.nMin = 0;
	v_si.nMax = image_height;
	v_si.nPage = rc.bottom;
	v_si.nPos = max( 0, min( v_si.nMax - (int)v_si.nPage, g_image_manager.getSelectImage()->getPanTop() ) );
	SetScrollInfo( hWnd, SB_VERT, &v_si, TRUE );

	// XN[o[ݒ
	int image_width = g_image_manager.getSelectImage()->getImageWidth() * g_image_manager.getSelectImage()->getZoomRatio();
	h_si.cbSize = sizeof(SCROLLINFO);
	h_si.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
	h_si.nMin = 0;
	h_si.nMax = image_width;
	h_si.nPage = rc.right;
	h_si.nPos = max( 0, min( h_si.nMax - (int)h_si.nPage, g_image_manager.getSelectImage()->getPanLeft() ) );
	SetScrollInfo( hWnd, SB_HORZ, &h_si, TRUE );

	g_image_manager.getSelectImage()->setPan( h_si.nPos, v_si.nPos );
}

// 摜̊g嗦ύX
void zoom( HWND wnd, double zoom_ratio )
{
	g_image_manager.getSelectImage()->setZoomRatio( zoom_ratio );
	InvalidateRect( wnd, NULL, FALSE );
	updateScrollBar( wnd );
	repaint( wnd );
}

/** CEChEbZ[W[v
 */
LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static int xPos;
	static int yPos;
	static int center;
	static int width;
	static BOOL b_mouse_down = FALSE;

    switch (msg) {
		case WM_CREATE:
            break;

        case WM_COMMAND:
			switch( LOWORD(wParam) ){
            case IDC_TEST:
				openFile( hWnd );
				updateScrollBar( hWnd );
                break;
			case IDC_CLOSE:
				closeFile();
				InvalidateRect(hWnd, NULL, TRUE);
				updateScrollBar( hWnd );
				break;
			case IDC_ZOOM_25:
				zoom( hWnd, 0.25 );
				break;
			case IDC_ZOOM_50:
				zoom( hWnd, 0.5 );
				break;
			case IDC_ZOOM_75:
				zoom( hWnd, 0.75 );
				break;
			case IDC_ZOOM_100:
				zoom( hWnd, 1.0 );
				break;
			case IDC_ZOOM_110:
				zoom( hWnd, 1.1 );
				break;
			case IDC_ZOOM_120:
				zoom( hWnd, 1.2 );
				break;
			case IDC_ZOOM_130:
				zoom( hWnd, 1.3 );
				break;
			case IDC_ZOOM_150:
				zoom( hWnd, 1.5 );
				break;
			case IDC_ZOOM_200:
				zoom( hWnd, 2.0 );
				break;
			case IDC_ZOOM_300:
				zoom( hWnd, 3.0 );
				break;
			case IDC_ZOOM_400:
				zoom( hWnd, 4.0 );
				break;
			case IDC_ZOOM_500:
				zoom( hWnd, 5.0 );
				break;
            }

			
            break;
        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        case WM_PAINT:
            repaint( hWnd );
            break;
		case WM_KEYDOWN:
			{
				//char down_key[16];

				//if (( wParam >= 0x41 && wParam <=0x5A) || ( wParam >= 0x30 && wParam <= 0x39)) {
				switch( wParam ){
				case 'J':
					g_image_manager.getSelectImage()->unload();
					g_image_manager.next();
					InvalidateRect( hWnd, NULL, TRUE );
					updateScrollBar( hWnd );

					break;
				case 'K':
					g_image_manager.getSelectImage()->unload();
					g_image_manager.prev();
					InvalidateRect( hWnd, NULL, TRUE );
					updateScrollBar( hWnd );
					break;
				case 'H':
					g_image_manager.getSelectImage()->setSelectFrame( g_image_manager.getSelectImage()->getSelectFrame() - 1 );
					InvalidateRect( hWnd, NULL, TRUE );
					break;
				case 'L':
					g_image_manager.getSelectImage()->setSelectFrame( g_image_manager.getSelectImage()->getSelectFrame() + 1 );
					InvalidateRect( hWnd, NULL, TRUE );
					break;
					/*
				case VK_TAB:
					wsprintf((LPSTR)str, (LPCTSTR)str_org2, "TAB");
					break;
				case VK_SHIFT:
					wsprintf((LPSTR)str, (LPCTSTR)str_org2, "SHIFT");
					break;
				case VK_ESCAPE:
					wsprintf((LPSTR)str, (LPCTSTR)str_org2, "ESC");
					break;
				default:
					strcpy(str, "mȂL[ł");
					break;
					*/
				//}

				//sprintf( down_key, "%c", wParam );
				//SetWindowText( hWnd, down_key );
				}
			}
			break;

		case WM_LBUTTONDOWN:
			{
				xPos = LOWORD(lParam);  // horizontal position of cursor 
				yPos = HIWORD(lParam);  // vertical position of cursor 
				center = g_image_manager.getSelectImage()->getWindowCenter();
				width = g_image_manager.getSelectImage()->getWindowWidth();
				b_mouse_down = TRUE;
				SetCapture( hWnd );
			}

			break;

		case WM_LBUTTONUP:
		case WM_MOUSEMOVE:
			{
				if( b_mouse_down ){
					int x = (short)LOWORD(lParam);  // horizontal position of cursor 
					int y = (short)HIWORD(lParam);  // vertical position of cursor 

					g_image_manager.getSelectImage()->setWindowCenter( center - y + yPos );
					g_image_manager.getSelectImage()->setWindowWidth( width + x - xPos );
					InvalidateRect( hWnd, NULL, FALSE );
					repaint( hWnd );
				}

				if( msg == WM_LBUTTONUP ){
					b_mouse_down = FALSE;
					ReleaseCapture();
				}
			}

			break;

		case WM_SIZE:
			updateScrollBar( hWnd );
			break;
		case WM_VSCROLL:
			{
				int dy;
				switch (LOWORD(wParam)) {
					case SB_LINEUP:
						dy = -20;
						break;
					case SB_LINEDOWN:
						dy = 20;
						break;
					case SB_PAGEUP:
						dy = -1 * v_si.nPage;
						break;
					case SB_PAGEDOWN:
						dy = v_si.nPage;
						break;
					case SB_THUMBTRACK:
						dy = HIWORD(wParam) - v_si.nPos;
						break;
					default:
						dy = 0;
						break;
				}

				if (dy != 0) {
					v_si.nPos += dy;
					v_si.nPos = max( (int)v_si.nMin, min( (int)v_si.nMax - (int)v_si.nPage, (int)v_si.nPos ) );
					g_image_manager.getSelectImage()->setPan( g_image_manager.getSelectImage()->getPanLeft(), v_si.nPos );
					SetScrollInfo(hWnd, SB_VERT, &v_si, TRUE);
					//ScrollWindow(hWnd, 0, -dy, NULL, NULL);
					InvalidateRect( hWnd, NULL, TRUE );
					UpdateWindow(hWnd);
				}
			}
			break;
			case WM_HSCROLL:
			{
				int dy;
				switch (LOWORD(wParam)) {
					case SB_LINEUP:
						dy = -20;
						break;
					case SB_LINEDOWN:
						dy = 20;
						break;
					case SB_PAGEUP:
						dy = -1 * h_si.nPage;
						break;
					case SB_PAGEDOWN:
						dy = h_si.nPage;
						break;
					case SB_THUMBTRACK:
						dy = HIWORD(wParam) - h_si.nPos;
						break;
					default:
						dy = 0;
						break;
				}

				if (dy != 0) {
					h_si.nPos += dy;
					h_si.nPos = max( (int)h_si.nMin, min( (int)h_si.nMax - (int)h_si.nPage, (int)h_si.nPos ) );
					g_image_manager.getSelectImage()->setPan( h_si.nPos, g_image_manager.getSelectImage()->getPanTop() );
					SetScrollInfo(hWnd, SB_HORZ, &h_si, TRUE);
					//ScrollWindow(hWnd, 0, -dy, NULL, NULL);
					InvalidateRect( hWnd, NULL, TRUE );
					UpdateWindow(hWnd);
				}
			}
			break;
			case WM_MOUSEWHEEL:
			{
				int value = (short)HIWORD(wParam);
				if( (short)HIWORD(wParam) > 0 ){
					// zC[ɓ̏
					SendMessage( hWnd, WM_VSCROLL, SB_LINEUP, 0);
				} else {
					// zC[Oɓ̏
					SendMessage( hWnd, WM_VSCROLL, SB_LINEDOWN, 0);
				}
			}
			break;
        default:
            return(DefWindowProc(hWnd, msg, wParam, lParam));
    }
    return 0;
}




int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
    HWND hWnd;
    MSG msg;
    WNDCLASS myProg;
	g_hInst = hInstance;

	timeBeginPeriod(1);

    if (!hPrevInstance) {
        myProg.style            =CS_HREDRAW | CS_VREDRAW;
        myProg.lpfnWndProc        =WndProc;
        myProg.cbClsExtra        =0;
        myProg.cbWndExtra        =0;
        myProg.hInstance        =hPrevInstance;
        myProg.hIcon            =NULL;
        myProg.hCursor            =LoadCursor(NULL, IDC_ARROW);
        //myProg.hbrBackground    =(HBRUSH)GetStockObject(WHITE_BRUSH);
		myProg.hbrBackground    =(HBRUSH)GetStockObject(NULL_BRUSH);
        //myProg.lpszMenuName        ="IDR_MENU2";
		myProg.lpszMenuName        =MAKEINTRESOURCE(IDR_MENU2);
        myProg.lpszClassName    = WINDOW_CLASS_NAME;
        if (!RegisterClass(&myProg))
            return FALSE;


		myProg.style            =CS_HREDRAW | CS_VREDRAW;
        myProg.lpfnWndProc      =ListWndProc;
        myProg.cbClsExtra       =0;
        myProg.cbWndExtra       =0;
        myProg.hInstance        =hPrevInstance;
        myProg.hIcon            =NULL;
        myProg.hCursor          =LoadCursor(NULL, IDC_ARROW);
        //myProg.hbrBackground  =(HBRUSH)GetStockObject(WHITE_BRUSH);
		myProg.hbrBackground    =(HBRUSH)GetStockObject(NULL_BRUSH);
		myProg.lpszMenuName     = NULL;
        myProg.lpszClassName    = LIST_WINDOW_CLASS_NAME;
        if (!RegisterClass(&myProg))
            return FALSE;
    }
    hWnd = CreateWindow(WINDOW_CLASS_NAME,
        "docmi view",
        WS_OVERLAPPEDWINDOW | WS_VSCROLL | WS_HSCROLL,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        hInstance,
        NULL);
    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);

	/*

	HWND hListWnd = CreateWindow(LIST_WINDOW_CLASS_NAME,
        "摜Xg",
        //WS_OVERLAPPEDWINDOW | WS_VSCROLL | WS_HSCROLL,
		//WS_OVERLAPPED | WS_THICKFRAME,
		WS_CHILD,
        0,
        0,
        100,
        100,
        hWnd,
        NULL,
        hInstance,
        NULL);
    ShowWindow(hListWnd, nCmdShow);
    UpdateWindow(hListWnd);
	*/

    while (GetMessage(&msg, NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

	_CrtDumpMemoryLeaks( );

    return (msg.wParam);
}
