// DicomFile.cpp: DicomFile NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

//#include "stdafx.h"
#include "Element.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
using namespace docmi;

/** V[PX^OɊ܂܂V[PXivfWjԂ
 *
 */
const Sequence* Element::getSequence( u_int index ) const
{
	if( index < m_sequences.size() ){
		return &m_sequences[index];
	}

	return NULL;
}


/** vf̃Rs[
 */
void Element::copy( const Element& rhs )
{
	m_group_id = rhs.m_group_id;
	m_element_id = rhs.m_element_id;
	m_sequences.resize( rhs.m_sequences.size() );
	std::copy( rhs.m_sequences.begin(), rhs.m_sequences.end(), m_sequences.begin() );
}

struct VrDictionary
{
	u_short groupID;
	u_short elementID;
	char    vr[4];
};

static VrDictionary g_dic[] =
{
	{0x0002, 0x0000, "UL" },
	{0x0002, 0x0001, "OB" },
	{0x0002, 0x0002, "UI" },
	{0x0002, 0x0003, "UI" },
	{0x0002, 0x0010, "UI" },
	{0x0002, 0x0012, "UI" },
	{0x0002, 0x0013, "SH" },
	{0x0002, 0x0016, "AE" },
	{0x0002, 0x0100, "UI" },
	{0x0002, 0x0102, "OB" },
	{0x0004, 0x0000, "UL" },
	{0x0004, 0x1130, "CS" },
	{0x0004, 0x1141, "CS" },
	{0x0004, 0x1142, "CS" },
	{0x0004, 0x1200, "UL" },
	{0x0004, 0x1202, "UL" },
	{0x0004, 0x1212, "US" },
	{0x0004, 0x1220, "SQ" },
	{0x0004, 0x1400, "UL" },
	{0x0004, 0x1410, "US" },
	{0x0004, 0x1420, "UL" },
	{0x0004, 0x1430, "CS" },
	{0x0004, 0x1432, "UI" },
	{0x0004, 0x1500, "CS" },
	{0x0004, 0x1504, "UL" },
	{0x0004, 0x1510, "UI" },
	{0x0004, 0x1511, "UI" },
	{0x0004, 0x1512, "UI" },
	{0x0004, 0x1600, "UL" },
	{0x0008, 0x0000, "UL" },
	{0x0008, 0x0001, "UN" },
	{0x0008, 0x0005, "CS" },
	{0x0008, 0x0008, "CS" },
	{0x0008, 0x0010, "UN" },
	{0x0008, 0x0012, "DA" },
	{0x0008, 0x0013, "TM" },
	{0x0008, 0x0014, "UI" },
	{0x0008, 0x0016, "UI" },
	{0x0008, 0x0018, "UI" },
	{0x0008, 0x0020, "DA" },
	{0x0008, 0x0021, "DA" },
	{0x0008, 0x0022, "DA" },
	{0x0008, 0x0023, "DA" },
	{0x0008, 0x0024, "DA" },
	{0x0008, 0x0025, "DA" },
	{0x0008, 0x002A, "DT" },
	{0x0008, 0x0030, "TM" },
	{0x0008, 0x0031, "TM" },
	{0x0008, 0x0032, "TM" },
	{0x0008, 0x0033, "TM" },
	{0x0008, 0x0034, "TM" },
	{0x0008, 0x0035, "TM" },
	{0x0008, 0x0040, "UN" },
	{0x0008, 0x0041, "UN" },
	{0x0008, 0x0042, "CS" },
	{0x0008, 0x0050, "SH" },
	{0x0008, 0x0052, "CS" },
	{0x0008, 0x0054, "AE" },
	{0x0008, 0x0056, "CS" },
	{0x0008, 0x0058, "UI" },
	{0x0008, 0x0060, "CS" },
	{0x0008, 0x0061, "CS" },
	{0x0008, 0x0064, "CS" },
	{0x0008, 0x0068, "CS" },
	{0x0008, 0x0070, "LO" },
	{0x0008, 0x0080, "LO" },
	{0x0008, 0x0081, "ST" },
	{0x0008, 0x0082, "SQ" },
	{0x0008, 0x0090, "PN" },
	{0x0008, 0x0092, "ST" },
	{0x0008, 0x0094, "SH" },
	{0x0008, 0x0096, "SQ" },
	{0x0008, 0x0100, "SH" },
	{0x0008, 0x0102, "SH" },
	{0x0008, 0x0103, "SH" },
	{0x0008, 0x0104, "LO" },
	{0x0008, 0x0105, "CS" },
	{0x0008, 0x0106, "DT" },
	{0x0008, 0x0107, "DT" },
	{0x0008, 0x010B, "CS" },
	{0x0008, 0x010C, "UI" },
	{0x0008, 0x010D, "UI" },
	{0x0008, 0x010F, "CS" },
	{0x0008, 0x0110, "SQ" },
	{0x0008, 0x0112, "LO" },
	{0x0008, 0x0114, "ST" },
	{0x0008, 0x0115, "ST" },
	{0x0008, 0x0116, "ST" },
	{0x0008, 0x0201, "SH" },
	{0x0008, 0x1000, "UN" },
	{0x0008, 0x1010, "SH" },
	{0x0008, 0x1030, "LO" },
	{0x0008, 0x1032, "SQ" },
	{0x0008, 0x103E, "LO" },
	{0x0008, 0x1040, "LO" },
	{0x0008, 0x1048, "PN" },
	{0x0008, 0x1049, "SQ" },
	{0x0008, 0x1050, "PN" },
	{0x0008, 0x1052, "SQ" },
	{0x0008, 0x1060, "PN" },
	{0x0008, 0x1062, "SQ" },
	{0x0008, 0x1070, "PN" },
	{0x0008, 0x1072, "SQ" },
	{0x0008, 0x1080, "LO" },
	{0x0008, 0x1084, "SQ" },
	{0x0008, 0x1090, "LO" },
	{0x0008, 0x1100, "SQ" },
	{0x0008, 0x1110, "SQ" },
	{0x0008, 0x1111, "SQ" },
	{0x0008, 0x1115, "SQ" },
	{0x0008, 0x1120, "SQ" },
	{0x0008, 0x1125, "SQ" },
	{0x0008, 0x1130, "SQ" },
	{0x0008, 0x113A, "SQ" },
	{0x0008, 0x1140, "SQ" },
	{0x0008, 0x1145, "SQ" },
	{0x0008, 0x114A, "SQ" },
	{0x0008, 0x1150, "UI" },
	{0x0008, 0x1155, "UI" },
	{0x0008, 0x115A, "UI" },
	{0x0008, 0x1160, "IS" },
	{0x0008, 0x1195, "UI" },
	{0x0008, 0x1197, "US" },
	{0x0008, 0x1198, "SQ" },
	{0x0008, 0x1199, "SQ" },
	{0x0008, 0x2110, "CS" },
	{0x0008, 0x2111, "ST" },
	{0x0008, 0x2112, "SQ" },
	{0x0008, 0x2120, "SH" },
	{0x0008, 0x2122, "IS" },
	{0x0008, 0x2124, "IS" },
	{0x0008, 0x2127, "SH" },
	{0x0008, 0x2128, "IS" },
	{0x0008, 0x2129, "IS" },
	{0x0008, 0x212A, "IS" },
	{0x0008, 0x2130, "DS" },
	{0x0008, 0x2132, "LO" },
	{0x0008, 0x2142, "IS" },
	{0x0008, 0x2143, "IS" },
	{0x0008, 0x2144, "IS" },
	{0x0008, 0x2200, "CS" },
	{0x0008, 0x2204, "CS" },
	{0x0008, 0x2208, "CS" },
	{0x0008, 0x2218, "SQ" },
	{0x0008, 0x2220, "SQ" },
	{0x0008, 0x2228, "SQ" },
	{0x0008, 0x2229, "SQ" },
	{0x0008, 0x2230, "SQ" },
	{0x0008, 0x2240, "SQ" },
	{0x0008, 0x2242, "SQ" },
	{0x0008, 0x2244, "SQ" },
	{0x0008, 0x2246, "SQ" },
	{0x0008, 0x4000, "UN" },
	{0x0008, 0x9007, "CS" },
	{0x0008, 0x9092, "SQ" },
	{0x0008, 0x9121, "SQ" },
	{0x0008, 0x9123, "UI" },
	{0x0008, 0x9124, "SQ" },
	{0x0008, 0x9154, "SQ" },
	{0x0008, 0x9205, "CS" },
	{0x0008, 0x9206, "CS" },
	{0x0008, 0x9207, "CS" },
	{0x0008, 0x9208, "CS" },
	{0x0008, 0x9209, "CS" },
	{0x0008, 0x9215, "SQ" },
	{0x0008, 0x9237, "SQ" },
	{0x0010, 0x0000, "UL" },
	{0x0010, 0x0010, "PN" },
	{0x0010, 0x0020, "LO" },
	{0x0010, 0x0021, "LO" },
	{0x0010, 0x0030, "DA" },
	{0x0010, 0x0032, "TM" },
	{0x0010, 0x0040, "CS" },
	{0x0010, 0x0050, "SQ" },
	{0x0010, 0x0101, "SQ" },
	{0x0010, 0x0102, "SQ" },
	{0x0010, 0x1000, "LO" },
	{0x0010, 0x1001, "PN" },
	{0x0010, 0x1005, "PN" },
	{0x0010, 0x1010, "AS" },
	{0x0010, 0x1020, "DS" },
	{0x0010, 0x1030, "DS" },
	{0x0010, 0x1040, "LO" },
	{0x0010, 0x1050, "UN" },
	{0x0010, 0x1060, "PN" },
	{0x0010, 0x1080, "LO" },
	{0x0010, 0x1081, "LO" },
	{0x0010, 0x1090, "LO" },
	{0x0010, 0x2000, "LO" },
	{0x0010, 0x2110, "LO" },
	{0x0010, 0x2150, "LO" },
	{0x0010, 0x2152, "LO" },
	{0x0010, 0x2154, "SH" },
	{0x0010, 0x2160, "SH" },
	{0x0010, 0x2180, "SH" },
	{0x0010, 0x21A0, "CS" },
	{0x0010, 0x21B0, "LT" },
	{0x0010, 0x21C0, "US" },
	{0x0010, 0x21D0, "DA" },
	{0x0010, 0x21F0, "LO" },
	{0x0010, 0x4000, "LT" },
	{0x0012, 0x0000, "UL" },
	{0x0012, 0x0010, "LO" },
	{0x0012, 0x0020, "LO" },
	{0x0012, 0x0021, "LO" },
	{0x0012, 0x0030, "LO" },
	{0x0012, 0x0031, "LO" },
	{0x0012, 0x0040, "LO" },
	{0x0012, 0x0042, "LO" },
	{0x0012, 0x0050, "LO" },
	{0x0012, 0x0051, "ST" },
	{0x0012, 0x0060, "LO" },
	{0x0018, 0x0000, "UL" },
	{0x0018, 0x0010, "LO" },
	{0x0018, 0x0012, "SQ" },
	{0x0018, 0x0014, "SQ" },
	{0x0018, 0x0015, "CS" },
	{0x0018, 0x0020, "CS" },
	{0x0018, 0x0021, "CS" },
	{0x0018, 0x0022, "CS" },
	{0x0018, 0x0023, "CS" },
	{0x0018, 0x0024, "SH" },
	{0x0018, 0x0025, "CS" },
	{0x0018, 0x0026, "SQ" },
	{0x0018, 0x0027, "TM" },
	{0x0018, 0x0028, "DS" },
	{0x0018, 0x0029, "SQ" },
	{0x0018, 0x002A, "SQ" },
	{0x0018, 0x0030, "LO" },
	{0x0018, 0x0031, "LO" },
	{0x0018, 0x0032, "DS" },
	{0x0018, 0x0033, "DS" },
	{0x0018, 0x0034, "LO" },
	{0x0018, 0x0035, "TM" },
	{0x0018, 0x0036, "SQ" },
	{0x0018, 0x0037, "CS" },
	{0x0018, 0x0038, "CS" },
	{0x0018, 0x0039, "CS" },
	{0x0018, 0x0040, "IS" },
	{0x0018, 0x0050, "DS" },
	{0x0018, 0x0060, "DS" },
	{0x0018, 0x0070, "IS" },
	{0x0018, 0x0071, "CS" },
	{0x0018, 0x0072, "DS" },
	{0x0018, 0x0073, "CS" },
	{0x0018, 0x0074, "IS" },
	{0x0018, 0x0075, "IS" },
	{0x0018, 0x0080, "DS" },
	{0x0018, 0x0081, "DS" },
	{0x0018, 0x0082, "DS" },
	{0x0018, 0x0083, "DS" },
	{0x0018, 0x0084, "DS" },
	{0x0018, 0x0085, "SH" },
	{0x0018, 0x0086, "IS" },
	{0x0018, 0x0087, "DS" },
	{0x0018, 0x0088, "DS" },
	{0x0018, 0x0089, "IS" },
	{0x0018, 0x0090, "DS" },
	{0x0018, 0x0091, "IS" },
	{0x0018, 0x0093, "DS" },
	{0x0018, 0x0094, "DS" },
	{0x0018, 0x0095, "DS" },
	{0x0018, 0x1000, "LO" },
	{0x0018, 0x1004, "LO" },
	{0x0018, 0x1010, "LO" },
	{0x0018, 0x1011, "LO" },
	{0x0018, 0x1012, "DA" },
	{0x0018, 0x1014, "TM" },
	{0x0018, 0x1016, "LO" },
	{0x0018, 0x1017, "LO" },
	{0x0018, 0x1018, "LO" },
	{0x0018, 0x1019, "LO" },
	{0x0018, 0x101A, "LO" },
	{0x0018, 0x101B, "LO" },
	{0x0018, 0x1020, "LO" },
	{0x0018, 0x1022, "SH" },
	{0x0018, 0x1023, "LO" },
	{0x0018, 0x1030, "LO" },
	{0x0018, 0x1040, "LO" },
	{0x0018, 0x1041, "DS" },
	{0x0018, 0x1042, "TM" },
	{0x0018, 0x1043, "TM" },
	{0x0018, 0x1044, "DS" },
	{0x0018, 0x1045, "IS" },
	{0x0018, 0x1046, "DS" },
	{0x0018, 0x1047, "DS" },
	{0x0018, 0x1048, "CS" },
	{0x0018, 0x1049, "DS" },
	{0x0018, 0x1050, "DS" },
	{0x0018, 0x1060, "DS" },
	{0x0018, 0x1061, "LO" },
	{0x0018, 0x1062, "IS" },
	{0x0018, 0x1063, "DS" },
	{0x0018, 0x1064, "LO" },
	{0x0018, 0x1065, "DS" },
	{0x0018, 0x1066, "DS" },
	{0x0018, 0x1067, "DS" },
	{0x0018, 0x1068, "DS" },
	{0x0018, 0x1069, "DS" },
	{0x0018, 0x106A, "CS" },
	{0x0018, 0x106C, "US" },
	{0x0018, 0x106E, "UL" },
	{0x0018, 0x1070, "LO" },
	{0x0018, 0x1071, "DS" },
	{0x0018, 0x1072, "TM" },
	{0x0018, 0x1073, "TM" },
	{0x0018, 0x1074, "DS" },
	{0x0018, 0x1075, "DS" },
	{0x0018, 0x1076, "DS" },
	{0x0018, 0x1077, "DS" },
	{0x0018, 0x1080, "CS" },
	{0x0018, 0x1081, "IS" },
	{0x0018, 0x1082, "IS" },
	{0x0018, 0x1083, "IS" },
	{0x0018, 0x1084, "IS" },
	{0x0018, 0x1085, "LO" },
	{0x0018, 0x1086, "IS" },
	{0x0018, 0x1088, "IS" },
	{0x0018, 0x1090, "IS" },
	{0x0018, 0x1094, "IS" },
	{0x0018, 0x1100, "DS" },
	{0x0018, 0x1110, "DS" },
	{0x0018, 0x1111, "DS" },
	{0x0018, 0x1114, "DS" },
	{0x0018, 0x1120, "DS" },
	{0x0018, 0x1121, "DS" },
	{0x0018, 0x1130, "DS" },
	{0x0018, 0x1131, "DS" },
	{0x0018, 0x1134, "CS" },
	{0x0018, 0x1135, "DS" },
	{0x0018, 0x1136, "DS" },
	{0x0018, 0x1137, "DS" },
	{0x0018, 0x1138, "DS" },
	{0x0018, 0x113A, "CS" },
	{0x0018, 0x1140, "CS" },
	{0x0018, 0x1141, "DS" },
	{0x0018, 0x1142, "DS" },
	{0x0018, 0x1143, "DS" },
	{0x0018, 0x1144, "DS" },
	{0x0018, 0x1145, "DS" },
	{0x0018, 0x1146, "DS" },
	{0x0018, 0x1147, "CS" },
	{0x0018, 0x1149, "IS" },
	{0x0018, 0x1150, "IS" },
	{0x0018, 0x1151, "IS" },
	{0x0018, 0x1152, "IS" },
	{0x0018, 0x1153, "IS" },
	{0x0018, 0x1154, "DS" },
	{0x0018, 0x1155, "CS" },
	{0x0018, 0x1156, "CS" },
	{0x0018, 0x115A, "CS" },
	{0x0018, 0x115E, "DS" },
	{0x0018, 0x1160, "SH" },
	{0x0018, 0x1161, "LO" },
	{0x0018, 0x1162, "DS" },
	{0x0018, 0x1164, "DS" },
	{0x0018, 0x1166, "CS" },
	{0x0018, 0x1170, "IS" },
	{0x0018, 0x1180, "SH" },
	{0x0018, 0x1181, "CS" },
	{0x0018, 0x1182, "IS" },
	{0x0018, 0x1183, "DS" },
	{0x0018, 0x1184, "DS" },
	{0x0018, 0x1190, "DS" },
	{0x0018, 0x1191, "CS" },
	{0x0018, 0x11A0, "DS" },
	{0x0018, 0x11A2, "DS" },
	{0x0018, 0x1200, "DA" },
	{0x0018, 0x1201, "TM" },
	{0x0018, 0x1210, "SH" },
	{0x0018, 0x1240, "UN" },
	{0x0018, 0x1242, "IS" },
	{0x0018, 0x1243, "IS" },
	{0x0018, 0x1244, "US" },
	{0x0018, 0x1250, "SH" },
	{0x0018, 0x1251, "SH" },
	{0x0018, 0x1260, "SH" },
	{0x0018, 0x1261, "LO" },
	{0x0018, 0x1300, "DS" },
	{0x0018, 0x1301, "CS" },
	{0x0018, 0x1302, "IS" },
	{0x0018, 0x1310, "US" },
	{0x0018, 0x1312, "CS" },
	{0x0018, 0x1314, "DS" },
	{0x0018, 0x1315, "CS" },
	{0x0018, 0x1316, "DS" },
	{0x0018, 0x1318, "DS" },
	{0x0018, 0x1400, "LO" },
	{0x0018, 0x1401, "LO" },
	{0x0018, 0x1402, "CS" },
	{0x0018, 0x1403, "CS" },
	{0x0018, 0x1404, "US" },
	{0x0018, 0x1405, "IS" },
	{0x0018, 0x1450, "DS" },
	{0x0018, 0x1460, "DS" },
	{0x0018, 0x1470, "DS" },
	{0x0018, 0x1480, "DS" },
	{0x0018, 0x1490, "CS" },
	{0x0018, 0x1491, "CS" },
	{0x0018, 0x1495, "IS" },
	{0x0018, 0x1500, "CS" },
	{0x0018, 0x1508, "CS" },
	{0x0018, 0x1510, "DS" },
	{0x0018, 0x1511, "DS" },
	{0x0018, 0x1520, "DS" },
	{0x0018, 0x1521, "DS" },
	{0x0018, 0x1530, "DS" },
	{0x0018, 0x1531, "DS" },
	{0x0018, 0x1600, "CS" },
	{0x0018, 0x1602, "IS" },
	{0x0018, 0x1604, "IS" },
	{0x0018, 0x1606, "IS" },
	{0x0018, 0x1608, "IS" },
	{0x0018, 0x1610, "IS" },
	{0x0018, 0x1612, "IS" },
	{0x0018, 0x1620, "IS" },
	{0x0018, 0x1622, "US" },
	{0x0018, 0x1623, "US" },
	{0x0018, 0x1700, "CS" },
	{0x0018, 0x1702, "IS" },
	{0x0018, 0x1704, "IS" },
	{0x0018, 0x1706, "IS" },
	{0x0018, 0x1708, "IS" },
	{0x0018, 0x1710, "IS" },
	{0x0018, 0x1712, "IS" },
	{0x0018, 0x1720, "IS" },
	{0x0018, 0x1800, "CS" },
	{0x0018, 0x1801, "SH" },
	{0x0018, 0x1802, "CS" },
	{0x0018, 0x2001, "IS" },
	{0x0018, 0x2002, "SH" },
	{0x0018, 0x2003, "DS" },
	{0x0018, 0x2004, "DS" },
	{0x0018, 0x2005, "DS" },
	{0x0018, 0x2006, "SH" },
	{0x0018, 0x2010, "DS" },
	{0x0018, 0x2020, "CS" },
	{0x0018, 0x2030, "DS" },
	{0x0018, 0x3100, "CS" },
	{0x0018, 0x3101, "DS" },
	{0x0018, 0x3102, "DS" },
	{0x0018, 0x3103, "IS" },
	{0x0018, 0x3104, "IS" },
	{0x0018, 0x3105, "IS" },
	{0x0018, 0x4000, "UN" },
	{0x0018, 0x5000, "SH" },
	{0x0018, 0x5010, "LO" },
	{0x0018, 0x5012, "DS" },
	{0x0018, 0x5020, "LO" },
	{0x0018, 0x5021, "LO" },
	{0x0018, 0x5022, "DS" },
	{0x0018, 0x5024, "DS" },
	{0x0018, 0x5026, "DS" },
	{0x0018, 0x5027, "DS" },
	{0x0018, 0x5028, "DS" },
	{0x0018, 0x5029, "DS" },
	{0x0018, 0x5030, "UN" },
	{0x0018, 0x5040, "UN" },
	{0x0018, 0x5050, "IS" },
	{0x0018, 0x5100, "CS" },
	{0x0018, 0x5101, "CS" },
	{0x0018, 0x5104, "SQ" },
	{0x0018, 0x5210, "DS" },
	{0x0018, 0x5212, "DS" },
	{0x0018, 0x6000, "DS" },
	{0x0018, 0x6011, "SQ" },
	{0x0018, 0x6012, "US" },
	{0x0018, 0x6014, "US" },
	{0x0018, 0x6016, "UL" },
	{0x0018, 0x6018, "UL" },
	{0x0018, 0x601A, "UL" },
	{0x0018, 0x601C, "UL" },
	{0x0018, 0x601E, "UL" },
	{0x0018, 0x6020, "SL" },
	{0x0018, 0x6022, "SL" },
	{0x0018, 0x6024, "US" },
	{0x0018, 0x6026, "US" },
	{0x0018, 0x6028, "FD" },
	{0x0018, 0x602A, "FD" },
	{0x0018, 0x602C, "FD" },
	{0x0018, 0x602E, "FD" },
	{0x0018, 0x6030, "UL" },
	{0x0018, 0x6031, "CS" },
	{0x0018, 0x6032, "UL" },
	{0x0018, 0x6034, "FD" },
	{0x0018, 0x6036, "FD" },
	{0x0018, 0x6038, "UL" },
	{0x0018, 0x6039, "SL" },
	{0x0018, 0x603A, "UL" },
	{0x0018, 0x603B, "SL" },
	{0x0018, 0x603C, "UL" },
	{0x0018, 0x603D, "SL" },
	{0x0018, 0x603E, "UL" },
	{0x0018, 0x603F, "SL" },
	{0x0018, 0x6040, "UL" },
	{0x0018, 0x6041, "SL" },
	{0x0018, 0x6042, "UL" },
	{0x0018, 0x6043, "SL" },
	{0x0018, 0x6044, "US" },
	{0x0018, 0x6046, "UL" },
	{0x0018, 0x6048, "UL" },
	{0x0018, 0x604A, "UL" },
	{0x0018, 0x604C, "US" },
	{0x0018, 0x604E, "US" },
	{0x0018, 0x6050, "UL" },
	{0x0018, 0x6052, "UL" },
	{0x0018, 0x6054, "FD" },
	{0x0018, 0x6056, "UL" },
	{0x0018, 0x6058, "UL" },
	{0x0018, 0x605A, "FL" },
	{0x0018, 0x7000, "CS" },
	{0x0018, 0x7001, "DS" },
	{0x0018, 0x7004, "CS" },
	{0x0018, 0x7005, "CS" },
	{0x0018, 0x7006, "LT" },
	{0x0018, 0x7008, "LT" },
	{0x0018, 0x700A, "SH" },
	{0x0018, 0x700C, "DA" },
	{0x0018, 0x700E, "TM" },
	{0x0018, 0x7010, "IS" },
	{0x0018, 0x7011, "IS" },
	{0x0018, 0x7012, "DS" },
	{0x0018, 0x7014, "DS" },
	{0x0018, 0x7016, "DS" },
	{0x0018, 0x701A, "DS" },
	{0x0018, 0x7020, "DS" },
	{0x0018, 0x7022, "DS" },
	{0x0018, 0x7024, "CS" },
	{0x0018, 0x7026, "DS" },
	{0x0018, 0x7028, "DS" },
	{0x0018, 0x7030, "DS" },
	{0x0018, 0x7032, "DS" },
	{0x0018, 0x7034, "CS" },
	{0x0018, 0x7040, "LT" },
	{0x0018, 0x7041, "LT" },
	{0x0018, 0x7042, "DS" },
	{0x0018, 0x7044, "DS" },
	{0x0018, 0x7046, "IS" },
	{0x0018, 0x7048, "DS" },
	{0x0018, 0x704C, "DS" },
	{0x0018, 0x7050, "CS" },
	{0x0018, 0x7052, "DS" },
	{0x0018, 0x7054, "DS" },
	{0x0018, 0x7060, "CS" },
	{0x0018, 0x7062, "LT" },
	{0x0018, 0x7064, "CS" },
	{0x0018, 0x7065, "DS" },
	{0x0018, 0x8150, "DS" },
	{0x0018, 0x8151, "DS" },
	{0x0018, 0x9004, "CS" },
	{0x0018, 0x9005, "SH" },
	{0x0018, 0x9006, "SQ" },
	{0x0018, 0x9008, "CS" },
	{0x0018, 0x9009, "CS" },
	{0x0018, 0x9010, "CS" },
	{0x0018, 0x9011, "CS" },
	{0x0018, 0x9012, "CS" },
	{0x0018, 0x9014, "CS" },
	{0x0018, 0x9015, "CS" },
	{0x0018, 0x9016, "CS" },
	{0x0018, 0x9017, "CS" },
	{0x0018, 0x9018, "CS" },
	{0x0018, 0x9019, "FD" },
	{0x0018, 0x9020, "CS" },
	{0x0018, 0x9021, "CS" },
	{0x0018, 0x9022, "CS" },
	{0x0018, 0x9022, "CS" },
	{0x0018, 0x9024, "CS" },
	{0x0018, 0x9025, "CS" },
	{0x0018, 0x9026, "CS" },
	{0x0018, 0x9027, "CS" },
	{0x0018, 0x9028, "CS" },
	{0x0018, 0x9029, "CS" },
	{0x0018, 0x9030, "FD" },
	{0x0018, 0x9032, "CS" },
	{0x0018, 0x9033, "CS" },
	{0x0018, 0x9034, "CS" },
	{0x0018, 0x9035, "FD" },
	{0x0018, 0x9036, "CS" },
	{0x0018, 0x9037, "CS" },
	{0x0018, 0x9041, "LO" },
	{0x0018, 0x9042, "SQ" },
	{0x0018, 0x9043, "CS" },
	{0x0018, 0x9044, "CS" },
	{0x0018, 0x9045, "SQ" },
	{0x0018, 0x9046, "LO" },
	{0x0018, 0x9047, "SH" },
	{0x0018, 0x9048, "CS" },
	{0x0018, 0x9049, "SQ" },
	{0x0018, 0x9050, "LO" },
	{0x0018, 0x9051, "CS" },
	{0x0018, 0x9052, "FD" },
	{0x0018, 0x9053, "FD" },
	{0x0018, 0x9054, "CS" },
	{0x0018, 0x9058, "US" },
	{0x0018, 0x9059, "CS" },
	{0x0018, 0x9060, "CS" },
	{0x0018, 0x9061, "FD" },
	{0x0018, 0x9062, "CS" },
	{0x0018, 0x9063, "FD" },
	{0x0018, 0x9064, "CS" },
	{0x0018, 0x9065, "CS" },
	{0x0018, 0x9066, "US" },
	{0x0018, 0x9067, "CS" },
	{0x0018, 0x9069, "FD" },
	{0x0018, 0x9070, "FD" },
	{0x0018, 0x9073, "FD" },
	{0x0018, 0x9074, "DT" },
	{0x0018, 0x9075, "CS" },
	{0x0018, 0x9076, "SQ" },
	{0x0018, 0x9077, "CS" },
	{0x0018, 0x9078, "CS" },
	{0x0018, 0x9079, "FD" },
	{0x0018, 0x9080, "ST" },
	{0x0018, 0x9081, "CS" },
	{0x0018, 0x9082, "FD" },
	{0x0018, 0x9084, "SQ" },
	{0x0018, 0x9085, "CS" },
	{0x0018, 0x9087, "FD" },
	{0x0018, 0x9089, "FD" },
	{0x0018, 0x9090, "FD" },
	{0x0018, 0x9091, "FD" },
	{0x0018, 0x9093, "US" },
	{0x0018, 0x9094, "CS" },
	{0x0018, 0x9095, "UL" },
	{0x0018, 0x9098, "FD" },
	{0x0018, 0x9100, "CS" },
	{0x0018, 0x9101, "CS" },
	{0x0018, 0x9103, "SQ" },
	{0x0018, 0x9104, "FD" },
	{0x0018, 0x9105, "FD" },
	{0x0018, 0x9106, "FD" },
	{0x0018, 0x9107, "SQ" },
	{0x0018, 0x9112, "SQ" },
	{0x0018, 0x9114, "SQ" },
	{0x0018, 0x9115, "SQ" },
	{0x0018, 0x9117, "SQ" },
	{0x0018, 0x9118, "SQ" },
	{0x0018, 0x9119, "SQ" },
	{0x0018, 0x9125, "SQ" },
	{0x0018, 0x9126, "SQ" },
	{0x0018, 0x9127, "UL" },
	{0x0018, 0x9147, "CS" },
	{0x0018, 0x9151, "DT" },
	{0x0018, 0x9152, "SQ" },
	{0x0018, 0x9155, "FD" },
	{0x0018, 0x9159, "UL" },
	{0x0018, 0x9166, "CS" },
	{0x0018, 0x9168, "FD" },
	{0x0018, 0x9169, "CS" },
	{0x0018, 0x9170, "CS" },
	{0x0018, 0x9171, "CS" },
	{0x0018, 0x9172, "CS" },
	{0x0018, 0x9173, "CS" },
	{0x0018, 0x9174, "CS" },
	{0x0018, 0x9175, "LO" },
	{0x0018, 0x9176, "SQ" },
	{0x0018, 0x9177, "CS" },
	{0x0018, 0x9178, "CS" },
	{0x0018, 0x9179, "CS" },
	{0x0018, 0x9180, "CS" },
	{0x0018, 0x9181, "FD" },
	{0x0018, 0x9182, "FD" },
	{0x0018, 0x9183, "CS" },
	{0x0018, 0x9184, "FD" },
	{0x0018, 0x9195, "FD" },
	{0x0018, 0x9196, "FD" },
	{0x0018, 0x9197, "SQ" },
	{0x0018, 0x9198, "CS" },
	{0x0018, 0x9199, "CS" },
	{0x0018, 0x9200, "CS" },
	{0x0018, 0x9214, "CS" },
	{0x0018, 0x9217, "FD" },
	{0x0018, 0x9218, "SS" },
	{0x0018, 0x9219, "SS" },
	{0x0018, 0x9220, "FD" },
	{0x0018, 0x9226, "SQ" },
	{0x0018, 0x9227, "SQ" },
	{0x0018, 0x9231, "US" },
	{0x0018, 0x9232, "US" },
	{0x0018, 0x9234, "UL" },
	{0x0018, 0x9236, "CS" },
	{0x0018, 0x9239, "SQ" },
	{0x0018, 0xA001, "SQ" },
	{0x0018, 0xA002, "DT" },
	{0x0018, 0xA003, "ST" },
	{0x0020, 0x0000, "UL" },
	{0x0020, 0x000D, "UI" },
	{0x0020, 0x000E, "UI" },
	{0x0020, 0x0010, "SH" },
	{0x0020, 0x0011, "IS" },
	{0x0020, 0x0012, "IS" },
	{0x0020, 0x0013, "IS" },
	{0x0020, 0x0014, "IS" },
	{0x0020, 0x0015, "IS" },
	{0x0020, 0x0016, "IS" },
	{0x0020, 0x0017, "IS" },
	{0x0020, 0x0018, "IS" },
	{0x0020, 0x0019, "IS" },
	{0x0020, 0x0020, "CS" },
	{0x0020, 0x0022, "IS" },
	{0x0020, 0x0024, "IS" },
	{0x0020, 0x0026, "IS" },
	{0x0020, 0x0030, "UN" },
	{0x0020, 0x0032, "DS" },
	{0x0020, 0x0035, "UN" },
	{0x0020, 0x0037, "DS" },
	{0x0020, 0x0050, "UN" },
	{0x0020, 0x0052, "UI" },
	{0x0020, 0x0060, "CS" },
	{0x0020, 0x0062, "CS" },
	{0x0020, 0x0070, "UN" },
	{0x0020, 0x0080, "UN" },
	{0x0020, 0x0100, "IS" },
	{0x0020, 0x0105, "IS" },
	{0x0020, 0x0110, "DS" },
	{0x0020, 0x0200, "UI" },
	{0x0020, 0x1000, "IS" },
	{0x0020, 0x1001, "in" },
	{0x0020, 0x1002, "IS" },
	{0x0020, 0x1004, "IS" },
	{0x0020, 0x1020, "UN" },
	{0x0020, 0x1040, "LO" },
	{0x0020, 0x1041, "DS" },
	{0x0020, 0x1070, "IS" },
	{0x0020, 0x1200, "IS" },
	{0x0020, 0x1202, "IS" },
	{0x0020, 0x1204, "IS" },
	{0x0020, 0x1206, "IS" },
	{0x0020, 0x1208, "IS" },
	{0x0020, 0x1209, "IS" },
	{0x0020, 0x3100, "UN" },
	{0x0020, 0x3401, "UN" },
	{0x0020, 0x3402, "UN" },
	{0x0020, 0x3403, "UN" },
	{0x0020, 0x3404, "UN" },
	{0x0020, 0x3405, "UN" },
	{0x0020, 0x3406, "UN" },
	{0x0020, 0x4000, "LT" },
	{0x0020, 0x5000, "UN" },
	{0x0020, 0x5002, "UN" },
	{0x0020, 0x9056, "SH" },
	{0x0020, 0x9057, "UL" },
	{0x0020, 0x9071, "SQ" },
	{0x0020, 0x9072, "CS" },
	{0x0020, 0x9111, "SQ" },
	{0x0020, 0x9113, "SQ" },
	{0x0020, 0x9116, "SQ" },
	{0x0020, 0x9128, "UL" },
	{0x0020, 0x9153, "FD" },
	{0x0020, 0x9156, "US" },
	{0x0020, 0x9157, "UL" },
	{0x0020, 0x9158, "LT" },
	{0x0020, 0x9161, "UI" },
	{0x0020, 0x9162, "US" },
	{0x0020, 0x9163, "US" },
	{0x0020, 0x9164, "UI" },
	{0x0020, 0x9165, "AT" },
	{0x0020, 0x9167, "AT" },
	{0x0020, 0x9213, "LO" },
	{0x0020, 0x9221, "SQ" },
	{0x0020, 0x9222, "SQ" },
	{0x0020, 0x9228, "UL" },
	{0x0020, 0x9238, "LO" },
	{0x0028, 0x0002, "US" },
	{0x0028, 0x0004, "CS" },
	{0x0028, 0x0005, "UN" },
	{0x0028, 0x0006, "US" },
	{0x0028, 0x0008, "IS" },
	{0x0028, 0x0009, "AT" },
	{0x0028, 0x0010, "US" },
	{0x0028, 0x0011, "US" },
	{0x0028, 0x0012, "US" },
	{0x0028, 0x0014, "US" },
	{0x0028, 0x0030, "DS" },
	{0x0028, 0x0031, "DS" },
	{0x0028, 0x0032, "DS" },
	{0x0028, 0x0034, "IS" },
	{0x0028, 0x0040, "UN" },
	{0x0028, 0x0050, "UN" },
	{0x0028, 0x0051, "CS" },
	{0x0028, 0x0060, "UN" },
	{0x0028, 0x0100, "US" },
	{0x0028, 0x0101, "US" },
	{0x0028, 0x0102, "US" },
	{0x0028, 0x0103, "US" },
	{0x0028, 0x0104, "UN" },
	{0x0028, 0x0105, "UN" },
	{0x0028, 0x0106, "SS" },
	{0x0028, 0x0107, "SS" },
	{0x0028, 0x0108, "SS" },
	{0x0028, 0x0109, "SS" },
	{0x0028, 0x0110, "SS" },
	{0x0028, 0x0111, "SS" },
	{0x0028, 0x0120, "SS" },
	{0x0028, 0x0200, "UN" },
	{0x0028, 0x0300, "CS" },
	{0x0028, 0x0301, "CS" },
	{0x0028, 0x1040, "CS" },
	{0x0028, 0x1041, "SS" },
	{0x0028, 0x1050, "DS" },
	{0x0028, 0x1051, "DS" },
	{0x0028, 0x1052, "DS" },
	{0x0028, 0x1053, "DS" },
	{0x0028, 0x1054, "LO" },
	{0x0028, 0x1055, "LO" },
	{0x0028, 0x1080, "UN" },
	{0x0028, 0x1090, "CS" },
	{0x0028, 0x1100, "UN" },
	{0x0028, 0x1101, "SS" },
	{0x0028, 0x1102, "SS" },
	{0x0028, 0x1103, "SS" },
	{0x0028, 0x1199, "UI" },
	{0x0028, 0x1200, "UN" },
	{0x0028, 0x1201, "OW" },
	{0x0028, 0x1202, "OW" },
	{0x0028, 0x1203, "OW" },
	{0x0028, 0x1221, "OW" },
	{0x0028, 0x1222, "OW" },
	{0x0028, 0x1223, "OW" },
	{0x0028, 0x1300, "CS" },
	{0x0028, 0x1350, "CS" },
	{0x0028, 0x1351, "ST" },
	{0x0028, 0x2110, "CS" },
	{0x0028, 0x2112, "DS" },
	{0x0028, 0x3000, "SQ" },
	{0x0028, 0x3002, "SS" },
	{0x0028, 0x3003, "LO" },
	{0x0028, 0x3004, "LO" },
	{0x0028, 0x3006, "or" },
	{0x0028, 0x3010, "SQ" },
	{0x0028, 0x3110, "SQ" },
	{0x0028, 0x4000, "LT" },
	{0x0028, 0x5000, "SQ" },
	{0x0028, 0x6010, "US" },
	{0x0028, 0x6020, "US" },
	{0x0028, 0x6022, "LO" },
	{0x0028, 0x6030, "US" },
	{0x0028, 0x6040, "US" },
	{0x0028, 0x6100, "SQ" },
	{0x0028, 0x6101, "CS" },
	{0x0028, 0x6102, "US" },
	{0x0028, 0x6110, "US" },
	{0x0028, 0x6112, "US" },
	{0x0028, 0x6114, "FL" },
	{0x0028, 0x6120, "SS" },
	{0x0028, 0x6190, "ST" },
	{0x0028, 0x9001, "UL" },
	{0x0028, 0x9002, "UL" },
	{0x0028, 0x9003, "CS" },
	{0x0028, 0x9099, "US" },
	{0x0028, 0x9108, "CS" },
	{0x0028, 0x9110, "SQ" },
	{0x0028, 0x9132, "SQ" },
	{0x0028, 0x9145, "SQ" },
	{0x0028, 0x9235, "CS" },
	{0x0032, 0x000A, "CS" },
	{0x0032, 0x000C, "CS" },
	{0x0032, 0x0012, "LO" },
	{0x0032, 0x0032, "DA" },
	{0x0032, 0x0033, "TM" },
	{0x0032, 0x0034, "DA" },
	{0x0032, 0x0035, "TM" },
	{0x0032, 0x1000, "DA" },
	{0x0032, 0x1001, "TM" },
	{0x0032, 0x1010, "DA" },
	{0x0032, 0x1011, "TM" },
	{0x0032, 0x1020, "LO" },
	{0x0032, 0x1021, "AE" },
	{0x0032, 0x1030, "LO" },
	{0x0032, 0x1031, "SQ" },
	{0x0032, 0x1032, "PN" },
	{0x0032, 0x1033, "LO" },
	{0x0032, 0x1040, "DA" },
	{0x0032, 0x1041, "TM" },
	{0x0032, 0x1050, "DA" },
	{0x0032, 0x1051, "TM" },
	{0x0032, 0x1055, "CS" },
	{0x0032, 0x1060, "LO" },
	{0x0032, 0x1064, "SQ" },
	{0x0032, 0x1070, "LO" },
	{0x0032, 0x4000, "LT" },
	{0x0038, 0x0004, "SQ" },
	{0x0038, 0x0008, "CS" },
	{0x0038, 0x0010, "LO" },
	{0x0038, 0x0011, "LO" },
	{0x0038, 0x0016, "LO" },
	{0x0038, 0x001A, "DA" },
	{0x0038, 0x001B, "TM" },
	{0x0038, 0x001C, "DA" },
	{0x0038, 0x001D, "TM" },
	{0x0038, 0x001E, "LO" },
	{0x0038, 0x0020, "DA" },
	{0x0038, 0x0021, "TM" },
	{0x0038, 0x0030, "DA" },
	{0x0038, 0x0032, "TM" },
	{0x0038, 0x0040, "LO" },
	{0x0038, 0x0044, "SQ" },
	{0x0038, 0x0050, "LO" },
	{0x0038, 0x0300, "LO" },
	{0x0038, 0x0400, "LO" },
	{0x0038, 0x0500, "LO" },
	{0x0038, 0x4000, "LT" },
	{0x003A, 0x0004, "CS" },
	{0x003A, 0x0005, "US" },
	{0x003A, 0x0010, "UL" },
	{0x003A, 0x001A, "DS" },
	{0x003A, 0x0020, "SH" },
	{0x003A, 0x0200, "SQ" },
	{0x003A, 0x0202, "IS" },
	{0x003A, 0x0203, "SH" },
	{0x003A, 0x0205, "CS" },
	{0x003A, 0x0208, "SQ" },
	{0x003A, 0x0209, "SQ" },
	{0x003A, 0x020A, "SQ" },
	{0x003A, 0x020C, "LO" },
	{0x003A, 0x0210, "DS" },
	{0x003A, 0x0211, "SQ" },
	{0x003A, 0x0212, "DS" },
	{0x003A, 0x0213, "DS" },
	{0x003A, 0x0214, "DS" },
	{0x003A, 0x0215, "DS" },
	{0x003A, 0x0218, "DS" },
	{0x003A, 0x021A, "US" },
	{0x003A, 0x0220, "DS" },
	{0x003A, 0x0221, "DS" },
	{0x003A, 0x0222, "DS" },
	{0x003A, 0x0223, "DS" },
	{0x0040, 0x0001, "AE" },
	{0x0040, 0x0002, "DA" },
	{0x0040, 0x0003, "TM" },
	{0x0040, 0x0004, "DA" },
	{0x0040, 0x0005, "TM" },
	{0x0040, 0x0006, "PN" },
	{0x0040, 0x0007, "LO" },
	{0x0040, 0x0008, "SQ" },
	{0x0040, 0x0009, "SH" },
	{0x0040, 0x000A, "SQ" },
	{0x0040, 0x000B, "SQ" },
	{0x0040, 0x0010, "SH" },
	{0x0040, 0x0011, "SH" },
	{0x0040, 0x0012, "LO" },
	{0x0040, 0x0020, "CS" },
	{0x0040, 0x0100, "SQ" },
	{0x0040, 0x0220, "SQ" },
	{0x0040, 0x0241, "AE" },
	{0x0040, 0x0242, "SH" },
	{0x0040, 0x0243, "SH" },
	{0x0040, 0x0244, "DA" },
	{0x0040, 0x0245, "TM" },
	{0x0040, 0x0250, "DA" },
	{0x0040, 0x0251, "TM" },
	{0x0040, 0x0252, "CS" },
	{0x0040, 0x0253, "SH" },
	{0x0040, 0x0254, "LO" },
	{0x0040, 0x0255, "LO" },
	{0x0040, 0x0260, "SQ" },
	{0x0040, 0x0270, "SQ" },
	{0x0040, 0x0275, "SQ" },
	{0x0040, 0x0280, "ST" },
	{0x0040, 0x0281, "SQ" },
	{0x0040, 0x0293, "SQ" },
	{0x0040, 0x0294, "DS" },
	{0x0040, 0x0295, "SQ" },
	{0x0040, 0x0296, "SQ" },
	{0x0040, 0x0300, "US" },
	{0x0040, 0x0301, "US" },
	{0x0040, 0x0302, "US" },
	{0x0040, 0x0303, "US" },
	{0x0040, 0x0306, "DS" },
	{0x0040, 0x0307, "DS" },
	{0x0040, 0x030E, "SQ" },
	{0x0040, 0x0310, "ST" },
	{0x0040, 0x0312, "DS" },
	{0x0040, 0x0314, "DS" },
	{0x0040, 0x0316, "DS" },
	{0x0040, 0x0318, "CS" },
	{0x0040, 0x0320, "SQ" },
	{0x0040, 0x0321, "SQ" },
	{0x0040, 0x0324, "SQ" },
	{0x0040, 0x0330, "SQ" },
	{0x0040, 0x0340, "SQ" },
	{0x0040, 0x0400, "LT" },
	{0x0040, 0x050A, "LO" },
	{0x0040, 0x0550, "SQ" },
	{0x0040, 0x0551, "LO" },
	{0x0040, 0x0555, "SQ" },
	{0x0040, 0x0556, "ST" },
	{0x0040, 0x059A, "SQ" },
	{0x0040, 0x06FA, "LO" },
	{0x0040, 0x071A, "SQ" },
	{0x0040, 0x072A, "DS" },
	{0x0040, 0x073A, "DS" },
	{0x0040, 0x074A, "DS" },
	{0x0040, 0x08D8, "SQ" },
	{0x0040, 0x08DA, "SQ" },
	{0x0040, 0x08EA, "SQ" },
	{0x0040, 0x1001, "SH" },
	{0x0040, 0x1002, "LO" },
	{0x0040, 0x1003, "SH" },
	{0x0040, 0x1004, "LO" },
	{0x0040, 0x1005, "LO" },
	{0x0040, 0x1006, "SH" },
	{0x0040, 0x1007, "SH" },
	{0x0040, 0x1008, "LO" },
	{0x0040, 0x1009, "SH" },
	{0x0040, 0x1010, "PN" },
	{0x0040, 0x1011, "SQ" },
	{0x0040, 0x1101, "SQ" },
	{0x0040, 0x1102, "ST" },
	{0x0040, 0x1103, "LO" },
	{0x0040, 0x1400, "LT" },
	{0x0040, 0x2001, "LO" },
	{0x0040, 0x2004, "DA" },
	{0x0040, 0x2005, "TM" },
	{0x0040, 0x2006, "SH" },
	{0x0040, 0x2007, "SH" },
	{0x0040, 0x2008, "PN" },
	{0x0040, 0x2009, "SH" },
	{0x0040, 0x2010, "SH" },
	{0x0040, 0x2016, "LO" },
	{0x0040, 0x2017, "LO" },
	{0x0040, 0x2400, "LT" },
	{0x0040, 0x3001, "LO" },
	{0x0040, 0x4001, "CS" },
	{0x0040, 0x4002, "CS" },
	{0x0040, 0x4003, "CS" },
	{0x0040, 0x4004, "SQ" },
	{0x0040, 0x4005, "DT" },
	{0x0040, 0x4006, "CS" },
	{0x0040, 0x4007, "SQ" },
	{0x0040, 0x4009, "SQ" },
	{0x0040, 0x4011, "DT" },
	{0x0040, 0x4015, "SQ" },
	{0x0040, 0x4016, "SQ" },
	{0x0040, 0x4018, "SQ" },
	{0x0040, 0x4019, "SQ" },
	{0x0040, 0x4020, "CS" },
	{0x0040, 0x4021, "SQ" },
	{0x0040, 0x4022, "SQ" },
	{0x0040, 0x4023, "UI" },
	{0x0040, 0x4025, "SQ" },
	{0x0040, 0x4026, "SQ" },
	{0x0040, 0x4027, "SQ" },
	{0x0040, 0x4028, "SQ" },
	{0x0040, 0x4029, "SQ" },
	{0x0040, 0x4030, "SQ" },
	{0x0040, 0x4031, "SQ" },
	{0x0040, 0x4032, "SQ" },
	{0x0040, 0x4033, "SQ" },
	{0x0040, 0x4034, "SQ" },
	{0x0040, 0x4035, "SQ" },
	{0x0040, 0x4036, "LO" },
	{0x0040, 0x4037, "PN" },
	{0x0040, 0x8302, "DS" },
	{0x0040, 0x9096, "SQ" },
	{0x0040, 0x9210, "SS" },
	{0x0040, 0x9211, "SS" },
	{0x0040, 0x9212, "FD" },
	{0x0040, 0x9216, "SS" },
	{0x0040, 0x9224, "FD" },
	{0x0040, 0x9225, "FD" },
	{0x0040, 0xA010, "CS" },
	{0x0040, 0xA027, "LO" },
	{0x0040, 0xA030, "DT" },
	{0x0040, 0xA032, "DT" },
	{0x0040, 0xA040, "CS" },
	{0x0040, 0xA043, "SQ" },
	{0x0040, 0xA050, "CS" },
	{0x0040, 0xA073, "SQ" },
	{0x0040, 0xA075, "PN" },
	{0x0040, 0xA088, "SQ" },
	{0x0040, 0xA0B0, "US" },
	{0x0040, 0xA120, "DT" },
	{0x0040, 0xA121, "DA" },
	{0x0040, 0xA122, "TM" },
	{0x0040, 0xA123, "PN" },
	{0x0040, 0xA124, "UI" },
	{0x0040, 0xA130, "CS" },
	{0x0040, 0xA132, "UL" },
	{0x0040, 0xA136, "US" },
	{0x0040, 0xA138, "DS" },
	{0x0040, 0xA13A, "DT" },
	{0x0040, 0xA160, "UT" },
	{0x0040, 0xA168, "SQ" },
	{0x0040, 0xA170, "SQ" },
	{0x0040, 0xA180, "US" },
	{0x0040, 0xA195, "SQ" },
	{0x0040, 0xA300, "SQ" },
	{0x0040, 0xA301, "SQ" },
	{0x0040, 0xA30A, "DS" },
	{0x0040, 0xA360, "SQ" },
	{0x0040, 0xA370, "SQ" },
	{0x0040, 0xA372, "SQ" },
	{0x0040, 0xA375, "SQ" },
	{0x0040, 0xA385, "SQ" },
	{0x0040, 0xA491, "CS" },
	{0x0040, 0xA492, "LO" },
	{0x0040, 0xA493, "CS" },
	{0x0040, 0xA504, "SQ" },
	{0x0040, 0xA525, "SQ" },
	{0x0040, 0xA730, "SQ" },
	{0x0040, 0xB020, "SQ" },
	{0x0040, 0xDB00, "CS" },
	{0x0040, 0xDB06, "DT" },
	{0x0040, 0xDB07, "DT" },
	{0x0040, 0xDB0B, "CS" },
	{0x0040, 0xDB0C, "UI" },
	{0x0040, 0xDB0D, "UI" },
	{0x0040, 0xDB73, "UL" },
	{0x0050, 0x0004, "CS" },
	{0x0050, 0x0010, "SQ" },
	{0x0050, 0x0014, "DS" },
	{0x0050, 0x0016, "DS" },
	{0x0050, 0x0017, "CS" },
	{0x0050, 0x0018, "DS" },
	{0x0050, 0x0019, "DS" },
	{0x0050, 0x0020, "LO" },
	{0x0054, 0x0010, "US" },
	{0x0054, 0x0011, "US" },
	{0x0054, 0x0012, "SQ" },
	{0x0054, 0x0013, "SQ" },
	{0x0054, 0x0014, "DS" },
	{0x0054, 0x0015, "DS" },
	{0x0054, 0x0016, "SQ" },
	{0x0054, 0x0017, "IS" },
	{0x0054, 0x0018, "SH" },
	{0x0054, 0x0020, "US" },
	{0x0054, 0x0021, "US" },
	{0x0054, 0x0022, "SQ" },
	{0x0054, 0x0030, "US" },
	{0x0054, 0x0031, "US" },
	{0x0054, 0x0032, "SQ" },
	{0x0054, 0x0033, "US" },
	{0x0054, 0x0036, "IS" },
	{0x0054, 0x0038, "IS" },
	{0x0054, 0x0050, "US" },
	{0x0054, 0x0051, "US" },
	{0x0054, 0x0052, "SQ" },
	{0x0054, 0x0053, "US" },
	{0x0054, 0x0060, "US" },
	{0x0054, 0x0061, "US" },
	{0x0054, 0x0062, "SQ" },
	{0x0054, 0x0063, "SQ" },
	{0x0054, 0x0070, "US" },
	{0x0054, 0x0071, "US" },
	{0x0054, 0x0072, "SQ" },
	{0x0054, 0x0073, "DS" },
	{0x0054, 0x0080, "US" },
	{0x0054, 0x0081, "US" },
	{0x0054, 0x0090, "US" },
	{0x0054, 0x0100, "US" },
	{0x0054, 0x0101, "US" },
	{0x0054, 0x0200, "DS" },
	{0x0054, 0x0202, "CS" },
	{0x0054, 0x0210, "IS" },
	{0x0054, 0x0211, "US" },
	{0x0054, 0x0220, "SQ" },
	{0x0054, 0x0222, "SQ" },
	{0x0054, 0x0300, "SQ" },
	{0x0054, 0x0302, "SQ" },
	{0x0054, 0x0304, "SQ" },
	{0x0054, 0x0306, "SQ" },
	{0x0054, 0x0308, "US" },
	{0x0054, 0x0400, "SH" },
	{0x0054, 0x0410, "SQ" },
	{0x0054, 0x0412, "SQ" },
	{0x0054, 0x0414, "SQ" },
	{0x0054, 0x1000, "CS" },
	{0x0054, 0x1001, "CS" },
	{0x0054, 0x1002, "CS" },
	{0x0054, 0x1004, "CS" },
	{0x0054, 0x1100, "CS" },
	{0x0054, 0x1101, "LO" },
	{0x0054, 0x1102, "CS" },
	{0x0054, 0x1103, "LO" },
	{0x0054, 0x1104, "LO" },
	{0x0054, 0x1105, "LO" },
	{0x0054, 0x1200, "DS" },
	{0x0054, 0x1201, "IS" },
	{0x0054, 0x1202, "IS" },
	{0x0054, 0x1203, "DS" },
	{0x0054, 0x1210, "DS" },
	{0x0054, 0x1220, "CS" },
	{0x0054, 0x1300, "DS" },
	{0x0054, 0x1310, "IS" },
	{0x0054, 0x1311, "IS" },
	{0x0054, 0x1320, "DS" },
	{0x0054, 0x1321, "DS" },
	{0x0054, 0x1322, "DS" },
	{0x0054, 0x1323, "DS" },
	{0x0054, 0x1324, "DS" },
	{0x0054, 0x1330, "US" },
	{0x0054, 0x1400, "CS" },
	{0x0054, 0x1401, "CS" },
	{0x0060, 0x3000, "SQ" },
	{0x0060, 0x3002, "US" },
	{0x0060, 0x3004, "SS" },
	{0x0060, 0x3006, "SS" },
	{0x0060, 0x3008, "US" },
	{0x0060, 0x3010, "LO" },
	{0x0060, 0x3020, "UL" },
	{0x0070, 0x0001, "SQ" },
	{0x0070, 0x0002, "CS" },
	{0x0070, 0x0003, "CS" },
	{0x0070, 0x0004, "CS" },
	{0x0070, 0x0005, "CS" },
	{0x0070, 0x0006, "ST" },
	{0x0070, 0x0008, "SQ" },
	{0x0070, 0x0009, "SQ" },
	{0x0070, 0x0010, "FL" },
	{0x0070, 0x0011, "FL" },
	{0x0070, 0x0012, "CS" },
	{0x0070, 0x0014, "FL" },
	{0x0070, 0x0015, "CS" },
	{0x0070, 0x0020, "US" },
	{0x0070, 0x0021, "US" },
	{0x0070, 0x0022, "FL" },
	{0x0070, 0x0023, "CS" },
	{0x0070, 0x0024, "CS" },
	{0x0070, 0x0041, "CS" },
	{0x0070, 0x0042, "US" },
	{0x0070, 0x0052, "SL" },
	{0x0070, 0x0053, "SL" },
	{0x0070, 0x005A, "SQ" },
	{0x0070, 0x0060, "SQ" },
	{0x0070, 0x0062, "IS" },
	{0x0070, 0x0066, "US" },
	{0x0070, 0x0067, "US" },
	{0x0070, 0x0068, "LO" },
	{0x0070, 0x0080, "CS" },
	{0x0070, 0x0081, "LO" },
	{0x0070, 0x0082, "DA" },
	{0x0070, 0x0083, "TM" },
	{0x0070, 0x0084, "PN" },
	{0x0070, 0x0100, "CS" },
	{0x0070, 0x0101, "DS" },
	{0x0070, 0x0102, "IS" },
	{0x0070, 0x0103, "FL" },
	{0x0088, 0x0130, "SH" },
	{0x0088, 0x0140, "UI" },
	{0x0088, 0x0200, "SQ" },
	{0x0088, 0x0904, "LO" },
	{0x0088, 0x0906, "ST" },
	{0x0088, 0x0910, "LO" },
	{0x0088, 0x0912, "LO" },
	{0x0100, 0x0410, "CS" },
	{0x0100, 0x0420, "DT" },
	{0x0100, 0x0424, "LT" },
	{0x0100, 0x0426, "LO" },
	{0x0400, 0x0005, "US" },
	{0x0400, 0x0010, "UI" },
	{0x0400, 0x0015, "CS" },
	{0x0400, 0x0020, "AT" },
	{0x0400, 0x0100, "UI" },
	{0x0400, 0x0105, "DT" },
	{0x0400, 0x0110, "CS" },
	{0x0400, 0x0115, "OB" },
	{0x0400, 0x0120, "OB" },
	{0x0400, 0x0305, "CS" },
	{0x0400, 0x0310, "OB" },
	{0x0400, 0x0500, "SQ" },
	{0x0400, 0x0510, "UI" },
	{0x0400, 0x0520, "OB" },
	{0x0400, 0x0550, "SQ" },
	{0x2000, 0x0010, "IS" },
	{0x2000, 0x001E, "SQ" },
	{0x2000, 0x0020, "CS" },
	{0x2000, 0x0030, "CS" },
	{0x2000, 0x0040, "CS" },
	{0x2000, 0x0050, "LO" },
	{0x2000, 0x0060, "IS" },
	{0x2000, 0x0061, "IS" },
	{0x2000, 0x0062, "CS" },
	{0x2000, 0x0063, "CS" },
	{0x2000, 0x0065, "CS" },
	{0x2000, 0x0067, "CS" },
	{0x2000, 0x0069, "CS" },
	{0x2000, 0x006A, "CS" },
	{0x2000, 0x00A0, "US" },
	{0x2000, 0x00A1, "US" },
	{0x2000, 0x00A2, "SQ" },
	{0x2000, 0x00A4, "SQ" },
	{0x2000, 0x00A8, "SQ" },
	{0x2000, 0x0500, "SQ" },
	{0x2000, 0x0510, "SQ" },
	{0x2010, 0x0010, "ST" },
	{0x2010, 0x0030, "CS" },
	{0x2010, 0x0040, "CS" },
	{0x2010, 0x0050, "CS" },
	{0x2010, 0x0052, "CS" },
	{0x2010, 0x0054, "CS" },
	{0x2010, 0x0060, "CS" },
	{0x2010, 0x0080, "CS" },
	{0x2010, 0x00A6, "CS" },
	{0x2010, 0x00A7, "CS" },
	{0x2010, 0x00A8, "CS" },
	{0x2010, 0x00A9, "CS" },
	{0x2010, 0x0100, "CS" },
	{0x2010, 0x0110, "CS" },
	{0x2010, 0x0120, "US" },
	{0x2010, 0x0130, "US" },
	{0x2010, 0x0140, "CS" },
	{0x2010, 0x0150, "ST" },
	{0x2010, 0x0152, "LT" },
	{0x2010, 0x0154, "IS" },
	{0x2010, 0x015E, "US" },
	{0x2010, 0x0160, "US" },
	{0x2010, 0x0376, "DS" },
	{0x2010, 0x0500, "SQ" },
	{0x2010, 0x0510, "SQ" },
	{0x2010, 0x0520, "SQ" },
	{0x2020, 0x0010, "US" },
	{0x2020, 0x0020, "CS" },
	{0x2020, 0x0030, "DS" },
	{0x2020, 0x0040, "CS" },
	{0x2020, 0x0050, "CS" },
	{0x2020, 0x00A0, "CS" },
	{0x2020, 0x00A2, "CS" },
	{0x2020, 0x0110, "SQ" },
	{0x2020, 0x0111, "SQ" },
	{0x2020, 0x0130, "SQ" },
	{0x2020, 0x0140, "SQ" },
	{0x2030, 0x0010, "US" },
	{0x2030, 0x0020, "LO" },
	{0x2040, 0x0010, "SQ" },
	{0x2040, 0x0011, "US" },
	{0x2040, 0x0020, "SQ" },
	{0x2040, 0x0060, "CS" },
	{0x2040, 0x0070, "CS" },
	{0x2040, 0x0072, "CS" },
	{0x2040, 0x0074, "US" },
	{0x2040, 0x0080, "CS" },
	{0x2040, 0x0082, "CS" },
	{0x2040, 0x0090, "CS" },
	{0x2040, 0x0100, "CS" },
	{0x2040, 0x0500, "SQ" },
	{0x2050, 0x0010, "SQ" },
	{0x2050, 0x0020, "CS" },
	{0x2050, 0x0500, "SQ" },
	{0x2100, 0x0010, "SH" },
	{0x2100, 0x0020, "CS" },
	{0x2100, 0x0030, "CS" },
	{0x2100, 0x0040, "DA" },
	{0x2100, 0x0050, "TM" },
	{0x2100, 0x0070, "AE" },
	{0x2100, 0x0140, "AE" },
	{0x2100, 0x0160, "SH" },
	{0x2100, 0x0170, "IS" },
	{0x2100, 0x0500, "SQ" },
	{0x2110, 0x0010, "CS" },
	{0x2110, 0x0020, "CS" },
	{0x2110, 0x0030, "LO" },
	{0x2110, 0x0099, "SH" },
	{0x2120, 0x0010, "CS" },
	{0x2120, 0x0050, "SQ" },
	{0x2120, 0x0070, "SQ" },
	{0x2130, 0x0010, "SQ" },
	{0x2130, 0x0015, "SQ" },
	{0x2130, 0x0030, "SQ" },
	{0x2130, 0x0040, "SQ" },
	{0x2130, 0x0050, "SQ" },
	{0x2130, 0x0060, "SQ" },
	{0x2130, 0x0080, "SQ" },
	{0x2130, 0x00A0, "SQ" },
	{0x2130, 0x00C0, "SQ" },
	{0x3002, 0x0002, "SH" },
	{0x3002, 0x0003, "LO" },
	{0x3002, 0x0004, "ST" },
	{0x3002, 0x000A, "CS" },
	{0x3002, 0x000C, "CS" },
	{0x3002, 0x000D, "DS" },
	{0x3002, 0x000E, "DS" },
	{0x3002, 0x0010, "DS" },
	{0x3002, 0x0011, "DS" },
	{0x3002, 0x0012, "DS" },
	{0x3002, 0x0020, "SH" },
	{0x3002, 0x0022, "DS" },
	{0x3002, 0x0024, "DS" },
	{0x3002, 0x0026, "DS" },
	{0x3002, 0x0028, "DS" },
	{0x3002, 0x0029, "IS" },
	{0x3002, 0x0030, "SQ" },
	{0x3002, 0x0032, "DS" },
	{0x3002, 0x0034, "DS" },
	{0x3004, 0x0001, "CS" },
	{0x3004, 0x0002, "CS" },
	{0x3004, 0x0004, "CS" },
	{0x3004, 0x0006, "LO" },
	{0x3004, 0x0008, "DS" },
	{0x3004, 0x000A, "CS" },
	{0x3004, 0x000C, "DS" },
	{0x3004, 0x000E, "DS" },
	{0x3004, 0x0010, "SQ" },
	{0x3004, 0x0012, "DS" },
	{0x3004, 0x0040, "DS" },
	{0x3004, 0x0042, "DS" },
	{0x3004, 0x0050, "SQ" },
	{0x3004, 0x0052, "DS" },
	{0x3004, 0x0054, "CS" },
	{0x3004, 0x0056, "IS" },
	{0x3004, 0x0058, "DS" },
	{0x3004, 0x0060, "SQ" },
	{0x3004, 0x0062, "CS" },
	{0x3004, 0x0070, "DS" },
	{0x3004, 0x0072, "DS" },
	{0x3004, 0x0074, "DS" },
	{0x3006, 0x0002, "SH" },
	{0x3006, 0x0004, "LO" },
	{0x3006, 0x0006, "ST" },
	{0x3006, 0x0008, "DA" },
	{0x3006, 0x0009, "TM" },
	{0x3006, 0x0010, "SQ" },
	{0x3006, 0x0012, "SQ" },
	{0x3006, 0x0014, "SQ" },
	{0x3006, 0x0016, "SQ" },
	{0x3006, 0x0020, "SQ" },
	{0x3006, 0x0022, "IS" },
	{0x3006, 0x0024, "UI" },
	{0x3006, 0x0026, "LO" },
	{0x3006, 0x0028, "ST" },
	{0x3006, 0x002A, "IS" },
	{0x3006, 0x002C, "DS" },
	{0x3006, 0x0030, "SQ" },
	{0x3006, 0x0033, "CS" },
	{0x3006, 0x0036, "CS" },
	{0x3006, 0x0038, "LO" },
	{0x3006, 0x0039, "SQ" },
	{0x3006, 0x0040, "SQ" },
	{0x3006, 0x0042, "CS" },
	{0x3006, 0x0044, "DS" },
	{0x3006, 0x0045, "DS" },
	{0x3006, 0x0046, "IS" },
	{0x3006, 0x0048, "IS" },
	{0x3006, 0x0049, "IS" },
	{0x3006, 0x0050, "DS" },
	{0x3006, 0x0080, "SQ" },
	{0x3006, 0x0082, "IS" },
	{0x3006, 0x0084, "IS" },
	{0x3006, 0x0085, "SH" },
	{0x3006, 0x0086, "SQ" },
	{0x3006, 0x0088, "ST" },
	{0x3006, 0x00A0, "SQ" },
	{0x3006, 0x00A4, "CS" },
	{0x3006, 0x00A6, "PN" },
	{0x3006, 0x00B0, "SQ" },
	{0x3006, 0x00B2, "CS" },
	{0x3006, 0x00B4, "DS" },
	{0x3006, 0x00C0, "SQ" },
	{0x3006, 0x00C2, "UI" },
	{0x3006, 0x00C4, "CS" },
	{0x3006, 0x00C6, "DS" },
	{0x3006, 0x00C8, "LO" },
	{0x3008, 0x0010, "SQ" },
	{0x3008, 0x0012, "ST" },
	{0x3008, 0x0014, "CS" },
	{0x3008, 0x0016, "DS" },
	{0x3008, 0x0020, "SQ" },
	{0x3008, 0x0022, "IS" },
	{0x3008, 0x0024, "DA" },
	{0x3008, 0x0025, "TM" },
	{0x3008, 0x002A, "CS" },
	{0x3008, 0x002B, "SH" },
	{0x3008, 0x002C, "CS" },
	{0x3008, 0x0030, "SQ" },
	{0x3008, 0x0032, "DS" },
	{0x3008, 0x0033, "DS" },
	{0x3008, 0x0036, "DS" },
	{0x3008, 0x0037, "DS" },
	{0x3008, 0x003A, "DS" },
	{0x3008, 0x003B, "DS" },
	{0x3008, 0x0040, "SQ" },
	{0x3008, 0x0042, "DS" },
	{0x3008, 0x0044, "DS" },
	{0x3008, 0x0048, "DS" },
	{0x3008, 0x0050, "SQ" },
	{0x3008, 0x0052, "DS" },
	{0x3008, 0x0054, "DA" },
	{0x3008, 0x0056, "DA" },
	{0x3008, 0x005A, "IS" },
	{0x3008, 0x0060, "SQ" },
	{0x3008, 0x0062, "AT" },
	{0x3008, 0x0064, "IS" },
	{0x3008, 0x0066, "ST" },
	{0x3008, 0x0070, "SQ" },
	{0x3008, 0x0072, "IS" },
	{0x3008, 0x0074, "ST" },
	{0x3008, 0x0076, "DS" },
	{0x3008, 0x0078, "DS" },
	{0x3008, 0x007A, "DS" },
	{0x3008, 0x0080, "SQ" },
	{0x3008, 0x0082, "IS" },
	{0x3008, 0x0090, "SQ" },
	{0x3008, 0x0092, "IS" },
	{0x3008, 0x00A0, "SQ" },
	{0x3008, 0x00B0, "SQ" },
	{0x3008, 0x00C0, "SQ" },
	{0x3008, 0x00D0, "SQ" },
	{0x3008, 0x00E0, "SQ" },
	{0x3008, 0x0100, "SQ" },
	{0x3008, 0x0105, "LO" },
	{0x3008, 0x0110, "SQ" },
	{0x3008, 0x0116, "CS" },
	{0x3008, 0x0120, "SQ" },
	{0x3008, 0x0122, "IS" },
	{0x3008, 0x0130, "SQ" },
	{0x3008, 0x0132, "DS" },
	{0x3008, 0x0134, "DS" },
	{0x3008, 0x0136, "IS" },
	{0x3008, 0x0138, "IS" },
	{0x3008, 0x013A, "DS" },
	{0x3008, 0x013C, "DS" },
	{0x3008, 0x0140, "SQ" },
	{0x3008, 0x0142, "IS" },
	{0x3008, 0x0150, "SQ" },
	{0x3008, 0x0152, "IS" },
	{0x3008, 0x0160, "SQ" },
	{0x3008, 0x0162, "DA" },
	{0x3008, 0x0164, "TM" },
	{0x3008, 0x0166, "DA" },
	{0x3008, 0x0168, "TM" },
	{0x3008, 0x0200, "CS" },
	{0x3008, 0x0202, "ST" },
	{0x3008, 0x0220, "SQ" },
	{0x3008, 0x0223, "IS" },
	{0x3008, 0x0224, "CS" },
	{0x3008, 0x0230, "CS" },
	{0x3008, 0x0240, "SQ" },
	{0x3008, 0x0250, "DA" },
	{0x3008, 0x0251, "TM" },
	{0x300A, 0x0002, "SH" },
	{0x300A, 0x0003, "LO" },
	{0x300A, 0x0004, "ST" },
	{0x300A, 0x0006, "DA" },
	{0x300A, 0x0007, "TM" },
	{0x300A, 0x0009, "LO" },
	{0x300A, 0x000A, "CS" },
	{0x300A, 0x000B, "LO" },
	{0x300A, 0x000C, "CS" },
	{0x300A, 0x000E, "ST" },
	{0x300A, 0x0010, "SQ" },
	{0x300A, 0x0012, "IS" },
	{0x300A, 0x0014, "CS" },
	{0x300A, 0x0015, "CS" },
	{0x300A, 0x0016, "LO" },
	{0x300A, 0x0018, "DS" },
	{0x300A, 0x001A, "DS" },
	{0x300A, 0x0020, "CS" },
	{0x300A, 0x0021, "DS" },
	{0x300A, 0x0022, "DS" },
	{0x300A, 0x0023, "DS" },
	{0x300A, 0x0025, "DS" },
	{0x300A, 0x0026, "DS" },
	{0x300A, 0x0027, "DS" },
	{0x300A, 0x0028, "DS" },
	{0x300A, 0x002A, "DS" },
	{0x300A, 0x002B, "DS" },
	{0x300A, 0x002C, "DS" },
	{0x300A, 0x002D, "DS" },
	{0x300A, 0x0040, "SQ" },
	{0x300A, 0x0042, "IS" },
	{0x300A, 0x0043, "SH" },
	{0x300A, 0x0044, "DS" },
	{0x300A, 0x0046, "DS" },
	{0x300A, 0x0048, "SQ" },
	{0x300A, 0x004A, "DS" },
	{0x300A, 0x004C, "DS" },
	{0x300A, 0x004E, "DS" },
	{0x300A, 0x0051, "DS" },
	{0x300A, 0x0052, "DS" },
	{0x300A, 0x0053, "DS" },
	{0x300A, 0x0055, "CS" },
	{0x300A, 0x0070, "SQ" },
	{0x300A, 0x0071, "IS" },
	{0x300A, 0x0078, "IS" },
	{0x300A, 0x0079, "IS" },
	{0x300A, 0x007A, "IS" },
	{0x300A, 0x007B, "LT" },
	{0x300A, 0x0080, "IS" },
	{0x300A, 0x0082, "DS" },
	{0x300A, 0x0084, "DS" },
	{0x300A, 0x0086, "DS" },
	{0x300A, 0x00A0, "IS" },
	{0x300A, 0x00A2, "DS" },
	{0x300A, 0x00A4, "DS" },
	{0x300A, 0x00B0, "SQ" },
	{0x300A, 0x00B2, "SH" },
	{0x300A, 0x00B3, "CS" },
	{0x300A, 0x00B4, "DS" },
	{0x300A, 0x00B6, "SQ" },
	{0x300A, 0x00B8, "CS" },
	{0x300A, 0x00BA, "DS" },
	{0x300A, 0x00BC, "IS" },
	{0x300A, 0x00BE, "DS" },
	{0x300A, 0x00C0, "IS" },
	{0x300A, 0x00C2, "LO" },
	{0x300A, 0x00C3, "ST" },
	{0x300A, 0x00C4, "CS" },
	{0x300A, 0x00C6, "CS" },
	{0x300A, 0x00C7, "CS" },
	{0x300A, 0x00C8, "IS" },
	{0x300A, 0x00CA, "SQ" },
	{0x300A, 0x00CC, "LO" },
	{0x300A, 0x00CE, "CS" },
	{0x300A, 0x00D0, "IS" },
	{0x300A, 0x00D1, "SQ" },
	{0x300A, 0x00D2, "IS" },
	{0x300A, 0x00D3, "CS" },
	{0x300A, 0x00D4, "SH" },
	{0x300A, 0x00D5, "IS" },
	{0x300A, 0x00D6, "DS" },
	{0x300A, 0x00D8, "DS" },
	{0x300A, 0x00DA, "DS" },
	{0x300A, 0x00E0, "IS" },
	{0x300A, 0x00E1, "SH" },
	{0x300A, 0x00E2, "DS" },
	{0x300A, 0x00E3, "SQ" },
	{0x300A, 0x00E4, "IS" },
	{0x300A, 0x00E5, "SH" },
	{0x300A, 0x00E6, "DS" },
	{0x300A, 0x00E7, "IS" },
	{0x300A, 0x00E8, "IS" },
	{0x300A, 0x00E9, "DS" },
	{0x300A, 0x00EA, "DS" },
	{0x300A, 0x00EB, "DS" },
	{0x300A, 0x00EC, "DS" },
	{0x300A, 0x00ED, "IS" },
	{0x300A, 0x00EE, "CS" },
	{0x300A, 0x00F0, "IS" },
	{0x300A, 0x00F2, "DS" },
	{0x300A, 0x00F4, "SQ" },
	{0x300A, 0x00F5, "SH" },
	{0x300A, 0x00F6, "DS" },
	{0x300A, 0x00F8, "CS" },
	{0x300A, 0x00FA, "CS" },
	{0x300A, 0x00FB, "CS" },
	{0x300A, 0x00FC, "IS" },
	{0x300A, 0x00FE, "LO" },
	{0x300A, 0x0100, "DS" },
	{0x300A, 0x0102, "DS" },
	{0x300A, 0x0104, "IS" },
	{0x300A, 0x0106, "DS" },
	{0x300A, 0x0107, "SQ" },
	{0x300A, 0x0108, "SH" },
	{0x300A, 0x0109, "CS" },
	{0x300A, 0x010A, "LO" },
	{0x300A, 0x010C, "DS" },
	{0x300A, 0x010E, "DS" },
	{0x300A, 0x0110, "IS" },
	{0x300A, 0x0111, "SQ" },
	{0x300A, 0x0112, "IS" },
	{0x300A, 0x0114, "DS" },
	{0x300A, 0x0115, "DS" },
	{0x300A, 0x0116, "SQ" },
	{0x300A, 0x0118, "CS" },
	{0x300A, 0x011A, "SQ" },
	{0x300A, 0x011C, "DS" },
	{0x300A, 0x011E, "DS" },
	{0x300A, 0x011F, "CS" },
	{0x300A, 0x0120, "DS" },
	{0x300A, 0x0121, "CS" },
	{0x300A, 0x0122, "DS" },
	{0x300A, 0x0123, "CS" },
	{0x300A, 0x0124, "DS" },
	{0x300A, 0x0125, "DS" },
	{0x300A, 0x0126, "CS" },
	{0x300A, 0x0128, "DS" },
	{0x300A, 0x0129, "DS" },
	{0x300A, 0x012A, "DS" },
	{0x300A, 0x012C, "DS" },
	{0x300A, 0x012E, "DS" },
	{0x300A, 0x0130, "DS" },
	{0x300A, 0x0134, "DS" },
	{0x300A, 0x0180, "SQ" },
	{0x300A, 0x0182, "IS" },
	{0x300A, 0x0184, "LO" },
	{0x300A, 0x0190, "SQ" },
	{0x300A, 0x0192, "CS" },
	{0x300A, 0x0194, "SH" },
	{0x300A, 0x0196, "ST" },
	{0x300A, 0x0198, "SH" },
	{0x300A, 0x01A0, "SQ" },
	{0x300A, 0x01A2, "CS" },
	{0x300A, 0x01A4, "SH" },
	{0x300A, 0x01A6, "ST" },
	{0x300A, 0x01A8, "SH" },
	{0x300A, 0x01B0, "CS" },
	{0x300A, 0x01B2, "ST" },
	{0x300A, 0x01B4, "SQ" },
	{0x300A, 0x01B6, "CS" },
	{0x300A, 0x01B8, "SH" },
	{0x300A, 0x01BA, "ST" },
	{0x300A, 0x01BC, "DS" },
	{0x300A, 0x01D0, "ST" },
	{0x300A, 0x01D2, "DS" },
	{0x300A, 0x01D4, "DS" },
	{0x300A, 0x01D6, "DS" },
	{0x300A, 0x0200, "CS" },
	{0x300A, 0x0202, "CS" },
	{0x300A, 0x0206, "SQ" },
	{0x300A, 0x0210, "SQ" },
	{0x300A, 0x0212, "IS" },
	{0x300A, 0x0214, "CS" },
	{0x300A, 0x0216, "LO" },
	{0x300A, 0x0218, "DS" },
	{0x300A, 0x021A, "DS" },
	{0x300A, 0x0222, "DS" },
	{0x300A, 0x0224, "DS" },
	{0x300A, 0x0226, "LO" },
	{0x300A, 0x0228, "DS" },
	{0x300A, 0x022A, "DS" },
	{0x300A, 0x022C, "DA" },
	{0x300A, 0x022E, "TM" },
	{0x300A, 0x0230, "SQ" },
	{0x300A, 0x0232, "CS" },
	{0x300A, 0x0234, "IS" },
	{0x300A, 0x0236, "LO" },
	{0x300A, 0x0238, "LO" },
	{0x300A, 0x0240, "IS" },
	{0x300A, 0x0242, "SH" },
	{0x300A, 0x0244, "LO" },
	{0x300A, 0x0250, "DS" },
	{0x300A, 0x0260, "SQ" },
	{0x300A, 0x0262, "IS" },
	{0x300A, 0x0263, "SH" },
	{0x300A, 0x0264, "CS" },
	{0x300A, 0x0266, "LO" },
	{0x300A, 0x026A, "DS" },
	{0x300A, 0x026C, "DS" },
	{0x300A, 0x0280, "SQ" },
	{0x300A, 0x0282, "IS" },
	{0x300A, 0x0284, "DS" },
	{0x300A, 0x0286, "DS" },
	{0x300A, 0x0288, "CS" },
	{0x300A, 0x028A, "IS" },
	{0x300A, 0x028C, "DS" },
	{0x300A, 0x0290, "IS" },
	{0x300A, 0x0291, "SH" },
	{0x300A, 0x0292, "CS" },
	{0x300A, 0x0294, "LO" },
	{0x300A, 0x0296, "DS" },
	{0x300A, 0x0298, "LO" },
	{0x300A, 0x029C, "DS" },
	{0x300A, 0x029E, "DS" },
	{0x300A, 0x02A0, "DS" },
	{0x300A, 0x02A2, "IS" },
	{0x300A, 0x02A4, "DS" },
	{0x300A, 0x02B0, "SQ" },
	{0x300A, 0x02B2, "IS" },
	{0x300A, 0x02B3, "SH" },
	{0x300A, 0x02B4, "LO" },
	{0x300A, 0x02B8, "DS" },
	{0x300A, 0x02BA, "DS" },
	{0x300A, 0x02C8, "DS" },
	{0x300A, 0x02D0, "SQ" },
	{0x300A, 0x02D2, "DS" },
	{0x300A, 0x02D4, "DS" },
	{0x300A, 0x02D6, "DS" },
	{0x300A, 0x02E0, "CS" },
	{0x300A, 0x02E1, "CS" },
	{0x300A, 0x02E2, "DS" },
	{0x300C, 0x0002, "SQ" },
	{0x300C, 0x0004, "SQ" },
	{0x300C, 0x0006, "IS" },
	{0x300C, 0x0007, "IS" },
	{0x300C, 0x0008, "DS" },
	{0x300C, 0x0009, "DS" },
	{0x300C, 0x000A, "SQ" },
	{0x300C, 0x000C, "IS" },
	{0x300C, 0x000E, "IS" },
	{0x300C, 0x0020, "SQ" },
	{0x300C, 0x0022, "IS" },
	{0x300C, 0x0040, "SQ" },
	{0x300C, 0x0042, "SQ" },
	{0x300C, 0x0050, "SQ" },
	{0x300C, 0x0051, "IS" },
	{0x300C, 0x0055, "SQ" },
	{0x300C, 0x0060, "SQ" },
	{0x300C, 0x006A, "IS" },
	{0x300C, 0x0080, "SQ" },
	{0x300C, 0x00A0, "IS" },
	{0x300C, 0x00B0, "SQ" },
	{0x300C, 0x00C0, "IS" },
	{0x300C, 0x00D0, "IS" },
	{0x300C, 0x00E0, "IS" },
	{0x300C, 0x00F0, "IS" },
	{0x300E, 0x0002, "CS" },
	{0x300E, 0x0004, "DA" },
	{0x300E, 0x0005, "TM" },
	{0x300E, 0x0008, "PN" },
	{0x4000, 0x0010, "UN" },
	{0x4000, 0x4000, "UN" },
	{0x4008, 0x0040, "SH" },
	{0x4008, 0x0042, "LO" },
	{0x4008, 0x0050, "SQ" },
	{0x4008, 0x0100, "DA" },
	{0x4008, 0x0101, "TM" },
	{0x4008, 0x0102, "PN" },
	{0x4008, 0x0103, "LO" },
	{0x4008, 0x0108, "DA" },
	{0x4008, 0x0109, "TM" },
	{0x4008, 0x010A, "PN" },
	{0x4008, 0x010B, "ST" },
	{0x4008, 0x010C, "PN" },
	{0x4008, 0x0111, "SQ" },
	{0x4008, 0x0112, "DA" },
	{0x4008, 0x0113, "TM" },
	{0x4008, 0x0114, "PN" },
	{0x4008, 0x0115, "LT" },
	{0x4008, 0x0117, "SQ" },
	{0x4008, 0x0118, "SQ" },
	{0x4008, 0x0119, "PN" },
	{0x4008, 0x011A, "LO" },
	{0x4008, 0x0200, "SH" },
	{0x4008, 0x0202, "LO" },
	{0x4008, 0x0210, "CS" },
	{0x4008, 0x0212, "CS" },
	{0x4008, 0x0300, "ST" },
	{0x4008, 0x4000, "ST" },
	{0x4FFE, 0x0001, "SQ" },
	/*
	{0x50xx, 0x0005, "US" },
	{0x50xx, 0x0010, "US" },
	{0x50xx, 0x0020, "CS" },
	{0x50xx, 0x0022, "LO" },
	{0x50xx, 0x0030, "SH" },
	{0x50xx, 0x0040, "SH" },
	{0x50xx, 0x0103, "US" },
	{0x50xx, 0x0104, "US" },
	{0x50xx, 0x0105, "US" },
	{0x50xx, 0x0106, "SH" },
	{0x50xx, 0x0110, "US" },
	{0x50xx, 0x0112, "US" },
	{0x50xx, 0x0114, "US" },
	{0x50xx, 0x1001, "CS" },
	{0x50xx, 0x2000, "US" },
	{0x50xx, 0x2002, "US" },
	{0x50xx, 0x2004, "US" },
	{0x50xx, 0x2006, "UL" },
	{0x50xx, 0x2008, "UL" },
	{0x50xx, 0x200A, "UL" },
	{0x50xx, 0x200C, "OB" },
	{0x50xx, 0x200E, "LT" },
	{0x50xx, 0x2500, "LO" },
	{0x50xx, 0x2600, "SQ" },
	{0x50xx, 0x2610, "US" },
	{0x50xx, 0x3000, "OB" },
	{0x5200, 0x9229, "SQ" },
	{0x5200, 0x9230, "SQ" },
	{0x5400, 0x0100, "SQ" },
	{0x5400, 0x0110, "OW" },
	{0x5400, 0x0112, "OW" },
	{0x5400, 0x1004, "US" },
	{0x5400, 0x1006, "CS" },
	{0x5400, 0x100A, "OW" },
	{0x5400, 0x1010, "OW" },
	{0x5600, 0x0010, "OF" },
	{0x5600, 0x0020, "OF" },
	{0x60xx, 0x0010, "US" },
	{0x60xx, 0x0011, "US" },
	{0x60xx, 0x0012, "US" },
	{0x60xx, 0x0015, "IS" },
	{0x60xx, 0x0022, "LO" },
	{0x60xx, 0x0040, "CS" },
	{0x60xx, 0x0045, "LO" },
	{0x60xx, 0x0050, "SS" },
	{0x60xx, 0x0051, "US" },
	{0x60xx, 0x0052, "US" },
	{0x60xx, 0x0060, "UN" },
	{0x60xx, 0x0100, "US" },
	{0x60xx, 0x0102, "US" },
	{0x60xx, 0x0110, "UN" },
	{0x60xx, 0x0200, "UN" },
	{0x60xx, 0x1001, "CS" },
	{0x60xx, 0x1100, "US" },
	{0x60xx, 0x1101, "US" },
	{0x60xx, 0x1102, "US" },
	{0x60xx, 0x1103, "US" },
	{0x60xx, 0x1200, "US" },
	{0x60xx, 0x1201, "US" },
	{0x60xx, 0x1202, "US" },
	{0x60xx, 0x1203, "US" },
	{0x60xx, 0x1301, "IS" },
	{0x60xx, 0x1302, "DS" },
	{0x60xx, 0x1303, "DS" },
	{0x60xx, 0x1500, "LO" },
	{0x60xx, 0x3000, "OW" },
	{0x60xx, 0x4000, "LT" },
	*/
	{0x7FE0, 0x0010, "OB" },
	{0xFFFA, 0xFFFA, "SQ" },
	{0xFFFC, 0xFFFC, "OB" },
	{0xFFFE, 0xE000, "UN" },
	{0xFFFE, 0xE00D, "UN" },
	{0xFFFE, 0xE0DD, "UN" },
};

// VRԂ
String Element::getVR() const
{
	int dic_size = sizeof( g_dic ) / sizeof( g_dic[0] );

	for( int i=0; i < dic_size; i++ ){
		if( groupID() == g_dic[i].groupID && elementID() == g_dic[i].elementID ){
			return g_dic[i].vr;
		}
	}

	return "";
}

// vf?
bool Element::isStringVR() const
{
	return isStringVR( getVR() );
}

// SQvfH
bool Element::isSQVR() const
{
	if( strcmp( getVR(), "SQ" ) == 0 ){
		return true;
	} else {
		return false;
	}
}


// nꂽ́AVRH
bool Element::isStringVR( const char* vr ) const
{
	if( strcmp( vr, "AE" ) == 0 ||
		strcmp( vr, "AS" ) == 0 ||
		strcmp( vr, "CS" ) == 0 ||
		strcmp( vr, "DA" ) == 0 ||
		strcmp( vr, "DS" ) == 0 ||
		strcmp( vr, "DT" ) == 0 ||
		strcmp( vr, "IS" ) == 0 ||
		strcmp( vr, "LO" ) == 0 ||
		strcmp( vr, "LT" ) == 0 ||
		strcmp( vr, "OF" ) == 0 ||
		strcmp( vr, "PN" ) == 0 ||
		strcmp( vr, "SH" ) == 0 ||
		strcmp( vr, "ST" ) == 0 ||
		strcmp( vr, "TM" ) == 0 ||
		strcmp( vr, "UI" ) == 0 ||
		strcmp( vr, "UT" ) == 0 ){
		return true;
	} else {
		return false;
	}
}