#if !defined(AFX_DICOMFILE_H__001044AA_534E_4FE8_91B8_2B222288D3F6__INCLUDED_)
#define AFX_DICOMFILE_H__001044AA_534E_4FE8_91B8_2B222288D3F6__INCLUDED_

#include <vector>
#include <list>
#include <string>

typedef unsigned int   u_int;
typedef unsigned short u_short;
typedef unsigned char  u_char;

namespace docmi{

class Sequence;
typedef std::vector<Sequence> Sequences;

typedef std::string base_string;

/** operator const char*()std::stringTuNX
 */
class String : public base_string
{
public:
	String(){}
	String(const std::string& rhs): base_string(rhs){}
    String& operator=(const std::string& rhs){
		base_string::operator=(rhs);
		return *this;
	}
    String& operator=(const char* s){
		base_string::operator=(s);
		return *this;
	}

	operator const char*(){ return c_str(); }
};

/** QƃJE^tf[^NX
 */
class ReferenceData
{
	u_char* m_data;
	int     m_length;
	int     m_counter;

	ReferenceData(u_char* data, int length ){
		m_length = length;
		m_data = new u_char[length];
		memcpy( m_data, data, length );
		m_counter = 1;
	}

	ReferenceData( const ReferenceData& rhs );
	ReferenceData& operator=( const ReferenceData& rhs );

	~ReferenceData(){
		delete [] m_data;
	}

public:
	// QƃJE^𑝂₷
	void AddRef(){
		m_counter++;
	}

	// QƃJE^炷
	void Release()
	{
		m_counter--;
		if( m_counter <= 0 ){
			delete this;
		} else {
		}
	}

	// CX^X쐬
	static ReferenceData* Create( u_char* data, int length )
	{
		return new ReferenceData( data, length );
	}

	const u_char* data() const{ return m_data; }
	int length() const{ return m_length; }
};

/** oCif[^ێNX(QƃJE^)
 */
class BinaryData
{
	ReferenceData* m_ref_data;

	void copy( const BinaryData& rhs ){
		rhs.m_ref_data->AddRef();
		m_ref_data->Release();
		m_ref_data = rhs.m_ref_data;
	}

	void setDummyData()
	{
		static bool b_first = true;
		static ReferenceData* dummy_data;
		if( b_first ){
			u_char data[1];
			dummy_data = ReferenceData::Create( data, 0 );
			b_first = false;
		}
		
		m_ref_data = dummy_data;
		m_ref_data->AddRef();
	}
public:
	BinaryData(){
		setDummyData();
	}

	BinaryData( const BinaryData& rhs ){
		setDummyData();
		copy( rhs );
	}

	BinaryData& operator=( const BinaryData& rhs ){
		if( this != &rhs ){
			copy( rhs );
		}
		return *this;
	}

	virtual ~BinaryData(){
		m_ref_data->Release();
	}

	void setData( u_char* data, int length ){
		m_ref_data->Release();
		m_ref_data = ReferenceData::Create( data, length );
	}

	void clear()
	{
		u_char data[1];
		setData( data, 0 );
	}

	const u_char* data() const{ return m_ref_data->data(); }
	int length() const{ return m_ref_data->length(); }
};


/** oCif[^ێNX
 */
 /*
class BinaryData
{
	u_char* m_data;
	int     m_length;
	
	void copy( const BinaryData& rhs ){
		setData( rhs.m_data, rhs.m_length );
	}
public:
	BinaryData():m_data(NULL){
		m_length = 0;
		u_char data[1];
		setData( data, 0 );
	}

	BinaryData( const BinaryData& rhs ):m_data(NULL){
		copy( rhs );
	}

	BinaryData& operator=( const BinaryData& rhs ){
		if( this != &rhs ){
			copy( rhs );
		}
		return *this;
	}

	virtual ~BinaryData(){
		delete [] m_data;
	}

	void setData( u_char* data, int length ){
		delete [] m_data;
		m_data = new u_char[length];
		m_length = length;
		memcpy( m_data, data, length );
	}

	void clear()
	{
		u_char data[1];
		setData( data, 0 );
	}

	const u_char* data() const{ return m_data; }
	int length() const{ return m_length; }
};
*/


/** DICOMvf
 *
 */
class Element : public BinaryData
{
	u_short m_group_id;
	u_short m_element_id;
	Sequences m_sequences;

	void copy( const Element& rhs );
public:

	// RXgN^
	Element( u_short group_id = 0, u_short element_id = 0 ){
		m_group_id = group_id;
		m_element_id = element_id;
	}

	// RXgN^
	Element( const Element& rhs ):BinaryData(rhs){
		copy( rhs );
	}

	// 
	Element& operator=( const Element& rhs ){
		if( this != &rhs ){
			copy( rhs );
			BinaryData::operator=( rhs );
		}
		return *this;
	}

	~Element(){}

	u_short groupID() const{ return m_group_id; }
	u_short elementID() const{ return m_element_id; }
	const Sequence* getSequence( u_int index ) const;

	void setGroupID( u_short group_id ){
		m_group_id = group_id;
	}

	void setElementID( u_short element_id ){
		m_element_id = element_id;
	}

	/** f[^
	 */
	void clear()
	{
		m_group_id = 0;
		m_element_id = 0;
		m_sequences.clear();
		BinaryData::clear();
	}

	String getString() const
	{
		String vr = getVR();
		String value;
		char tmp[256];

		if( isStringVR( vr ) ){
			value.insert( 0, (const char*)data(), length() );
		} else if( strcmp( vr, "UL" ) == 0 ){ // unsigned long
			int count = length() / 4;
			const u_int* p_data = (const u_int*)data();
			
			for( int i=0; i < count; i++ ){
				if( i > 0 ){ value += "\\"; }
				sprintf( tmp, "%u", p_data[i] );
				value += tmp;
			}
		} else if( strcmp( vr, "US" ) == 0 ){ // unsigned short
			int count = length() / 2;
			const u_short* p_data = (const u_short*)data();
			
			for( int i=0; i < count; i++ ){
				if( i > 0 ){ value += "\\"; }
				sprintf( tmp, "%u", p_data[i] );
				value += tmp;
			}
		} else {

			// VCłstd::min<algorithm>ɒ`ĂȂBł
			//int count = std::min( length(), 10 );
			int count = ( length() < 10 )? length(): 10;

			const u_char* p_data = (const u_char*)data();
			
			value = "[";
			for( int i=0; i < count; i++ ){
				if( i > 0 ){ value += " "; }
				sprintf( tmp, "%02X", p_data[i] );
				value += tmp;
			}
			value += "]";
		}

		return value;
	}

	/** V[PXǉ
	 */
	void addSequence( Sequence& s )
	{
		m_sequences.push_back( s );
	}

	const Sequences* getSequences() const
	{
		return &m_sequences;
	}

	// vf?
	bool isStringVR() const;

	// SQvfH
	bool isSQVR() const;

	bool isStringVR( const char* vr ) const;

	// vfVRԂ
	String getVR() const;
};


typedef std::vector<Element> Elements;

/** V[PXiDICOMvfWj
 */
class Sequence : public BinaryData
{
	Elements m_elements;

	void copy( const Sequence& rhs )
	{
		m_elements = rhs.m_elements;
	}

public:

	// RXgN^
	Sequence(){}

	// RXgN^
	Sequence( const Sequence& rhs ):BinaryData(rhs)
	{
		copy( rhs );
	}

	// 
	Sequence& operator=( const Sequence& rhs )
	{
		if( this != &rhs ){
			copy( rhs );
			BinaryData::operator=(rhs);
		}
		return *this;
	}

	~Sequence(){}

	/** vfToARs[Ԃ
	 */
	Element search_copy( u_short group_id, u_short element_id ) const{

		const Element* e = search( group_id, element_id );
		if( e ){
			return *e;
		} else {
			Element e( group_id, element_id );
			return e;
		}
	}

	/** vfToAǂݎp̃|C^Ԃ
	 */
	const Element* search( u_short group_id, u_short element_id ) const{

		for( Elements::const_iterator it=m_elements.begin(); it != m_elements.end(); ++it ){
			if( it->groupID() == group_id &&
				it->elementID() == element_id ){
				return it;
			}
		}

		return NULL;
	}

	void clear()
	{
		m_elements.clear();
		BinaryData::clear();
	}

	void addElement( const Element& e )
	{
		m_elements.push_back( e );
	}

	String getString( u_short group_id, u_short element_id ) const
	{
		const Element* e = search( group_id, element_id );
		if( e ){ return e->getString();	}
		else   { return ""; }
	}

	const Elements* getElements() const
	{
		return &m_elements;
	}
};


} // namespace docmi

#endif // !defined(AFX_DICOMFILE_H__001044AA_534E_4FE8_91B8_2B222288D3F6__INCLUDED_)
