#ifndef INCLUDE_FILE_READER_H
#define INCLUDE_FILE_READER_H

#include "Element.h"
#include "filesize.h"

namespace docmi {

class Exception{
public:
	void message(){}
	int  code(){ return 0; }
};

class FileReader  
{
	enum FILETYPE {
		TYPE_EXPLICIT_LITTLE,
		TYPE_IMPLICIT_LITTLE,
		TYPE_NOPREAMBLE
	};

	int m_file_type;
	int m_file_len;
public:
	FileReader(){};
	~FileReader(){};

	// 4oCgVRH
	bool is4ByteLengthVR( u_char* vr ){
		if( memcmp( vr, "OB", 2 ) == 0 ||
			memcmp( vr, "OW", 2 ) == 0 ||
			memcmp( vr, "SQ", 2 ) == 0 ||
			memcmp( vr, "UN", 2 ) == 0 ){
			return true;
		}

		return false;
	}

	// V[PXVRH
	bool isVR_SQ( u_char* vr ){
		if( memcmp( vr, "SQ", 2 ) == 0 ){
			return true;
		}

		return false;
	}

	// t@CvAu邩H
	bool checkPreamble( FILE* f )
	{
		fseek( f, 128, SEEK_SET );

		u_char tmp[4];
		readFile( tmp, 4, f );
		fseek( f, 0, SEEK_SET );

		if( memcmp( tmp, "DICM", 4 ) == 0 ){
			m_file_type = TYPE_EXPLICIT_LITTLE;
			return true;
		} else {
			m_file_type = TYPE_NOPREAMBLE;
			return false;
		}
	}


public:
	/** DICOMt@CJ
	 *
	 *  throw Exception
	 */
	void open( Sequence& data, const char* path ){

		data.clear();

		FILE* f = fopen( path, "rb" );
		if( !f ){
			Exception x;
			throw x;
		}

		m_file_len = GetFileSize( path );

		try{
			// t@CvAu𒲂ׂ
			if( checkPreamble( f ) ){
				// t@CvAuǂݔ΂
				fseek( f, 132, SEEK_SET );
			}

			// vfǂݍ
			Element e;

			while( readElement( f, e ) ){
				data.addElement( e );
			}
		} catch( Exception& x ){
			fclose( f );
			throw x;
		}

		fclose( f );
	}

private:

	// t@Cw肳ꂽ̃f[^ǂݍ
	void readFile( u_char* buf, u_int length, FILE* f ){
		if( fread( buf, 1, length, f ) < length ){
			Exception x;
			throw x;
		}
	}

	/** JvZf[^ǂݍ
	 *
	 *  E(7fe0,0010)̒-1̂ƂA摜f[^͕(fffe,e000)Ɋi[
	 *
	 *  JvZf[^tH[}bg
	 *  -----------------------------------------------
	 *  e0 7f 01 00 ff ff ff ff 00 e0 fe ff 04 00 00 00
	 *  00 30 00 00 00 e0 fe ff 00 10 00 00 ...
	 *  -----------------------------------------------
	 *  
     *  (7fe0,0010)     -1
	 *  (fffe,e000)      4 0x3000    : ڂ̃f[^̓JvZf[^̐擪ւ̃ItZbg
	 *  (fffe,e000) 0x1000 ...
	 *   .
	 *   .
	 *  (fffe,e0dd)      0           : I[^O
	 *
	 *  throw Exception
	 */
	int readCupsuleData( FILE* f, Element& e )
	{
		Sequence s;
		int length = 0; // ǂݍ񂾃t@C

		while( 1 ){
			
			u_char tmp[4];
			s.clear();

			readFile( tmp, 4, f );
			length += 4;

			// ^Oǂݍ
			u_short group_id   = ((u_short*)tmp)[0];
			u_short element_id = ((u_short*)tmp)[1];

			// I[^OH
			if( group_id == 0xfffe && element_id == 0xe0dd ){
				fseek( f, 4, SEEK_CUR );
				length += 4;
				break;
			}

			// f[^^OH
			if( group_id != 0xfffe || element_id != 0xe000 ){
				Exception x;
				throw x;
			}

			// f[^ǂݍ
			int data_length = read4byteLength( f );
			length += 4;

			// f[^0ȏォH
			if( data_length < 0 ){
				Exception x;
				throw x;
			}

			// f[^ǂݍ
			u_char* data = new u_char[data_length];
			readFile( data, data_length, f );
			length += data_length;
			s.setData( data, data_length );
			delete [] data;

			e.addSequence( s );
		}

		return length;
	}

	/** t@CAV[PX\̒gǂݍ
	 *  @retval : ǂݍ񂾃f[^TCY
	 *  throw Exception
	 */
	int readSequenceBody( FILE* f, Sequence& s, int sequence_length )
	{
		Element e;
		int element_length;
		int length = 0;

		// I
		if( sequence_length > 0 ){
			
			while( sequence_length > 0 ){
				if( !readElement( f, e, element_length ) ){
					Exception x;
					throw x;
				}
				s.addElement( e );
				length += element_length;
				sequence_length -= element_length;

				// V[PX𒴂
				if( sequence_length < 0 ){
					Exception x;
					throw x;
				}
			}

		// ÖٓI
		} else {
			while( 1 ){
				if( !readElement( f, e, element_length ) ){
					Exception x;
					throw x;
				}
				length += element_length;

				// V[PXI^OH
				if( e.groupID() == 0xfffe && e.elementID() == 0xe00d ){
					break;
				}

				s.addElement( e );
			}
		}

		return length;
	}

	/** t@CAV[PX\ǂݍ(Io[W)
	 *  @retval : ǂݍ񂾃f[^TCY
	 *  throw Exception
	 */
	int readOneSequence( FILE* f, Sequence& s )
	{
		int length = 0; // ǂݍ񂾃t@C
		u_char tmp[4];

		s.clear();

		readFile( tmp, 4, f );
		length += 4;

		// ^Oǂݍ
		u_short group_id = ((u_short*)tmp)[0];
		u_short element_id = ((u_short*)tmp)[1];

		// V[PXJn^OH
		if( group_id != 0xfffe || element_id != 0xe000 ){
			Exception x;
			throw x;
		}

		// f[^ǂݍ
		int sequence_length = read4byteLength( f );
		length += 4;

		length += readSequenceBody( f, s, sequence_length );
		return length;
	}

	/** t@CAV[PX\ǂݍ(ÖٓIo[W)
     *  @retval : ǂݍ񂾃f[^TCY
	 *  throw Exception
	 */
	int readOneSequenceImplicitLength( FILE* f, Sequence& s, bool& b_finish )
	{
		int length = 0; // ǂݍ񂾃t@C
		u_char tmp[4];
		b_finish = false;

		s.clear();

		readFile( tmp, 4, f );
		length += 4;

		// ^Oǂݍ
		u_short group_id = ((u_short*)tmp)[0];
		u_short element_id = ((u_short*)tmp)[1];

		// V[PXWI^OH
		if( group_id == 0xfffe && element_id == 0xe0dd ){
			fseek( f, 4, SEEK_CUR );
			length += 4;
			b_finish = true;
			return length;
		}

		// V[PXJn^OH
		if( group_id != 0xfffe || element_id != 0xe000 ){
			Exception x;
			throw x;
		}

		// f[^ǂݍ
		int sequence_length = read4byteLength( f );
		length += 4;

		length += readSequenceBody( f, s, sequence_length );
		return length;
	}
 
	/** V[PX^O̓eǂݍ
	 *
	 *  @retval : ǂݍ񂾃f[^TCY
	 *  throw Exception
	 */
	int readSequence( FILE* f, Element& sequence_element, int length )
	{
		Sequence s;

		if( length >= 0 ){
			int rest = length;
			while( rest > 0 ){		
				int sequence_length = readOneSequence( f, s );
				sequence_element.addSequence( s );
				rest -= sequence_length;
			}
			return length;
		} else {
			int read_length = 0;
			while( 1 ){
				bool b_finish;
				read_length += readOneSequenceImplicitLength( f, s, b_finish );
				if( b_finish ){
					return read_length;
				}

				sequence_element.addSequence( s );
			}
		}
	}

	/** vfǂ݂
	 * @retval true : 
	 * @retval false : t@C̏I
	 *
	 * throw Exception
	 */
	bool readElement( FILE* f, Element& e ){
		int length = 0;
		return readElement( f, e, length );
	}

	/** 4oCg̃f[^ǂ݂
	 *
	 *  throw Exception
	 */
	int read4byteLength( FILE* f )
	{
		u_char tmp[4];
		readFile( tmp, 4, f );
		u_int ulength = *((u_int*)tmp);
		if( ulength == 0xffffffff ){
			return -1;
		} else {
			return ulength;
		}
	}

	/** 2oCg̃f[^ǂ݂
	 *
	 *  throw Exception
	 */
	int read2byteLength( FILE* f )
	{
		u_char tmp[2];
		readFile( tmp, 2, f );
		u_short ulength = *((u_short*)tmp);
		if( ulength == 0xffff ){
			return -1;
		} else {
			return ulength;
		}
	}
		

	/** vfǂݍ
	 * @retval true : 
	 * @retval false : t@C̏I
	 *
	 * thrown Exception
	 */
	bool readElement( FILE* f, Element& e, int& read_length ){
		u_char tmp[4];
		bool b_success = true;
		u_char* data = NULL;
		read_length = 0;

		e.clear();

		try{
			readFile( tmp, 4, f );
			read_length += 4;
		} catch( Exception& x ){
			// ^OǂݍޑOɃt@CI
			int error = x.code();
			return false;
		}

		e.setGroupID( ((u_short*)tmp)[0] );
		e.setElementID( ((u_short*)tmp)[1] );

		try{
			bool b_seaquence;
			int length;

			if( m_file_type == TYPE_EXPLICIT_LITTLE ||
				( m_file_type == TYPE_IMPLICIT_LITTLE && e.groupID() == 0x0002 ) ){ // IVRvf

				// VRif[^jǂݍ
				u_char vr[2];
				readFile( vr, 2, f );
				read_length += 2;

				if( is4ByteLengthVR( vr ) ){
					fseek( f, 2, SEEK_CUR );
					length = read4byteLength( f );
					read_length += 6;
				} else {
					length = read2byteLength( f );
					read_length += 2;
				}

				b_seaquence = isVR_SQ( vr );
			} else { // ÖٓIVRvf
				length = read4byteLength( f );
				read_length += 4;
				b_seaquence = e.isSQVR();
			}

			if( b_seaquence ){
				// V[PX^Oǂݍ
				readSequence( f, e, length );
				read_length += length;

			} else {
				
				if( length == -1 ){
					if( e.groupID() == 0x7fe0 && e.elementID() == 0x0010 ){
						// JvZf[^ǂݍ
						read_length += readCupsuleData( f, e );
					} else {
						Exception x;
						throw x;
					}
				} else if( length < 0 ){ // f[^O
					Exception x;
					throw x;
				} else if( length > m_file_len ){ // f[^t@Cȏ
					Exception x;
					throw x;
				} else {

					// f[^ǂݍ
					u_char* data = new u_char[length];
					readFile( data, length, f );
					read_length += length;

					e.setData( data, length );
					delete [] data;

					if( e.groupID() == 0x0002 && e.elementID() == 0x0010 ){
						if( strcmp( e.getString(), "1.2.840.10008.1.2" ) == 0 &&
							m_file_type != TYPE_NOPREAMBLE ){
							m_file_type = TYPE_IMPLICIT_LITTLE;
						}
					}
				}
			}

		} catch( Exception& x ){
			x.message();
			b_success = false;
		}

		delete [] data;

		if( !b_success ){
			Exception x;
			throw x;
		} else {
			return true;
		}
	}

};

} // namespace docmi

#endif
