﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;
using ClipClop.Properties;

namespace ClipClop.User
{
	/// <summary>
	/// 定型文定義XMLファイルの文字列定義（要素名と属性名、それらの値）
	/// </summary>
	public abstract class ContextMenuSettingDefinition
	{
		public enum SentenceType
		{
            /// <summary>
            /// 定義されない値
            /// </summary>
            non = -1,

			/// <summary>
			/// 定型テキスト
			/// </summary>
			template,

			/// <summary>
			/// テキスト保管...現状未対応
			/// </summary>
			//textfile,

			/// <summary>
			/// アプリケーション実行
			/// </summary>
			execute,

			/// <summary>
			/// クリップボード履歴
			/// </summary>
			clipboardhistory,

			/// <summary>
			/// メニュー定義ファイルの編集
			/// </summary>
			editfile,

			/// <summary>
			/// 値を二つ持つ定型テキスト
			/// </summary>
			complex,
		}

		//enumと文字列の対応表
		public static readonly KeyValuePair<string, SentenceType>[] SentenceTypeNamestrings 
			= new KeyValuePair<string, SentenceType>[] 
			{
				new KeyValuePair<string, SentenceType>( global::ClipClop.Properties.Resources.CmbTemplate, SentenceType.template ),
				new KeyValuePair<string, SentenceType>( global::ClipClop.Properties.Resources.CmbExecute, SentenceType.execute ),
				new KeyValuePair<string, SentenceType>( global::ClipClop.Properties.Resources.CmbClipboardhistory, SentenceType.clipboardhistory ),
				new KeyValuePair<string, SentenceType>( global::ClipClop.Properties.Resources.CmbEditfile, SentenceType.editfile ),
				new KeyValuePair<string, SentenceType>( global::ClipClop.Properties.Resources.CmbComplex, SentenceType.complex )
			};



		public enum Classification
		{
            root = -1,
            sentence,
			folder,
			separator,
		}

        public static readonly string Root_ = Classification.root.ToString();
        public static readonly string Separator_ = Classification.separator.ToString();
		public static readonly string Folder_ = Classification.folder.ToString();
		public static readonly string Sentence_ = Classification.sentence.ToString();

		public const string Image_ = "image";
		public const string Name_ = "name";
		public const string Value_ = "value";
		/// <summary>
		/// passwordに相当する部分
		/// </summary>
		public const string Latter_ = "latter";
		public const string Type_ = "type";


		/// <summary>
		/// 定型文定義XMLファイルのバージョン
		/// </summary>
		public const int CurrnetVersion = 0x00080000;//初期フォーマット

		/// <summary>
		/// 定型文定義XMLファイルであることの証明をする文字列
		/// </summary>
		public const string MagicNumber = "Heizaemon";

		/// <summary>
		/// root要素の属性
		/// </summary>
		public enum RootAttribute
		{
			version,
			magicnumber,
			encryption,
		}

		public static string GetCurrentVersion()
		{
			return string.Format("0x{0:X8}", ContextMenuSettingDefinition.CurrnetVersion);
		}

		public static string GetXsdFilePath()
		{
			return Path.Combine(Path.GetDirectoryName(Application.ExecutablePath), Settings.Default.XsdFileName);
		}

	}
}
