/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|                      ->>  Copyright 2008 Odonata <<-                         |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1772 $
|                     $Date: 2008-10-09 11:57:03 +0200 (jeu., 09 oct. 2008) $
\*============================================================================*/

/***************************************************************************//**
* \file
* HTTP server plug-in interface.
* This API defines what should be implemented for external HTTP server integration.
*******************************************************************************/

#ifndef DC_DPWSREQUEST_H_
#define DC_DPWSREQUEST_H_

#include "dc/dc_Ctypes.h"

#ifndef DC_RT_FMAC1	/* runtime functions declaration prefix */
# define DC_RT_FMAC1
#endif

#define DC_SOAP_RESPONSE		200
#define DC_SOAP_EMPTY_RESPONSE	202
#define DC_SOAP_SENDER_ERROR	400
#define DC_SOAP_RECEIVER_ERROR	500

/* Forward declaration to avoid include dependency */
struct dpws;

/** HTTP/MIME media type attribute node. */
typedef struct media_type_param {
	struct media_type_param * next;	/**< Pointer on the next node of the list */
	const char * attribute;	/**< Attribute name */
	const char * value;	/**< Attribute value */
} media_type_param_t;

/** HTTP/MIME media type information */
typedef struct media_type {
	const char * type;	/**< content type */
	const char * subtype;	/**< content subtype */
	media_type_param_t* params;	/**< Attribute list */
} media_type_t;

/** Plugin definition.
 */
typedef struct transport_fns {
	/**
	 * Callback function used by the SOAP engine to write outgoing response data.
	 * Note: it is the responsibility of the transport layer to provide buffering.
	 * @param dpws the dpws struct associated to the current request
	 * @param transport_data the opaque transport-specific parameter associated to the request
	 * @param buf a pointer to the beginning of the buffer to be written
	 * @param buflen the number of characters to be written
	 * @return the number of written characters, or -1 in case of error.
	 */
	int (*fsend)(struct dpws * dpws, void * transport_data, const char * buf, size_t buflen);

	/**
	 * Callback function used by the SOAP engine to read incoming request data.
	 * @param dpws the dpws struct associated to the current request
	 * @param transport_data the opaque transport-specific parameter associated to the request
	 * @param buf a pointer to the beginning of the buffer where read data can be stored
	 * @param buflen the size of the buffer
	 * @return the number of read characters, or -1 in case of error.
	 */
	int (*frecv)(struct dpws * dpws, void * transport_data, char * buf, size_t buflen);

	/**
	 * Callback function used by the SOAP engine to notify the transport layer that it is starting the response.
	 * @param dpws the dpws struct associated to the current request
	 * @param transport_data the opaque transport-specific parameter associated to the request
	 * @param status a parameter that can take four values: DC_SOAP_RESPONSE, DC_SOAP_EMPTY_RESPONSE, DC_SOAP_SENDER_FAULT, DC_SOAP_RECEIVER_FAULT.
	 * @param mtype the content type of the response.
	 * @param len the length of the response contents if known, otherwise 0.
	 * @return 0 on success, -1 on error
	 */
	int (*fresponse)(struct dpws * dpws, void * transport_data, int status, media_type_t * mtype, size_t len);
} transport_fns_t;

/** This function processes a single (HTTP) SOAP request.
 * It can be called from within the HTTP POST processing function of a Web server.
 * The parameters of this function provide the SOAP processing engine with all necessary information to process the request.
 * @param dpws the dpws struct associated to the current request
 * @param transport_data an opaque parameter that will be returned in callback functions. Can be used to associate request-specific transport information
 * to the SOAP request.
 * @param fns a structure containing the three required callback functions for request processing.
 * @param host the host information, as found in the "Host" HTTP header
 * @param path the context URL, as found in the HTTP request line. Must be a relative URL
 * @param mtype the content type of the request
 * @param action the contents of the optional "SOAPAction" HTTP header
 * @param needs_length a Boolean indicating to the SOAP processor that it must provide the response length.
 * @return 0 on success, an error code when an error occurred. 
 */
DC_RT_FMAC1 int dpws_dispatch_request(struct dpws * dpws, void * transport_data, transport_fns_t * fns, const char * host, const char * path, media_type_t * mtype, const char * action, DC_BOOL needs_length);

#endif
