/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* Dynamic Deployment dynamic loader registration API.
* Register a dynamic loader for the dynamic deployment server feature that
* provides, using an incomplete WS-Management implementation, a framework to
* deploy dynamically services.
*******************************************************************************/

#ifndef DYNDEPL_H_
#define DYNDEPL_H_

#ifndef DC_RT_FMAC1	/* runtime functions declaration prefix */
# define DC_RT_FMAC1
#endif

#ifdef __cplusplus
extern "C" {
#endif

/** A callback for DPWSCore configuration change.
 */
typedef void (*config_cbk) ();

/** Register a the dynamic loader for the dynamic deployment service itself.
 * @return DPWS_OK or a DPWSCore error code if an error occured.
 */
DC_RT_FMAC1 int dpws_register_dyndepl_loader();

/** Register a callback called when configuration changed because of dynamic
 * deployment service operations.
 * @param cbk The "configuration changed" callback.
 * @return DPWS_OK or a DPWSCore error code if an error occured.
 */
DC_RT_FMAC1 int dpws_register_config_cbk(config_cbk cbk);

#ifdef __cplusplus
}
#endif

#endif /*DYNDEPL_H_*/
