/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1530 $
|                     $Date: 2008-07-23 14:42:45 +0200 (mer., 23 juil. 2008) $
\*============================================================================*/

/***************************************************************************//**
* \file
* DPWSCore error codes.
*******************************************************************************/

#ifndef DC_ERROR_H_
#define DC_ERROR_H_


#define DPWS_OK										0	/**< No error code. */

/***************************************************************************//**
* \name Local error codes
* Raised when the error occurs in the current program. No message available.
* @{
*******************************************************************************/

/** \name DPWS Runtime errors
 * These code extend gSOAP error codes.
 * @{
 */
#define DPWS_ERR_EOM								SOAP_EOM	// NOTE: -1 reserved for SOAP_EOF
#define DPWS_ERR_RETRIEVING_NETWORK_INTERFACE_INFO	-2	/**< System error while retrieving network interfaces information. */
#define DPWS_ERR_NO_NETWORK_INTERFACE				-3	/**< No interface did match the supplied IP selector. */
#define DPWS_ERR_CREATING_MUTEX						-4	/**< System error while creating mutex for the stack. */
#define DPWS_ERR_UNSUPPORTED_METADATA_SECTION		-5	/**< A received WS-MetadataExchange could not be read. */
#define DPWS_ERR_COULD_NOT_MATCH_DIRECTED_PROBE		-6	/**< Returned by \a dpws_serve when a received directed probe did not match. */
#define DPWS_ERR_SERVER_TIMEOUT						-7	/**< Returned by dpws_accept_XXX APIs when a gSOAP timeout has been set and reached by the user on the runtime structure. */
#define DPWS_ERR_SERVER_STOPPED						-8	/**< Returned by \a dpws_accept_XXX when the server loop has been stopped voluntarily. */
#define DPWS_ERR_INTERNAL_ERROR						-9	/**< Unexpected generic error. */
#define DPWS_ERR_ILLEGAL_STATE						-10	/**< Unexpected software state. For instance, the device is already enabled while we're trying to enable it. */
// @}

/** \name Socket errors
 * Platform-specific error code are available in gSOAP runtime structure (ernum
 * member).
 * @{
 */
#define DPWS_ERR_COULD_NOT_SET_REUSE_ADDR_OPTION	-20	/**< Could not set the "SO_REUSEADDR" option on a socket. */
#define DPWS_ERR_COULD_NOT_BIND_SOCKET				-21	/**< Error while binding socket. */
#define DPWS_ERR_COULD_NOT_JOIN_MULTICAST_GROUP		-22	/**< Error while joining an IP multicast group. */
#define DPWS_ERR_COULD_NOT_SELECT_MULTICAST_NETIF	-23	/**< Error while selecting the output multicast interface. */
#define DPWS_ERR_COULD_NOT_CREATE_SOCKET			-24	/**< Could not create IP socket. */
#define DPWS_ERR_SOCKET_ERROR						-25 /**< Default socket error. */
// @}

/** \name API errors
 * @{
 */
#define DPWS_ERR_INVALID_PARAMETER					-100	/**< A provided parameter has an unexpected value. */
#define DPWS_ERR_NB_DEVICES_EXCEEDS_CACHE_SIZE		-101	/**< The required number of devices is bigger that the setting for cache size. */
#define DPWS_ERR_MISSING_MANUFACTURER				-102	/**< The required DPWS "manufacturer" device metadata was not set. */
#define DPWS_ERR_MISSING_MODEL_NAME					-103	/**< The required DPWS "model name" device metadata was not set. */
#define DPWS_ERR_MISSING_FRIENDLY_NAME				-104	/**< The required DPWS "friendly name" device metadata was not set. */
#define DPWS_ERR_MISSING_BOOT_SEQUENCE				-105	/**< A boot number must be supplied to the toolkit especially to manage WS-Discovery AppSequence. */
#define DPWS_ERR_NO_HANDLE_FOUND					-106	/**< The handle reference supplied is not valid (no handle could be retrieved). */
#define DPWS_ERR_NO_SUCH_ATT_ON_OBJECT				-107	/**< The object has no such attribute type. */
#define DPWS_ERR_MONOVALUED_ATT_TYPE				-108	/**< A single value attribute has been accessed using a multiple value API. */
#define DPWS_ERR_CONFLICTING_OPERATION				-109	/**< The action has conflicted with a previous one. For instance setting an attribute that should be unique could raise such an error. */
#define DPWS_ERR_IMMUTABLE_USED_OBJECT				-110	/**< The object is currently read-only and cannot be modified. */
#define DPWS_ERR_INVALID_NS							-111	/**< The supplied QName has an invalid namespace. */
#define DPWS_ERR_UNCOMPLETE_SERVICE					-113	/**< Some mandatory attributes are missing for the service (types, dispatch functions). */
#define DPWS_ERR_INVALID_PROXY						-114	/**< The handle reference does not point to a valid proxy. */
#define DPWS_ERR_UNSUPPORTED_VERSION				-116	/**< No supported DPWS version could be selected. */
#define DPWS_ERR_DEVICE_NOT_CLONED					-117	/**< The device cannot replace an online one since it was not cloned. */
#define DPWS_ERR_IS_A_DEVICE						-118	/**< The used API targets a service proxy but was called on a device proxy. */
#define DPWS_ERR_IS_A_HOSTED_SERVICE				-119	/**< The used API targets a device proxy but was called on a service proxy. */
#define DPWS_ERR_MORE_RESULTS						-120	/**< The provided parameter for results is not big enough to receive all results. */
#define DPWS_ERR_INIT_SERVER						-121	/**< The stack has not been initialized for server operations. */
#define DPWS_ERR_COULD_NOT_FIND_CACHE_ENTRY			-122	/**< The cache entry could not retrieved using the provided criteria. */
#define DPWS_ERR_COULD_NOT_RESOLVE_ADDRESS			-123	/**< A silent resolve message was performed and failed. */
// @}

// @}

/***************************************************************************//**
* \name Built-in fault error codes
* Set by a built-in skeleton or a user service so that automatic fault setting
* is performed.
* @{
*******************************************************************************/

/** \name WS-Addressing faults error codes
 * @{
 */
#define MIN_WSA_ERROR 							1000
#define WSA_ERR_INVALID_HEADER_INFO_MESSAGE_ID	1001
#define WSA_ERR_INVALID_HEADER_INFO_RELATES_TO	1002
#define WSA_ERR_INVALID_HEADER_INFO_TO			1003
#define WSA_ERR_INVALID_HEADER_INFO_ACTION		1004
#define WSA_ERR_INVALID_HEADER_INFO_FROM		1005
#define WSA_ERR_INVALID_HEADER_INFO_REPLY_TO	1006
#define WSA_ERR_INVALID_HEADER_INFO_FAULT_TO	1007
#define WSA_ERR_REQUIRED_HEADER_INFO			1011
#define WSA_ERR_DESTINATION_UNREACHABLE			1012
#define WSA_ERR_ACTION_NOT_SUPPORTED			1013
#define WSA_ERR_ENDPOINT_UNAVAILABLE			1014
#define WSA_ERR_SOAP_FAULT						1015	// replaces the gSOAP SOAP_FAULT code when a custom WS-Addressing fault action has been set and must supersede the default one
// @}

/** \name WS-Eventing faults error codes
 * @{
 */
#define MIN_WSE_ERROR								1100
#define WSE_ERR_DELIVERY_MODE_REQUESTED_UNAVAILABLE	1101
#define WSE_ERR_INVALID_EXPIRATION_TIME				1102
#define WSE_ERR_UNSUPPORTED_EXPIRATION_TYPE			1103
#define WSE_ERR_FILTERING_NOT_SUPPORTED				1104
#define WSE_ERR_FILTERING_REQUESTED_UNAVAILABLE		1105
#define WSE_ERR_EVENT_SOURCE_UNABLE_TO_PROCESS		1106
#define WSE_ERR_UNABLE_TO_RENEW						1107
#define WSE_ERR_INVALID_MESSAGE						1108
#define WSE_ERR_INVALID_SUBSCRIPTION				1109	// not standard: re-routed to INVALID message
#define WSE_ERR_INVALID_SUBSCRIPTION_ID				1110	// not standard: re-routed to INVALID message
// @}

// @}

#endif /*DC_ERROR_H_*/
